/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.management.MBeanServer;

public class StartCommand
implements Command {
    private ClusterMonitor cm;
    private int currentClusterID;
    private String sName;
    private MBeanServer server;

    public StartCommand(ClusterMonitor cm, MBeanServer server) {
        this.cm = cm;
        this.server = server;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        boolean notFound;
        PrintWriter err = new PrintWriter(env.getErrorStream(), true);
        int clusterID = this.currentClusterID;
        if (params.length == 0) {
            err.println("\r\n[Shell -> STARTSERVICE] Missing service name!\r\n");
            return;
        }
        if (params.length == 1) {
            if (params[0].equalsIgnoreCase("-h") || params[0].equals("-?") || params[0].equalsIgnoreCase("-help")) {
                new PrintWriter(os, true).println(this.getHelpMessage());
                return;
            }
            this.sName = params[0];
        } else {
            if (params.length > 2) {
                err.println("\r\n[Shell -> STARTSERVICE] Too much parameters !\r\n");
                return;
            }
            try {
                clusterID = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException e) {
                err.println("\r\n[Shell -> STARTSERVICE] Invalid ID!\r\n");
                return;
            }
            this.sName = params[1];
        }
        ClusterElement[] clusterElements = this.cm.getParticipants();
        boolean bl = notFound = clusterID != this.currentClusterID;
        if (clusterID == 0) {
            notFound = false;
        } else {
            int i = 0;
            while (i < clusterElements.length) {
                if (clusterElements[i].getClusterId() == clusterID) {
                    notFound = false;
                    break;
                }
                ++i;
            }
        }
        if (notFound) {
            err.println("\r\n[Shell -> STARTSERVICE] There is no such cluster ID : " + clusterID + "\r\n");
            return;
        }
        if (clusterID == 0) {
            try {
                this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)this.sName, (String)String.valueOf(this.cm.getCurrentParticipant().getClusterId()), (String)"\"\""), "start", new Object[0], new String[0]);
            }
            catch (Exception e) {
                err.println("[Shell -> STARTSERVICE] There is no such service " + this.sName);
            }
            int i = 0;
            while (i < clusterElements.length) {
                try {
                    this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)this.sName, (String)String.valueOf(clusterElements[i].getClusterId()), (String)"\"\""), "start", new Object[0], new String[0]);
                }
                catch (Exception e) {
                    err.println("[Shell -> STARTSERVICE] There is no such service " + this.sName + " on cluster element " + clusterElements[i].getClusterId());
                }
                ++i;
            }
        } else {
            try {
                this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)this.sName, (String)String.valueOf(clusterID), (String)"\"\""), "start", new Object[0], new String[0]);
            }
            catch (Exception ex) {
                err.println("\r\n[Shell -> STARTSERVICE] Could not start the service '" + this.sName + "'!");
                err.println("[Shell -> STARTSERVICE] Reason : " + ex.getMessage() + "\r\n");
            }
        }
    }

    public String getHelpMessage() {
        return "\r\nStarts a service on the specified cluster element.\r\nUsage: STARTSERVICE [ClusterID] <serviceName>\r\nParameters:\r\n  [ClusterID] - ID of the cluster element on which to start the specified\r\n                service. Default value is the ID of the current cluster element.\r\n                If [ClusterID] is set to 0, the service starts on all cluster \r\n                elements.\r\n  <serviceName> - The name of the service to be started.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "STARTSERVICE";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

