/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.management.MBeanServer;

public class ShutDownCommand
implements Command,
Runnable {
    private ServiceContext sc;
    private ClusterMonitor cm;
    private int currentClusterID;
    private int clusterID;
    private int timeout;
    private MBeanServer server;
    private PrintWriter err;

    public ShutDownCommand(ServiceContext sc, ClusterMonitor cm, MBeanServer server) {
        this.sc = sc;
        this.cm = cm;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
        this.server = server;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        this.err = new PrintWriter(env.getErrorStream(), true);
        this.clusterID = this.currentClusterID;
        this.timeout = 0;
        if (params.length > 3) {
            this.err.println("\r\n[Shell -> SHUTDOWN] Wrong number of parameters.\r\n");
            return;
        }
        if (params.length != 0) {
            if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                new PrintWriter(os, true).println(this.getHelpMessage());
                return;
            }
            if (params[0].equalsIgnoreCase("-mark")) {
                if (params.length == 1) {
                    this.err.println("\r\n[Shell -> SHUTDOWN] The time is not specified.\r\n");
                    return;
                }
                try {
                    this.timeout = Integer.parseInt(params[1]);
                }
                catch (NumberFormatException e) {
                    this.err.println("\r\n[Shell -> SHUTDOWN] Invalid time!\r\n");
                    return;
                }
                if (params.length == 3) {
                    try {
                        this.clusterID = Integer.parseInt(params[2]);
                    }
                    catch (NumberFormatException e) {
                        this.err.println("\r\n[Shell -> SHUTDOWN] Invalid ID!\r\n");
                        return;
                    }
                }
            } else {
                try {
                    this.clusterID = Integer.parseInt(params[0]);
                }
                catch (NumberFormatException e) {
                    this.err.println("\r\n[Shell -> SHUTDOWN] Invalid ID!\r\n");
                    return;
                }
            }
        }
        if (this.clusterID == 0 || this.correctClusterID()) {
            if (this.timeout > 0) {
                if (this.clusterID == 0) {
                    new PrintWriter(os, true).println("\r\n[Shell -> SHUTDOWN] All cluster elements will be shut down after " + this.timeout + " seconds.");
                } else {
                    new PrintWriter(os, true).println("\r\n[Shell -> SHUTDOWN] Cluster element " + this.clusterID + " will be shut down after " + this.timeout + " seconds.");
                }
                this.timeout *= 1000;
                new Thread(this).start();
            } else {
                this.run();
            }
        } else {
            this.err.println("\r\n[Shell -> SHUTDOWN] There is no such cluster ID : " + this.clusterID + "\r\n");
        }
    }

    public void run() {
        if (this.timeout > 0) {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                this.err.println("\r\n[Shell -> SHUTDOWN] Can not wait more.");
                this.err.println("[Shell -> SHUTDOWN] Reason : " + e.getMessage() + "\r\n");
            }
        }
        if (this.clusterID == this.currentClusterID) {
            this.sc.getCoreContext().getCoreMonitor().shutDown();
        } else if (this.clusterID == 0) {
            ClusterElement[] clusterElements = this.cm.getParticipants();
            int i = 0;
            while (i < clusterElements.length) {
                int tmpID = clusterElements[i].getClusterId();
                if (tmpID != this.clusterID) {
                    try {
                        this.server.invoke(ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(tmpID), (String)"\"\""), "shutdown", new Object[0], new String[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
            this.sc.getCoreContext().getCoreMonitor().shutDown();
        } else {
            try {
                this.server.invoke(ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(this.clusterID), (String)"\"\""), "shutdown", new Object[0], new String[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean correctClusterID() {
        if (this.clusterID != this.currentClusterID) {
            ClusterElement[] clusterElements = this.cm.getParticipants();
            int i = 0;
            while (i < clusterElements.length) {
                if (clusterElements[i].getClusterId() == this.clusterID) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public String getHelpMessage() {
        return "\r\nShuts down a cluster element or the whole cluster.\r\nUsage: SHUTDOWN [-mark <timeout>] [ClusterID]\r\nParameters:\r\n  [-mark <timeout>] - Time in seconds to wait before shutting down.\r\n  [ClusterID] - ID of the element to shut down. Default value is the ID of the\r\n                current cluster element. If [ClusterID] is set to 0, shuts down\r\n                the whole cluster.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "SHUTDOWN";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

