/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.session.PortNamePair;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ListUsedPortsCommand
implements Command {
    private ServiceContext sc;
    private String nl;
    private int currentId;

    public ListUsedPortsCommand(ServiceContext sc, int currentId) {
        this.sc = sc;
        this.currentId = currentId;
        this.nl = SystemProperties.getProperty((String)"line.separator");
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length > 0) {
            pw.println(this.getHelpMessage());
            return;
        }
        int clusterId = this.currentId;
        pw.println(this.nl + "LSP: Used Ports by the current cluster element" + this.nl);
        pw.println("\tPorts used by the ClusterManager: ");
        try {
            Object portsManager = this.sc.getCoreContext().getReflectContext().getCoreComponent("PortsManager");
            Method usedPortsMethod = portsManager.getClass().getMethod("getUsedPorts", null);
            PortNamePair[] pairs = (PortNamePair[])usedPortsMethod.invoke(portsManager, null);
            this.printPairs(pw, pairs);
        }
        catch (Exception e) {
            pw.println("\t\t[Shell -> LSP] Can not obtain used ports from ClusterManager !");
            pw.println("\t\t[Shell -> LSP] The exception is :");
            e.printStackTrace();
        }
    }

    private void printPairs(PrintWriter pw, PortNamePair[] pairs) {
        Arrays.sort(pairs);
        if (pairs.length == 0) {
            pw.println("\t\t<empty>");
        } else {
            int i = 0;
            while (i < pairs.length) {
                this.printPair(pw, pairs[i]);
                while (i < pairs.length - 1 && pairs[i].getPort() == pairs[i + 1].getPort()) {
                    pw.print(", " + pairs[i + 1].getName());
                    ++i;
                }
                pw.println();
                ++i;
            }
        }
        pw.println();
    }

    private void printPair(PrintWriter pw, PortNamePair pair) {
        pw.print("\t\t");
        int spaces = 5 - Integer.toString(pair.getPort()).length();
        int i = 0;
        while (i < spaces) {
            pw.print(" ");
            ++i;
        }
        pw.print(pair.getPort() + " --> " + pair.getName());
    }

    public String getHelpMessage() {
        return "Displays used ports in the specified cluster element." + this.nl + "Usage: LSP" + this.nl;
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LSP";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

