/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.adminadapter.AdminAdapterFrame;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.management.MBeanServer;

public class ListServicesCommand
implements Command {
    private PrintWriter out;
    private SystemMonitor sm;
    private ClusterMonitor cm;
    private int currentClusterID;
    private MBeanServer server;
    private static final byte MAX_STATUS_LENGHT = 10;
    private static final byte MAX_STARTUP_LENGHT = 11;
    private static final byte MAX_CORE_LENGHT = 5;
    private static final byte MAX_NAME_LENGHT = 53;

    public ListServicesCommand(SystemMonitor sm, ClusterMonitor cm, MBeanServer server) {
        this.sm = sm;
        this.cm = cm;
        this.server = server;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        this.out = new PrintWriter(os, true);
        int clusterID = this.currentClusterID;
        boolean displayName = false;
        if (params.length != 0) {
            if (params.length > 2) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSS] Wrong number of parameters.\r\n");
                return;
            }
            if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                this.out.println(this.getHelpMessage());
                return;
            }
            if (params[0].equalsIgnoreCase("-d")) {
                displayName = true;
                if (params.length == 2) {
                    try {
                        clusterID = Integer.parseInt(params[1]);
                    }
                    catch (NumberFormatException e) {
                        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSS] Invalid ID!\r\n");
                        return;
                    }
                }
            } else {
                try {
                    clusterID = Integer.parseInt(params[0]);
                }
                catch (NumberFormatException e) {
                    new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSS] Invalid ID!\r\n");
                    return;
                }
            }
        }
        String[][] result = null;
        if (this.currentClusterID == clusterID) {
            ServiceMonitor[] services = this.sm.getServices();
            result = new String[services.length][5];
            int i = 0;
            while (i < services.length) {
                result[i][0] = services[i].getDisplayName();
                result[i][1] = services[i].getComponentName();
                result[i][2] = ListServicesCommand.statusToString(services[i].getStatus());
                result[i][3] = ListServicesCommand.startupModeToString(services[i].getStartupMode());
                result[i][4] = ListServicesCommand.isCoreToString(services[i].isCore());
                ++i;
            }
        } else {
            ClusterElement[] clusterElements = this.cm.getParticipants();
            boolean notFound = true;
            int i = 0;
            while (i < clusterElements.length) {
                try {
                    if (clusterElements[i].getClusterId() == clusterID) {
                        result = (String[][])this.server.invoke(AdminAdapterFrame.getRepresentativeMBeanObjectName(clusterID), "getAllServicesInfo", new Object[0], new String[0]);
                        notFound = false;
                        break;
                    }
                }
                catch (Exception e) {
                    new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSS] Could not list the services !\r\n[Shell -> LSS] Reason : " + e.getMessage() + "\r\n");
                    return;
                }
                ++i;
            }
            if (notFound) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSS] There is no such cluster ID : " + clusterID + "\r\n");
                return;
            }
        }
        this.listServices(result, displayName);
    }

    private void listServices(String[][] result, boolean displayName) {
        int namePosition = displayName ? 0 : 1;
        int nameLen = result[0][namePosition].length();
        Vector<String> services = new Vector<String>();
        int i = 1;
        while (i < result.length) {
            nameLen = nameLen < result[i][namePosition].length() ? result[i][namePosition].length() : nameLen;
            ++i;
        }
        nameLen = nameLen > 53 ? 53 : nameLen;
        this.out.println();
        this.out.println("NAME" + this.spaces(nameLen - 4, ' ') + "  STATUS    STARTUP   CORE");
        this.out.println(this.spaces(nameLen + 10 + 11 + 5, '-'));
        services.add(result[0][namePosition] + this.spaces(nameLen - result[0][namePosition].length() % 53, ' ') + result[0][2] + result[0][3] + result[0][4]);
        int i2 = 1;
        while (i2 < result.length) {
            String nextService = result[i2][namePosition] + this.spaces(nameLen - result[i2][namePosition].length() % 53, ' ') + result[i2][2] + result[i2][3] + result[i2][4];
            boolean add = false;
            int j = 0;
            while (j < services.size()) {
                if (((String)services.elementAt(j)).compareToIgnoreCase(nextService) > 0) {
                    services.insertElementAt(nextService, j);
                    add = true;
                    break;
                }
                ++j;
            }
            if (!add) {
                services.add(services.size(), nextService);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < services.size()) {
            String nextLine = (String)services.elementAt(i3);
            while (nextLine.length() > 79) {
                this.out.println(nextLine.substring(0, 53));
                nextLine = nextLine.substring(53);
            }
            this.out.println(nextLine);
            ++i3;
        }
        this.out.println();
    }

    private String spaces(int n, char space) {
        if (n > 0) {
            StringBuffer ret = new StringBuffer(n);
            int i = 0;
            while (i < n) {
                ret.append(space);
                ++i;
            }
            return ret.toString();
        }
        return "";
    }

    public static String statusToString(byte status) {
        if (status == 5) {
            return "  started ";
        }
        return "  stopped!";
    }

    public static String startupModeToString(byte mode) {
        switch (mode) {
            case 2: {
                return "  always   ";
            }
            case 0: {
                return "  manual   ";
            }
        }
        return "  automatic";
    }

    public static String isCoreToString(boolean isCore) {
        return isCore ? "  Yes" : "  No";
    }

    public String getHelpMessage() {
        return "\r\nLists all services installed on the specified cluster element.\r\nUsage: LSS [-d] [ClusterID]\r\nParameters:\r\n  [-d]        - lists the services using their display names\r\n                instead of their component names.\r\n  [ClusterID] - ID of the cluster element. Default value is the ID\r\n                of the current cluster element.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LSS";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

