/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;

public class ListServicePropertiesCommand
implements Command {
    private SystemMonitor sm;
    private ClusterMonitor cm;
    private int currentClusterID;
    private MBeanServer server;

    public ListServicePropertiesCommand(SystemMonitor sm, ClusterMonitor cm, MBeanServer server) {
        this.sm = sm;
        this.cm = cm;
        this.server = server;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        int clusterID = this.currentClusterID;
        String sName = null;
        if (params.length == 0) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTSP] Missing service name!\r\n");
            return;
        }
        if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        if (params.length > 2) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTSP] Wrong number of parameters.");
            return;
        }
        if (params.length == 2) {
            try {
                clusterID = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException e) {
                out.println("\r\n[Shell -> LISTSP] Invalid cluster ID!\r\n");
                return;
            }
        }
        sName = params[params.length - 1];
        ClusterElement[] clusterElements = this.cm.getParticipants();
        boolean notFound = clusterID != this.currentClusterID;
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i].getClusterId() == clusterID) {
                notFound = false;
                break;
            }
            ++i;
        }
        if (notFound) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTSP] There is no such cluster ID : " + clusterID + "\r\n");
            return;
        }
        try {
            Properties servProp = null;
            Set secure = null;
            if (clusterID == this.currentClusterID) {
                ServiceMonitor monitor = this.sm.getService(sName);
                secure = monitor.getGlobalSecuredPropertiesKeys();
                secure.addAll(monitor.getLocalSecuredPropertiesKeys());
                servProp = monitor.getProperties();
            } else {
                secure = (Set)this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)sName, (String)String.valueOf(clusterID), (String)"\"\""), "getGlobalSecuredKeys", new Object[0], new String[0]);
                secure.addAll((Set)this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)sName, (String)String.valueOf(clusterID), (String)"\"\""), "getLocalSecuredKeys", new Object[0], new String[0]));
                servProp = (Properties)this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)sName, (String)String.valueOf(clusterID), (String)"\"\""), "getProperties", new Object[0], new String[0]);
            }
            Enumeration<?> properties = servProp.propertyNames();
            out.println("\r\n[Shell -> LISTSP] Listing properties of '" + sName + "' on cluster ID : " + clusterID + "\r\n");
            while (properties.hasMoreElements()) {
                String property = (String)properties.nextElement();
                out.println("   " + property + " = " + (secure.contains(property) ? "**********" : servProp.getProperty(property)));
            }
            out.println();
        }
        catch (NullPointerException e) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTSP] No such service !\r\n");
        }
        catch (Exception e) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTSP] Could not list the properties of '" + sName + "'!\r\n[Shell -> LISTSP] Reason : " + e.getMessage() + "\r\n");
        }
    }

    public String getHelpMessage() {
        return "\r\nLists all properties of the specified service.\r\nUsage: LISTSP [ClusterID] <ServiceName>\r\nParameters:\r\n  [ClusterID] - ID of the cluster element. Default value is the ID\r\n                of the current element. Available to servers only.\r\n  <ServiceName> - The name of the service which properties are listed.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LISTSP";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

