/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class ListPools
implements Command {
    private PrintWriter pw = null;
    private Object mngInterface = null;

    public ListPools(ServiceContext sc) {
        this.mngInterface = sc.getCoreContext().getCoreMonitor().getManagementInterface("PoolManager");
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        this.pw = new PrintWriter(os, true);
        if (params.length > 0) {
            this.pw.println(this.getHelpMessage());
            return;
        }
        try {
            int[] sizes = (int[])this.callMethod("getPossibleSizes", null, null);
            int i = 0;
            while (i < sizes.length) {
                this.pw.println("Pool for byte arrays with size " + sizes[i] + "KB");
                int free = (Integer)this.callMethod("getFreeEntriesForSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(sizes[i])});
                this.pw.println("  Free : " + free + " entries");
                int used = (Integer)this.callMethod("getUsedEntriesForSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(sizes[i])});
                this.pw.println("  Used : " + used + " entries");
                int maxEntries = (Integer)this.callMethod("getTotalEntriesForSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(sizes[i])});
                this.pw.println("  Total: " + maxEntries + " entries");
                int size = (Integer)this.callMethod("getCurrentMemoryForSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(sizes[i])});
                int maxMemory = (Integer)this.callMethod("getMaxMemoryForSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(sizes[i])});
                this.pw.println("  Size : " + size + " KB (of " + maxMemory + " KB)");
                ++i;
            }
            int totalUsed = (Integer)this.callMethod("getTotalMemoryUsed", null, null);
            int totalAllocated = (Integer)this.callMethod("getTotalMemoryAllocated", null, null);
            this.pw.println("\r\nTotal memory used: " + totalUsed + " KB (of " + totalAllocated + " KB)");
            this.pw.println();
        }
        catch (Exception e) {
            this.pw.println("[Shell -> LP] Can not execute the command !");
            this.pw.println("[Shell -> LP] Reason :" + e.getLocalizedMessage());
        }
    }

    private Object callMethod(String methodName, Class[] parameterTypes, Object[] parameters) {
        try {
            Method mthd = this.mngInterface.getClass().getMethod(methodName, parameterTypes);
            return mthd.invoke(this.mngInterface, parameters);
        }
        catch (Exception e) {
            this.pw.println("[Shell -> LP] \"" + methodName + "\" can not be executed !");
            this.pw.println("[Shell -> LP] Reason :" + e.getLocalizedMessage());
            return null;
        }
    }

    public String getHelpMessage() {
        return "Usage: LP\r\n\r\n\tDisplays pools usage.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LP";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

