/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.management.MBeanServer;

public class ListManagersCommand
implements Command {
    private ServiceContext sc;
    private ClusterMonitor cm;
    private int currentClusterID;
    private MBeanServer server;

    public ListManagersCommand(ServiceContext sc, ClusterMonitor cm, MBeanServer server) {
        this.sc = sc;
        this.cm = cm;
        this.server = server;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        int clusterID = this.currentClusterID;
        if (params.length != 0) {
            if (params.length > 1) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSM] Wrong number of parameters.\r\n");
                return;
            }
            if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.println(this.getHelpMessage());
                return;
            }
            try {
                clusterID = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException e) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSM] Invalid ID!\r\n");
                return;
            }
        }
        String[] res = null;
        if (clusterID == this.currentClusterID) {
            res = this.sc.getCoreContext().getCoreMonitor().getAllManagers();
        } else {
            ClusterElement[] clusterElements = this.cm.getParticipants();
            boolean notFound = true;
            int i = 0;
            while (i < clusterElements.length) {
                if (clusterElements[i].getClusterId() == clusterID) {
                    try {
                        res = (String[])this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)("kernel_" + clusterID), (String)String.valueOf(clusterID), (String)"\"\""), "getAllManagers", new Object[0], new String[0]);
                    }
                    catch (Exception e) {
                        break;
                    }
                    notFound = false;
                    break;
                }
                ++i;
            }
            if (notFound) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSM] There is no such cluster ID : " + clusterID + "\r\n");
                return;
            }
        }
        out.println("\r\nMANAGERS : " + res.length);
        out.println("-----------------------");
        int i = 0;
        while (i < res.length) {
            if (i < 9) {
                out.println(" " + (i + 1) + " - " + res[i]);
            } else {
                out.println(i + 1 + " - " + res[i]);
            }
            ++i;
        }
        out.println("-----------------------\r\n");
    }

    public String getHelpMessage() {
        return "\r\nLists all managers running on the specified cluster element.\r\nUsage: LSM [ClusterID]\r\nParameters:\r\n  [ClusterID] - ID of the cluster element. Default value is the ID\r\n                of the current cluster element.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LSM";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

