/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.core.monitor.CoreMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;

public class ListManagerPropertiesCommand
implements Command {
    private ServiceContext sc;
    private ClusterMonitor cm;
    private int currentClusterID;
    private MBeanServer server;

    public ListManagerPropertiesCommand(ServiceContext sc, ClusterMonitor cm, MBeanServer server) {
        this.sc = sc;
        this.cm = cm;
        this.server = server;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        int clusterID = this.currentClusterID;
        String managerName = null;
        if (params.length == 0) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTMP] Missing manager name!\r\n");
            return;
        }
        if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        if (params.length > 2) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTMP] Wrong number of parameters.");
            return;
        }
        if (params.length == 2) {
            try {
                clusterID = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException e) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTMP] Invalid cluster ID!\r\n");
                return;
            }
        }
        managerName = params[params.length - 1];
        ClusterElement[] clusterElements = this.cm.getParticipants();
        boolean notFound = clusterID != this.currentClusterID;
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i].getClusterId() == clusterID || !notFound) {
                notFound = false;
                break;
            }
            ++i;
        }
        if (notFound) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTMP] There is no such cluster ID : " + clusterID + "\r\n");
            return;
        }
        try {
            Properties managerProp = null;
            Set secure = null;
            if (clusterID == this.currentClusterID) {
                CoreMonitor cm = this.sc.getCoreContext().getCoreMonitor();
                secure = cm.getGlobalSecuredPropertiesKeys(managerName);
                secure.addAll(cm.getLocalSecuredPropertiesKeys(managerName));
                managerProp = cm.getManagerRuntimeProperties(managerName);
            } else {
                secure = (Set)this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)("kernel_" + clusterID), (String)String.valueOf(clusterID), (String)"\"\""), "getGlobalSecuredKeys", new Object[]{managerName}, new String[]{"java.lang.String"});
                secure.addAll((Set)this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)("kernel_" + clusterID), (String)String.valueOf(clusterID), (String)"\"\""), "getLocalSecuredKeys", new Object[]{managerName}, new String[]{"java.lang.String"}));
                managerProp = (Properties)this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)("kernel_" + clusterID), (String)String.valueOf(clusterID), (String)"\"\""), "getManagerProperties", new Object[]{managerName}, new String[]{"java.lang.String"});
            }
            Enumeration<?> properties = managerProp.propertyNames();
            out.println("\r\n[Shell -> LISTMP] Listing properties of '" + managerName + "' on cluster ID : " + clusterID + "\r\n");
            while (properties.hasMoreElements()) {
                String property = (String)properties.nextElement();
                out.println("   " + property + " = " + (secure.contains(property) ? "**********" : managerProp.getProperty(property)));
            }
            out.println();
        }
        catch (NullPointerException e) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTMP] No such manager !\r\n");
        }
        catch (Exception e) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LISTMP] Could not list the properties of '" + managerName + "'!\r\n[Shell -> LISTMP] Reason : " + e.getMessage() + "\r\n");
        }
    }

    public String getHelpMessage() {
        return "\r\nLists all properties of the specified manager.\r\nUsage: LISTMP [clusterID] <ManagerName>\r\nParameters:\r\n  [ClusterID] - ID of the cluster element. Default value is the ID\r\n                of the current element.\r\n  <ManagerName> - the name of the manager which properties are listed.";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LISTMP";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

