/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class ListLoadersCommand
implements Command {
    private LoadContext lc = null;
    private static final String FILTER_INTERFACE = "interface:";
    private static final String FILTER_LIBRARY = "library:";
    private static final String FILTER_SERVICE = "service:";
    private static final String FILTER_COMMON = "common:";
    private static final String FILTER_APPLICATION = "application:";

    public ListLoadersCommand(ServiceContext sc) {
        this.lc = sc.getCoreContext().getLoadContext();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length > 2) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LL] Too much parameters.\r\n");
            return;
        }
        boolean withReferences = false;
        boolean application = false;
        String filter = null;
        int i = 0;
        while (i < params.length) {
            if (params[i].equalsIgnoreCase("-h") || params[i].equalsIgnoreCase("-help") || params[i].equals("-?")) {
                pw.println(this.getHelpMessage());
                return;
            }
            if (params[i].equalsIgnoreCase("-I")) {
                if (filter == null) {
                    filter = FILTER_INTERFACE;
                }
            } else if (params[i].equalsIgnoreCase("-L")) {
                if (filter == null) {
                    filter = FILTER_LIBRARY;
                }
            } else if (params[i].equalsIgnoreCase("-S")) {
                if (filter == null) {
                    filter = FILTER_SERVICE;
                }
            } else if (params[i].equalsIgnoreCase("-C")) {
                if (filter == null) {
                    filter = FILTER_COMMON;
                }
            } else if (params[i].equalsIgnoreCase("-A")) {
                if (filter == null) {
                    application = true;
                    filter = FILTER_APPLICATION;
                }
            } else if (params[i].equalsIgnoreCase("-R")) {
                withReferences = true;
            } else {
                pw.println(this.getHelpMessage());
                return;
            }
            ++i;
        }
        Object[] names = null;
        boolean firstTime = true;
        Enumeration loaders = this.lc.listLoaders();
        Vector loadersNames = new Vector();
        while (loaders.hasMoreElements()) {
            loadersNames.add(loaders.nextElement());
        }
        names = new String[loadersNames.size()];
        loadersNames.toArray(names);
        Arrays.sort(names);
        int k = 0;
        while (k < names.length) {
            Object current = names[k];
            if (filter == null || !application && ((String)current).startsWith(filter) || application && !((String)current).startsWith(FILTER_INTERFACE) && !((String)current).startsWith(FILTER_LIBRARY) && !((String)current).startsWith(FILTER_SERVICE) && !((String)current).startsWith(FILTER_COMMON)) {
                if (firstTime) {
                    pw.println("Registered " + (filter == null ? "" : filter.substring(0, filter.length() - 1)) + " loaders : ");
                    firstTime = false;
                }
                boolean notInitialized = this.lc.getClassLoader((String)current) == null;
                pw.print("  [" + (String)current + "]" + (notInitialized ? " not initialized!" : ""));
                if (withReferences) {
                    String[] refs = this.lc.getReferences((String)current);
                    if (refs.length != 0) {
                        int i2 = 0;
                        while (i2 < refs.length) {
                            pw.print("\r\n    " + refs[i2]);
                            ++i2;
                        }
                    } else {
                        pw.print("    no references!");
                    }
                }
                pw.println();
            }
            ++k;
        }
        if (firstTime) {
            pw.println("No registered " + (filter == null ? "" : filter.substring(0, filter.length() - 1)) + " loaders ! ");
        }
    }

    public String getHelpMessage() {
        return "\r\nLists registered loaders\r\nUsage: LL [<-i|-l|-s|-c|-a>] [<-r>]\r\n Parameters:\r\n  [-i] - lists only interface loaders\r\n  [-l] - lists only library loaders\r\n  [-s] - lists only service loaders\r\n  [-c] - lists only common  loaders\r\n  [-a] - lists only application loaders\r\n  [-r] - lists registered references per loader.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LL";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

