/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.boot.FileClassLoader;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ListLoaderResourcesCommand
implements Command {
    private LoadContext lc = null;
    private static final int MAGIC_NUMBER = -889275714;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;

    public ListLoaderResourcesCommand(ServiceContext sc) {
        this.lc = sc.getCoreContext().getLoadContext();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length >= 1) {
            int i = 0;
            while (i < params.length) {
                if (params[i].startsWith("-") && (params[i].equals("-?") || params[i].equalsIgnoreCase("-h") || params[i].equalsIgnoreCase("-help"))) {
                    pw.println(this.getHelpMessage());
                    return;
                }
                ++i;
            }
            if (params.length == 1) {
                this.listLoaderResources(env, pw, params);
                return;
            }
            if (params.length == 2) {
                if (params[1].equalsIgnoreCase("-r")) {
                    this.listLoaderReferees(env, pw, params);
                    return;
                }
                if (params[0].equalsIgnoreCase("-all") && params[1].equalsIgnoreCase("-s")) {
                    this.listLoadersToString(env, pw);
                    return;
                }
                if (params[1].equalsIgnoreCase("-p")) {
                    if (params[0].equalsIgnoreCase("-all")) {
                        Enumeration enumeration = this.lc.listLoaders();
                        while (enumeration.hasMoreElements()) {
                            this.resolveLoader(env, pw, (String)enumeration.nextElement(), false);
                        }
                    } else if (params[0].equalsIgnoreCase("-system")) {
                        this.checkSameEntries(pw);
                    } else {
                        this.resolveLoader(env, pw, params[0], false);
                    }
                    return;
                }
            } else if (params.length == 3) {
                if (params[1].equalsIgnoreCase("-f")) {
                    this.searchLoaderForResource(env, pw, params);
                    return;
                }
                if (params[1].equalsIgnoreCase("-c")) {
                    this.searchLoaderForClass(env, pw, params, false, false);
                    return;
                }
                if (params[1].equalsIgnoreCase("-l")) {
                    this.loadClass(env, pw, params);
                    return;
                }
                if (params[1].equalsIgnoreCase("-p") && params[2].equalsIgnoreCase("-i")) {
                    if (params[0].equalsIgnoreCase("-all")) {
                        Enumeration enumeration = this.lc.listLoaders();
                        while (enumeration.hasMoreElements()) {
                            this.resolveLoader(env, pw, (String)enumeration.nextElement(), true);
                        }
                    } else if (params[0].equalsIgnoreCase("-system")) {
                        this.checkSameEntries(pw);
                    } else {
                        this.resolveLoader(env, pw, params[0], true);
                    }
                    return;
                }
            } else if (params.length == 4) {
                if (params[1].equalsIgnoreCase("-c")) {
                    if (params[3].equalsIgnoreCase("-l")) {
                        this.searchLoaderForClass(env, pw, params, false, true);
                        return;
                    }
                    if (params[3].equalsIgnoreCase("-a")) {
                        this.searchLoaderForClass(env, pw, params, true, false);
                        return;
                    }
                }
            } else if (params.length == 5 && params[1].equalsIgnoreCase("-c") && (params[3].equalsIgnoreCase("-a") || params[3].equalsIgnoreCase("-l")) && (params[4].equalsIgnoreCase("-a") || params[4].equalsIgnoreCase("-l"))) {
                this.searchLoaderForClass(env, pw, params, true, true);
                return;
            }
        }
        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Wrong parameters!\r\n");
    }

    private void listLoaderReferees(Environment env, PrintWriter pw, String[] params) {
        ReferencedLoader loader = (ReferencedLoader)this.lc.getClassLoader(params[0]);
        String[] referees = this.lc.getReferencesFrom(params[0]);
        if ((referees == null || referees.length == 0) && loader == null) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Such loader not registered!\r\n");
            return;
        }
        pw.println("  Loader name:");
        if (loader == null) {
            pw.println("    [" + params[0] + "] not initialized !");
        } else {
            pw.println("    [" + loader.getName() + "]");
        }
        if (referees != null && referees.length != 0) {
            pw.println("  Referees:");
            int i = 0;
            while (i < referees.length) {
                pw.println("    " + referees[i]);
                ++i;
            }
        } else {
            pw.println("  No referees !");
        }
        pw.println();
    }

    private void loadClass(Environment env, PrintWriter pw, String[] params) {
        ReferencedLoader loader = (ReferencedLoader)this.lc.getClassLoader(params[0]);
        if (loader == null) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Such loader not registered!\r\n");
            return;
        }
        pw.println("  Class loader : " + loader.getName());
        pw.println("  Class  name  : " + params[2]);
        try {
            Class<?> cls = Class.forName(params[2], false, (ClassLoader)loader);
            pw.println("  Loaded from  : " + this.getLoaderName(cls.getClassLoader()));
            pw.println("  Class Hash   : " + Integer.toHexString(cls.hashCode()));
            pw.println("  Loader Hash  : " + (cls.getClassLoader() == null ? this.getLoaderName(cls.getClassLoader()) : "" + Integer.toHexString(cls.getClassLoader().hashCode())));
            pw.println("  Code Source  : " + this.getLocation(cls));
        }
        catch (Throwable t) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(buffer);
            t.printStackTrace(out);
            pw.print(new String(buffer.toByteArray()));
            out.close();
        }
        pw.println();
    }

    private void listLoaderHierarchy(PrintWriter pw, ClassLoader loader) {
        if (loader != null) {
            this.listLoaderHierarchy(pw, loader.getParent());
            pw.println("  [" + this.getLoaderName(loader) + "] " + loader.toString());
        }
    }

    private void listLoadersToString(Environment env, PrintWriter pw) {
        Enumeration loaders = this.lc.listLoaders();
        Vector array = new Vector();
        while (loaders.hasMoreElements()) {
            Object key = loaders.nextElement();
            array.add(key);
        }
        Object[] names = array.toArray(new String[array.size()]);
        Arrays.sort(names);
        this.listLoaderHierarchy(pw, this.getClass().getClassLoader().getParent());
        pw.println("  [" + this.getLoaderName(this.lc.getClass().getClassLoader()) + "] " + this.lc.getClass().getClassLoader().toString());
        int i = 0;
        while (i < names.length) {
            ReferencedLoader loader = (ReferencedLoader)this.lc.getClassLoader((String)names[i]);
            if (loader != null) {
                pw.println("  [" + loader.getName() + "] " + loader.toString());
            } else {
                pw.println("  [" + (String)names[i] + "] not initialized !");
            }
            ++i;
        }
        pw.println();
    }

    private void searchLoaderForClass(Environment env, PrintWriter pw, String[] params, boolean all, boolean location) {
        ReferencedLoader loader = (ReferencedLoader)this.lc.getClassLoader(params[0]);
        if (loader == null) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Such loader not registered!\r\n");
            return;
        }
        Vector array = null;
        try {
            array = loader.getLoadedClasses(params[2]);
        }
        catch (UnsupportedOperationException e) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Loader not in debug mode!\r\nRestart cluster node with system property -Dclassload.info=true !\r\n");
            return;
        }
        if (array.size() != 0) {
            Class[] classes = new Class[array.size()];
            array.toArray(classes);
            Arrays.sort(classes, ClassComparator.getClassComparator());
            Hashtable<String, Vector<Class>> hash = new Hashtable<String, Vector<Class>>();
            int i = 0;
            while (i < classes.length) {
                Class cls = classes[i];
                ClassLoader classLoader = classes[i].getClassLoader();
                if (all || classLoader == loader) {
                    String classLoaderName = this.getName(classLoader);
                    Vector<Class> tempArray = (Vector<Class>)hash.get(classLoaderName);
                    if (tempArray == null) {
                        tempArray = new Vector<Class>();
                        hash.put(classLoaderName, tempArray);
                    }
                    tempArray.add(cls);
                }
                ++i;
            }
            Enumeration enumeration = hash.keys();
            while (enumeration.hasMoreElements()) {
                String classLoaderName = (String)enumeration.nextElement();
                Vector tempArray = (Vector)hash.get(classLoaderName);
                pw.println("[" + classLoaderName + "]");
                int i2 = 0;
                while (i2 < tempArray.size()) {
                    String locationString;
                    Class cls = (Class)tempArray.get(i2);
                    pw.println("  " + cls.getName());
                    if (location && (locationString = this.getLocation(cls)) != null) {
                        pw.println("    " + locationString);
                    }
                    ++i2;
                }
            }
        } else {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Such classes are not loaded!\r\n");
            return;
        }
        pw.println();
    }

    private String getName(ClassLoader loader) {
        if (loader != null) {
            if (loader instanceof ReferencedLoader) {
                return ((ReferencedLoader)loader).getName();
            }
            if (loader instanceof FileClassLoader) {
                return ((FileClassLoader)loader).getName();
            }
            return loader.toString();
        }
        return "BOOTSTRAP";
    }

    private String getLocation(Class cls) {
        URL url;
        CodeSource cs;
        ProtectionDomain domain = cls.getProtectionDomain();
        if (domain != null && (cs = domain.getCodeSource()) != null && (url = cs.getLocation()) != null) {
            return url.toString();
        }
        return null;
    }

    private boolean dumpFullEnumeration(ClassLoader loader, String fileName, PrintWriter pw, boolean dumped) throws IOException {
        Enumeration<URL> enumeration = loader.getResources(fileName);
        if (enumeration.hasMoreElements()) {
            pw.println("[" + this.getLoaderName(loader) + "]");
            do {
                pw.println("   " + enumeration.nextElement());
            } while (enumeration.hasMoreElements());
            dumped = true;
        }
        return dumped;
    }

    private boolean dumpLocalEnumeration(ClassLoader loader, String fileName, PrintWriter pw, boolean dumped) throws IOException {
        Enumeration enumeration = null;
        enumeration = loader instanceof FileClassLoader ? ((FileClassLoader)loader).findLocalResources(fileName) : (loader instanceof ReferencedLoader ? ((ReferencedLoader)loader).findRefResources(fileName) : loader.getResources(fileName));
        if (enumeration.hasMoreElements()) {
            pw.println("[" + this.getLoaderName(loader) + "]");
            do {
                pw.println("   " + enumeration.nextElement());
            } while (enumeration.hasMoreElements());
            return true;
        }
        return dumped;
    }

    private void searchLoaderForResource(Environment env, PrintWriter pw, String[] params) {
        IOException exception = null;
        ClassLoader loader = null;
        boolean dumped = false;
        if (params[0].equalsIgnoreCase("-all")) {
            try {
                loader = ClassLoader.getSystemClassLoader();
                dumped = this.dumpLocalEnumeration(loader, params[2], pw, dumped);
                loader = this.getClass().getClassLoader().getParent();
                dumped = this.dumpLocalEnumeration(loader, params[2], pw, dumped);
                loader = this.lc.getClass().getClassLoader();
                dumped = this.dumpLocalEnumeration(loader, params[2], pw, dumped);
                Enumeration loaders = this.lc.listLoaders();
                Vector array = new Vector();
                while (loaders.hasMoreElements()) {
                    Object key = loaders.nextElement();
                    array.add(key);
                }
                Object[] names = array.toArray(new String[array.size()]);
                Arrays.sort(names);
                int i = 0;
                while (i < names.length) {
                    Object nextName = names[i];
                    loader = this.lc.getClassLoader((String)nextName);
                    if (loader != null) {
                        dumped = this.dumpLocalEnumeration(loader, params[2], pw, dumped);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                exception = e;
            }
        } else {
            loader = this.lc.getClassLoader(params[0]);
            String loaderName = null;
            if (loader == null) {
                loaderName = params[0];
                boolean registered = false;
                Enumeration enumeration = this.lc.listLoaders();
                while (enumeration.hasMoreElements()) {
                    if (!enumeration.nextElement().equals(loaderName)) continue;
                    registered = true;
                    break;
                }
                if (!registered) {
                    new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Such loader not registered!\r\n");
                    return;
                }
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] [" + loaderName + "] not initialized !\r\n");
                return;
            }
            try {
                if (!(loader instanceof ReferencedLoader)) {
                    dumped = this.dumpFullEnumeration(loader, params[2], pw, dumped);
                } else {
                    dumped = this.dumpFullEnumeration(loader.getParent(), params[2], pw, dumped);
                    String[] references = this.lc.getReferences(params[0]);
                    int i = 0;
                    while (i < references.length) {
                        ClassLoader nextReference = this.lc.getClassLoader(references[i]);
                        if (nextReference != null) {
                            dumped = this.dumpLocalEnumeration(nextReference, params[2], pw, dumped);
                        }
                        ++i;
                    }
                    dumped = this.dumpLocalEnumeration(loader, params[2], pw, dumped);
                }
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception == null) {
            if (!dumped) {
                pw.println("\r\n[Shell -> LLR] Such resource cannot be found in the registered loaders!");
            }
        } else {
            pw.println("\r\n[Shell -> LLR] Exception occured " + exception.toString());
        }
        pw.println();
    }

    private void listLoaderResources(Environment env, PrintWriter pw, String[] params) {
        String additionalInfo;
        if (params[0].equals("-system")) {
            this.listSystemResources(pw);
            return;
        }
        ReferencedLoader refLoader = (ReferencedLoader)this.lc.getClassLoader(params[0]);
        String loaderName = null;
        if (refLoader == null) {
            loaderName = params[0];
            boolean registered = false;
            Enumeration enumeration = this.lc.listLoaders();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().equals(loaderName)) continue;
                registered = true;
                break;
            }
            if (!registered) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Such loader not registered!\r\n");
                return;
            }
            pw.println("[" + loaderName + "] not initialized !");
        } else {
            loaderName = refLoader.getName();
            pw.println("  Loader name:");
            pw.println("    [" + loaderName + "]");
            pw.println("  Parent loader:");
            pw.println("    [" + refLoader.getParentName() + "]");
        }
        String[] resources = this.lc.getReferences(loaderName);
        if (resources != null && resources.length != 0) {
            pw.println("  References:");
            int i = 0;
            while (i < resources.length) {
                pw.println("    " + resources[i]);
                ++i;
            }
        } else {
            pw.println("  No references !");
        }
        resources = this.lc.getResourceNames(loaderName);
        if (resources != null && resources.length != 0) {
            pw.println("  Resources:");
            int i = 0;
            while (i < resources.length) {
                File file = new File(resources[i]);
                pw.println("    " + resources[i] + (file.exists() ? "" : "  doesn't exist !"));
                ++i;
            }
        } else {
            pw.println("  No resources !");
        }
        if (refLoader != null && (additionalInfo = refLoader.getAdditionalInfo()) != null) {
            pw.println("  " + additionalInfo);
        }
        pw.println();
    }

    private void listSystemResources(PrintWriter pw) {
        try {
            ClassLoader applicationLoader = ClassLoader.getSystemClassLoader();
            ClassLoader extensionLoader = applicationLoader.getParent();
            FileClassLoader frameClassLoader = (FileClassLoader)this.getClass().getClassLoader().getParent();
            FileClassLoader kernelClassLoader = (FileClassLoader)this.lc.getClass().getClassLoader();
            this.listResources(this.getLoaderName(null), this.getBootstrapLoaderPath(), pw);
            this.listResources(this.getLoaderName(extensionLoader), extensionLoader instanceof URLClassLoader ? ListLoaderResourcesCommand.getURLClassLoaderPaths((URLClassLoader)extensionLoader) : ListLoaderResourcesCommand.getExtensionLoaderPath(), pw);
            this.listResources(this.getLoaderName(applicationLoader), applicationLoader instanceof URLClassLoader ? ListLoaderResourcesCommand.getURLClassLoaderPaths((URLClassLoader)applicationLoader) : ListLoaderResourcesCommand.getApplicationLoaderPath(), pw);
            this.listResources(this.getLoaderName((ClassLoader)frameClassLoader), frameClassLoader.getResourceNames(), pw);
            this.listResources(this.getLoaderName((ClassLoader)kernelClassLoader), kernelClassLoader.getResourceNames(), pw);
        }
        catch (Throwable e) {
            pw.println("Cannot get system loaders " + e.getClass() + ":" + e.getMessage());
        }
    }

    private void listResources(String loaderName, String[] resources, PrintWriter pw) {
        pw.println("Loader name:");
        pw.println("  [" + loaderName + "]");
        if (resources != null && resources.length != 0) {
            pw.println("  Resources:");
            int i = 0;
            while (i < resources.length) {
                File file = new File(resources[i]);
                pw.println("    " + resources[i] + (file.exists() ? "" : "  doesn't exist !"));
                ++i;
            }
        } else {
            pw.println("  No resources !");
        }
    }

    public String getHelpMessage() {
        return "Usage:\r\n  LLR <loadername>|<-system>\r\n     Lists detailed information for the specified loader.\r\n  LLR <loadername> -R\r\n     Lists referee loaders for the specified loader.\r\n  LLR <loadername> -L <classname>\r\n     Tries to load the class with the specified loader.\r\n     Dumps the exception if not successful.\r\n  LLR <loadername> -P [-i]\r\n     Tries to find missing dependancy(class or reference) in loader resources.\r\n  LLR <loadername>|<-all> -F <filename>\r\n     Searches for a resource file with the specified loader.\r\n  LLR <loadername> -C <classnamefilter> [-a] [-l]\r\n     Searches the loaded classes with possible package filtering.\r\nParameters:\r\n  <loadername> - the name of the loader\r\n  <-system> - the system classloaders\r\n  <-all> - system loaders and the registered in ClassLoaderManager\r\n  <classname> - the name of the class to be loaded\r\n  <filename> - the name of the resource file to be searched\r\n  <classnamefilter> - class names starting with this filter prefix are listed\r\n  <-a> - defined and imported classes matching the filter\r\n  <-l> - code source of the classes\r\n  <-i> - gives additional info.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LLR";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    private String getLoaderName(ClassLoader loader) {
        if (loader == null) {
            return "BOOTSTRAP";
        }
        if (loader instanceof ReferencedLoader) {
            return ((ReferencedLoader)loader).getName();
        }
        if (loader instanceof FileClassLoader) {
            return ((FileClassLoader)loader).getName();
        }
        return loader.toString();
    }

    private String[] getBootstrapLoaderPath() {
        if (System.getProperty("sun.boot.class.path") == null) {
            return ListLoaderResourcesCommand.getClassLoaderPath("java.class.path");
        }
        return ListLoaderResourcesCommand.getClassLoaderPath("sun.boot.class.path");
    }

    private static String[] getExtensionLoaderPath() {
        return ListLoaderResourcesCommand.getClassLoaderPath("java.ext.dirs");
    }

    private static String[] getApplicationLoaderPath() {
        return ListLoaderResourcesCommand.getClassLoaderPath("java.class.path");
    }

    private static String[] getClassLoaderPath(String property) {
        String path = System.getProperty(property);
        if (path == null) {
            return new String[0];
        }
        File[] filePath = ListLoaderResourcesCommand.getClassPath(path);
        String[] result = new String[filePath.length];
        int i = 0;
        while (i < filePath.length) {
            try {
                result[i] = filePath[i].getCanonicalPath();
            }
            catch (IOException e) {
                result[i] = filePath[i].getAbsolutePath();
            }
            ++i;
        }
        return result;
    }

    private static File[] getClassPath(String classpath) {
        if (classpath == null) {
            return new File[0];
        }
        int count = 0;
        int maxCount = 1;
        int pos = 0;
        int lastPos = 0;
        while ((pos = classpath.indexOf(File.pathSeparator, lastPos)) != -1) {
            ++maxCount;
            lastPos = pos + 1;
        }
        File[] result = new File[maxCount];
        pos = 0;
        lastPos = 0;
        while ((pos = classpath.indexOf(File.pathSeparator, lastPos)) != -1) {
            result[count++] = pos - lastPos > 0 ? new File(classpath.substring(lastPos, pos)) : new File(".");
            lastPos = pos + 1;
        }
        result[count++] = lastPos < classpath.length() ? new File(classpath.substring(lastPos)) : new File(".");
        if (count != maxCount) {
            File[] tmp = new File[count];
            System.arraycopy(result, 0, tmp, 0, count);
            result = tmp;
        }
        return result;
    }

    private static String[] getURLClassLoaderPaths(URLClassLoader urlClassLoader) {
        URL[] urlPaths = urlClassLoader.getURLs();
        String[] result = new String[urlPaths.length];
        int i = 0;
        while (i < urlPaths.length) {
            File file = new File(urlPaths[i].getFile());
            try {
                result[i] = file.getCanonicalPath();
            }
            catch (IOException e) {
                result[i] = file.getAbsolutePath();
            }
            ++i;
        }
        return result;
    }

    private void resolveLoader(Environment env, PrintWriter pw, String loaderNameParam, boolean logAll) {
        Iterator iter;
        ReferencedLoader loader = (ReferencedLoader)this.lc.getClassLoader(loaderNameParam);
        if (loader == null) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LLR] Such loader not registered!\r\n");
            return;
        }
        pw.println("  Loader name:");
        pw.println("    [" + loader.getName() + "]");
        String[] loaderReferences = loader.getReferencesTo();
        HashSet neededExtraReferences = new HashSet();
        HashSet notFoundClasses = new HashSet();
        HashSet<String> notNeededReferences = new HashSet<String>();
        int i = 0;
        while (i < loaderReferences.length) {
            notNeededReferences.add(loaderReferences[i]);
            ++i;
        }
        Vector<ReferencedLoader> referencedLoaders = new Vector<ReferencedLoader>();
        Vector<ReferencedLoader> notReferencedLoaders = new Vector<ReferencedLoader>();
        Enumeration enumeration = this.lc.listLoaders();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            ReferencedLoader classLoader = (ReferencedLoader)this.lc.getClassLoader(name);
            if (classLoader == loader) continue;
            if (classLoader != null) {
                if (notNeededReferences.contains(name)) {
                    referencedLoaders.add(classLoader);
                    continue;
                }
                if (!name.startsWith("interface:") && !name.startsWith("library:") && !name.startsWith("service:") && !name.startsWith("common:")) continue;
                notReferencedLoaders.add(classLoader);
                continue;
            }
            if (!notNeededReferences.contains(name)) continue;
            pw.println(" [warning] reference stated but no loader found for " + name);
        }
        String[] loaderResources = loader.getResourceNames();
        HashSet resolved = new HashSet();
        int i2 = 0;
        while (i2 < loaderResources.length) {
            File file = new File(loaderResources[i2]);
            if (file.exists()) {
                if (file.isDirectory()) {
                    this.getDirClasses(pw, file, loader, referencedLoaders, notReferencedLoaders, notNeededReferences, resolved, neededExtraReferences, logAll, notFoundClasses);
                } else {
                    String fileName = file.getName().toLowerCase();
                    if (fileName.endsWith(".jar")) {
                        this.getJarClasses(pw, file, loader, referencedLoaders, notReferencedLoaders, notNeededReferences, resolved, neededExtraReferences, logAll, notFoundClasses);
                    } else {
                        try {
                            pw.println(" [warning] file is of not known type " + file.getCanonicalPath());
                        }
                        catch (IOException e) {
                            pw.println(" [warning] file is of not known type " + file.getAbsolutePath());
                        }
                    }
                }
            } else {
                try {
                    pw.println(" [warning] resource doesn't exist " + file.getCanonicalPath());
                }
                catch (IOException e) {
                    pw.println(" [warning] resource doesn't exist " + file.getAbsolutePath());
                }
            }
            ++i2;
        }
        pw.println(" [info] resolved classes " + resolved.size());
        if (notNeededReferences.size() > 0) {
            iter = notNeededReferences.iterator();
            while (iter.hasNext()) {
                pw.println(" [info] not needed reference " + iter.next());
            }
        } else if (loaderReferences.length != 0) {
            pw.println(" [info] every reference is used !");
        }
        if (neededExtraReferences.size() > 0) {
            iter = neededExtraReferences.iterator();
            while (iter.hasNext()) {
                pw.println(" [info] missing reference " + iter.next());
            }
        }
        iter = notFoundClasses.iterator();
        while (iter.hasNext()) {
            pw.println(" [info] missing class " + iter.next());
        }
        pw.println();
    }

    private void getDirClasses(PrintWriter pw, File dir, ReferencedLoader loader, Vector referencedLoaders, Vector notReferencedLoaders, HashSet notNeededReferences, HashSet resolved, HashSet neededExtraReferences, boolean logAll, HashSet notFoundClasses) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            block10: {
                if (files[i].isDirectory()) {
                    this.getDirClasses(pw, files[i], loader, referencedLoaders, notReferencedLoaders, notNeededReferences, resolved, neededExtraReferences, logAll, notFoundClasses);
                } else {
                    String fileName = files[i].getName();
                    if (fileName.endsWith(".class")) {
                        byte[] bytecode = null;
                        try {
                            FileInputStream in = new FileInputStream(files[i]);
                            int len = ((InputStream)in).available();
                            bytecode = this.readSource(in, len);
                        }
                        catch (IOException e) {
                            try {
                                pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + files[i].getCanonicalPath());
                            }
                            catch (IOException e1) {
                                pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + files[i].getAbsolutePath());
                            }
                            break block10;
                        }
                        String[] refs = null;
                        try {
                            refs = this.getClassReferences(bytecode);
                        }
                        catch (IOException e) {
                            pw.println(" [warning] error in reading constant pool " + fileName + " : " + e.getClass() + " : " + e.getMessage());
                            break block10;
                        }
                        this.resolveClass(pw, refs, loader, referencedLoaders, notReferencedLoaders, notNeededReferences, files[i].getAbsolutePath(), resolved, neededExtraReferences, logAll, notFoundClasses);
                    }
                }
            }
            ++i;
        }
    }

    private void getJarClasses(PrintWriter pw, File jar, ReferencedLoader loader, Vector referencedLoaders, Vector notReferencedLoaders, HashSet notNeededReferences, HashSet resolved, HashSet neededExtraReferences, boolean logAll, HashSet notFoundClasses) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException e) {
            try {
                pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + jar.getCanonicalPath());
            }
            catch (IOException e1) {
                pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + jar.getAbsolutePath());
            }
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String entryName;
            JarEntry entry = enumeration.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
            byte[] bytecode = null;
            try {
                bytecode = this.readSource(jarFile.getInputStream(entry), (int)entry.getSize());
            }
            catch (IOException e) {
                try {
                    pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + jar.getCanonicalPath() + " : " + entryName);
                }
                catch (IOException e1) {
                    pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + jar.getAbsolutePath() + " : " + entryName);
                }
                continue;
            }
            String[] refs = null;
            try {
                refs = this.getClassReferences(bytecode);
            }
            catch (IOException e) {
                pw.println(" [warning] error in reading constant pool " + entryName + " : " + e.getClass() + " : " + e.getMessage());
                continue;
            }
            this.resolveClass(pw, refs, loader, referencedLoaders, notReferencedLoaders, notNeededReferences, entryName, resolved, neededExtraReferences, logAll, notFoundClasses);
        }
        try {
            jarFile.close();
        }
        catch (IOException e) {
            jarFile = null;
        }
    }

    private byte[] readSource(InputStream in, int len) throws IOException {
        byte[] result = new byte[len];
        int n = 0;
        while (n < len) {
            int count = in.read(result, n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            in = null;
        }
        return result;
    }

    private void resolveClass(PrintWriter pw, String[] refs, ReferencedLoader loader, Vector references, Vector notReferenced, HashSet notNeeded, String className, HashSet resolved, HashSet neededExtraReferences, boolean logAll, HashSet notFoundClasses) {
        int i = 0;
        while (i < refs.length) {
            String fileName = refs[i];
            if (!resolved.contains(fileName)) {
                URL o = loader.getRefResource(fileName);
                if (o == null && (o = loader.getParent().getResource(fileName)) == null) {
                    int j = 0;
                    while (j < references.size()) {
                        ReferencedLoader refLoader = (ReferencedLoader)references.get(j);
                        o = refLoader.getRefResource(fileName);
                        if (o != null) {
                            notNeeded.remove(refLoader.getName());
                            break;
                        }
                        ++j;
                    }
                    if (o == null) {
                        int j2 = 0;
                        while (j2 < notReferenced.size()) {
                            ReferencedLoader refLoader = (ReferencedLoader)notReferenced.get(j2);
                            o = refLoader.getRefResource(fileName);
                            if (o != null) {
                                if (logAll) {
                                    pw.println(" [warning] missing " + fileName);
                                    pw.println("              dependant " + className);
                                    pw.println("                 found in " + refLoader.getName());
                                }
                                if (neededExtraReferences.contains(refLoader.getName())) break;
                                neededExtraReferences.add(refLoader.getName());
                                break;
                            }
                            ++j2;
                        }
                        if (o == null) {
                            if (logAll) {
                                pw.println(" [warning] missing " + fileName);
                                pw.println("              dependant " + className);
                                pw.println("                 not found in any loader");
                            } else {
                                notFoundClasses.add(fileName);
                            }
                        }
                    }
                }
                if (logAll) {
                    if (o != null) {
                        resolved.add(fileName);
                    }
                } else {
                    resolved.add(fileName);
                }
            }
            ++i;
        }
    }

    private String[] getClassReferences(byte[] bytecode) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytecode);
        DataInputStream in = new DataInputStream(inStream);
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Bad magic number : " + Integer.toHexString(magic));
        }
        int minorVersion = in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        int ncp = in.readUnsignedShort();
        Entry[] constantPool = new Entry[ncp];
        int i = 1;
        while (i < ncp) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 7: {
                    int value0 = in.readUnsignedShort();
                    constantPool[i] = new Entry(7, value0, null);
                    break;
                }
                case 8: {
                    int value0 = in.readUnsignedShort();
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int value0 = in.readUnsignedShort();
                    int value1 = in.readUnsignedShort();
                    break;
                }
                case 3: 
                case 4: {
                    int value0 = in.readInt();
                    break;
                }
                case 5: 
                case 6: {
                    int value0 = in.readInt();
                    int value1 = in.readInt();
                    ++i;
                    break;
                }
                case 1: {
                    String s = in.readUTF();
                    constantPool[i] = new Entry(1, 0, s);
                    break;
                }
                default: {
                    throw new IOException("Invalid constant pool tag : " + new Integer(tag));
                }
            }
            ++i;
        }
        HashSet<String> result = new HashSet<String>();
        int i2 = 0;
        while (i2 < constantPool.length) {
            if (constantPool[i2] != null && constantPool[i2].type == 7) {
                Entry e = constantPool[constantPool[i2].index];
                if (!e.entryName.endsWith(";")) {
                    if (!e.entryName.startsWith("[")) {
                        result.add(e.entryName + ".class");
                    }
                } else {
                    int separatorindex = e.entryName.indexOf(59);
                    int lindex = e.entryName.indexOf(76);
                    if (lindex != -1) {
                        result.add(e.entryName.substring(lindex + 1, separatorindex).replace('.', '/') + ".class");
                    } else {
                        result.add(e.entryName);
                    }
                }
            }
            ++i2;
        }
        in.skipBytes(2);
        int thisIndex = in.readUnsignedShort();
        in.skipBytes(2);
        in.skipBytes(in.readUnsignedShort() * 2);
        int[] fields_descriptors = new int[in.readUnsignedShort()];
        int i3 = 0;
        while (i3 < fields_descriptors.length) {
            in.skipBytes(4);
            fields_descriptors[i3] = in.readUnsignedShort();
            int attr = in.readUnsignedShort();
            int j = 0;
            while (j < attr) {
                in.skipBytes(2);
                in.skipBytes(in.readInt());
                ++j;
            }
            ++i3;
        }
        int[] methods_descriptors = new int[in.readUnsignedShort()];
        int i4 = 0;
        while (i4 < methods_descriptors.length) {
            in.skipBytes(4);
            methods_descriptors[i4] = in.readUnsignedShort();
            int attr = in.readUnsignedShort();
            int j = 0;
            while (j < attr) {
                in.skipBytes(2);
                in.skipBytes(in.readInt());
                ++j;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < fields_descriptors.length) {
            this.parseDescriptor(constantPool[fields_descriptors[i5]].entryName, result);
            ++i5;
        }
        int i6 = 0;
        while (i6 < methods_descriptors.length) {
            this.parseDescriptor(constantPool[methods_descriptors[i6]].entryName, result);
            ++i6;
        }
        in.close();
        return result.toArray(new String[result.size()]);
    }

    private final void parseDescriptor(String descriptor, Set set) {
        int i1 = 0;
        while ((i1 = descriptor.indexOf(76, i1)) != -1) {
            int i2 = descriptor.indexOf(59, i1);
            if (i2 == -1) break;
            String name = descriptor.substring(i1 + 1, i2) + ".class";
            set.add(name);
            i1 = i2;
        }
    }

    private void checkSameEntries(PrintWriter pw) {
        Node node;
        Hashtable<String, Node> jarHashtable = new Hashtable<String, Node>();
        Enumeration<Object> enumeration = this.lc.listLoaders();
        while (enumeration.hasMoreElements()) {
            String loaderName = (String)enumeration.nextElement();
            ReferencedLoader loader = (ReferencedLoader)this.lc.getClassLoader(loaderName);
            if (loader == null) continue;
            String[] jars = loader.getResourceNames();
            int i = 0;
            while (i < jars.length) {
                String jarName = new File(jars[i]).getName();
                Node root = (Node)jarHashtable.get(jarName);
                if (root == null) {
                    root = new Node(loaderName, null, jars[i]);
                    jarHashtable.put(jarName, root);
                } else {
                    Node newNode;
                    root.next = newNode = new Node(loaderName, root.next, jars[i]);
                }
                ++i;
            }
        }
        enumeration = jarHashtable.keys();
        boolean firstTime = true;
        while (enumeration.hasMoreElements()) {
            String jarName = (String)enumeration.nextElement();
            node = (Node)jarHashtable.get(jarName);
            if (node.next == null) continue;
            if (firstTime) {
                pw.println("Jar collision : ");
                firstTime = false;
            }
            pw.println(" " + jarName);
            do {
                pw.println("  component : " + node.name);
                pw.println("   path : " + node.desc);
            } while ((node = node.next) != null);
            pw.println();
        }
        Hashtable classHashtable = new Hashtable();
        enumeration = jarHashtable.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            String fileName = node.desc;
            if (!fileName.endsWith(".jar")) continue;
            this.getFilesFromJar(pw, node.desc, node.name, classHashtable);
        }
        firstTime = true;
        enumeration = classHashtable.keys();
        while (enumeration.hasMoreElements()) {
            String className = (String)enumeration.nextElement();
            Node node2 = (Node)classHashtable.get(className);
            if (node2.next == null) continue;
            if (firstTime) {
                pw.println("Class collision : ");
                firstTime = false;
            }
            pw.println(" " + className);
            do {
                pw.println("  component : " + node2.name);
                pw.println("   path : " + node2.desc);
            } while ((node2 = node2.next) != null);
            pw.println();
        }
    }

    private void getFilesFromJar(PrintWriter pw, String jarName, String componentName, Hashtable classHashtable) {
        JarFile jarFile = null;
        File jar = new File(jarName);
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException e) {
            try {
                pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + jar.getCanonicalPath());
            }
            catch (IOException e1) {
                pw.println(" [warning] " + e.getClass() + " : " + e.getMessage() + " : " + jar.getAbsolutePath());
            }
            return;
        }
        String shortJarName = jar.getName();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String entryName;
            JarEntry entry = enumeration.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
            Node root = (Node)classHashtable.get(entryName);
            if (root == null) {
                classHashtable.put(entryName, new Node(componentName, null, shortJarName));
                continue;
            }
            root.next = new Node(componentName, root.next, shortJarName);
        }
        try {
            jarFile.close();
        }
        catch (IOException e) {
            jarFile = null;
        }
    }

    class Node {
        String name;
        String desc;
        Node next;

        public Node(String name, Node next, String desc) {
            this.name = name;
            this.next = next;
            this.desc = desc;
        }
    }

    static class Entry {
        int type;
        int index;
        String entryName;

        public Entry(int type, int index, String entryName) {
            this.type = type;
            this.index = index;
            this.entryName = entryName;
        }

        public String toString() {
            return this.entryName;
        }
    }

    private static class ClassComparator
    implements Comparator {
        static ClassComparator singleton = null;

        private ClassComparator() {
        }

        private static ClassComparator getClassComparator() {
            if (singleton == null) {
                singleton = new ClassComparator();
            }
            return singleton;
        }

        public int compare(Object o1, Object o2) {
            Class cls1 = (Class)o1;
            Class cls2 = (Class)o2;
            String package1 = cls1.getPackage().getName();
            String package2 = cls2.getPackage().getName();
            if (package1.length() == package2.length()) {
                int result = package1.compareTo(package2);
                if (result == 0) {
                    String className1 = cls1.getName();
                    String className2 = cls2.getName();
                    if (className1.length() != className2.length()) {
                        return className1.length() - className2.length();
                    }
                    return className1.compareTo(className2);
                }
                return result;
            }
            return package1.length() - package2.length();
        }
    }
}

