/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.container.monitor.LibraryMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.adminadapter.AdminAdapterFrame;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.management.MBeanServer;

public class ListLibrariesCommand
implements Command {
    private PrintWriter out;
    private SystemMonitor sm;
    private ClusterMonitor cm;
    private int currentClusterID;
    private MBeanServer server;
    private static final byte MAX_STATUS_LENGHT = 10;
    private static final byte MAX_NAME_LENGHT = 69;

    public ListLibrariesCommand(SystemMonitor sm, ClusterMonitor cm, MBeanServer server) {
        this.sm = sm;
        this.cm = cm;
        this.server = server;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        this.out = new PrintWriter(os, true);
        int clusterID = this.currentClusterID;
        boolean displayName = false;
        if (params.length != 0) {
            if (params.length > 2) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSL] Wrong number of parameters.\r\n");
                return;
            }
            if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                this.out.println(this.getHelpMessage());
                return;
            }
            if (params[0].equalsIgnoreCase("-d")) {
                displayName = true;
                if (params.length == 2) {
                    try {
                        clusterID = Integer.parseInt(params[1]);
                    }
                    catch (NumberFormatException e) {
                        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSL] Invalid ID!\r\n");
                        return;
                    }
                }
            } else {
                try {
                    clusterID = Integer.parseInt(params[0]);
                }
                catch (NumberFormatException e) {
                    new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSL] Invalid ID!\r\n");
                    return;
                }
            }
        }
        String[][] result = null;
        if (this.currentClusterID == clusterID) {
            LibraryMonitor[] libraries = this.sm.getLibraries();
            result = new String[libraries.length][3];
            int i = 0;
            while (i < libraries.length) {
                result[i][0] = libraries[i].getDisplayName();
                result[i][1] = libraries[i].getComponentName();
                result[i][2] = ListLibrariesCommand.statusToString(libraries[i].getStatus());
                ++i;
            }
        } else {
            ClusterElement[] clusterElements = this.cm.getParticipants();
            boolean notFound = true;
            int i = 0;
            while (i < clusterElements.length) {
                try {
                    if (clusterElements[i].getClusterId() == clusterID) {
                        result = (String[][])this.server.invoke(AdminAdapterFrame.getRepresentativeMBeanObjectName(clusterID), "getAllLibrariesInfo", new Object[0], new String[0]);
                        notFound = false;
                        break;
                    }
                }
                catch (Exception e) {
                    new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSL] Could not list the libraries !\r\n[Shell -> LSL] Reason : " + e.getMessage() + "\r\n");
                    return;
                }
                ++i;
            }
            if (notFound) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSL] There is no such cluster ID : " + clusterID + "\r\n");
                return;
            }
        }
        this.listLibraries(result, displayName);
    }

    private void listLibraries(String[][] result, boolean displayName) {
        int namePosition = displayName ? 0 : 1;
        int nameLen = result[0][namePosition].length();
        Vector<String> libraries = new Vector<String>();
        int i = 1;
        while (i < result.length) {
            nameLen = nameLen < result[i][namePosition].length() ? result[i][namePosition].length() : nameLen;
            ++i;
        }
        nameLen = nameLen > 69 ? 69 : nameLen;
        this.out.println();
        this.out.println("NAME" + this.spaces(nameLen - 4, ' ') + "  STATUS");
        this.out.println(this.spaces(nameLen + 10, '-'));
        libraries.add(result[0][namePosition] + this.spaces(nameLen - result[0][namePosition].length() % 69, ' ') + result[0][2]);
        int i2 = 1;
        while (i2 < result.length) {
            String nextLibrary = result[i2][namePosition] + this.spaces(nameLen - result[i2][namePosition].length() % 69, ' ') + result[i2][2];
            boolean add = false;
            int j = 0;
            while (j < libraries.size()) {
                if (((String)libraries.elementAt(j)).compareToIgnoreCase(nextLibrary) > 0) {
                    libraries.insertElementAt(nextLibrary, j);
                    add = true;
                    break;
                }
                ++j;
            }
            if (!add) {
                libraries.add(libraries.size(), nextLibrary);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < libraries.size()) {
            String nextLine = (String)libraries.elementAt(i3);
            while (nextLine.length() > 79) {
                this.out.println(nextLine.substring(0, 69));
                nextLine = nextLine.substring(69);
            }
            this.out.println(nextLine);
            ++i3;
        }
        this.out.println();
    }

    private String spaces(int n, char space) {
        if (n > 0) {
            StringBuffer ret = new StringBuffer(n);
            int i = 0;
            while (i < n) {
                ret.append(space);
                ++i;
            }
            return ret.toString();
        }
        return "";
    }

    public static String statusToString(byte status) {
        switch (status) {
            case 2: {
                return "  deployed";
            }
            case 3: {
                return "  resolved";
            }
            case 4: {
                return "  loaded  ";
            }
            case 5: {
                return "  active  ";
            }
        }
        return "  missing ";
    }

    public String getHelpMessage() {
        return "\r\nLists all libraries installed on the specified cluster element.\r\nUsage: LSL [-d] [ClusterID]\r\nParameters:\r\n  [-d]        - lists the libraries using their display names\r\n                instead of their component names.\r\n  [ClusterID] - ID of the cluster element. Default value is the ID\r\n                of the current cluster element.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LSL";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

