/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeMap;

public class ListClusterCommand
implements Command {
    private final int MAX_ID_LENGTH = 10;
    private final int MAX_GROUP_LENGTH = 10;
    private final int MAX_HOST_LENGTH = 16;
    private final int MAX_PORT_LENGTH = 5;
    private final int MAX_TYPE_LENGTH = 10;
    private final int MAX_STATE_LENGTH = 10;
    private final int MAX_NAME_LENGTH = 11;
    private static final String _79 = "-------------------------------------------------------------------------------";
    private static final String sp16 = "                ";
    private SystemMonitor sm;
    private ClusterMonitor cm;
    private PrintWriter out;

    public ListClusterCommand(SystemMonitor sm, ClusterMonitor cm) {
        this.sm = sm;
        this.cm = cm;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        this.out = new PrintWriter(os, true);
        if (params.length > 0) {
            if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                this.out.println(this.getHelpMessage());
            } else if (params[0].equalsIgnoreCase("-state")) {
                ClusterElement ci = this.cm.getCurrentParticipant();
                ClusterElement[] elements = this.cm.getParticipants();
                elements = this.sort(elements);
                int[] states = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
                byte by = ci.getState();
                states[by] = states[by] + 1;
                int i = 0;
                while (i < elements.length) {
                    byte by2 = elements[i].getState();
                    states[by2] = states[by2] + 1;
                    ++i;
                }
                this.out.println();
                this.out.println("Initial    - " + states[0]);
                this.out.println("Wait start - " + states[1]);
                this.out.println("Starting   - " + states[2]);
                this.out.println("Running    - " + states[3]);
                this.out.println("Wait stop  - " + states[4]);
                this.out.println("Stopping   - " + states[5]);
                this.out.println("Stopped    - " + states[6]);
                this.out.println("Debugging  - " + states[7]);
                this.out.println();
            } else {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> LSC] Unknown parameter " + params[0] + "\r\n");
            }
        } else {
            ClusterElement ci = this.cm.getCurrentParticipant();
            ClusterElement[] elements = this.cm.getParticipants();
            elements = this.sort(elements);
            this.out.print(this.placeCenter("NAME", 11));
            this.out.print(this.placeCenter("ID", 10));
            this.out.print(this.placeCenter("GROUP", 10));
            this.out.print(this.placeCenter("HOST", 16));
            this.out.print(this.placeCenter("PORT", 5));
            this.out.print(this.placeCenter("TYPE", 10));
            this.out.println(this.placeCenter("STATE", 10));
            this.out.println(_79);
            String id = String.valueOf(ci.getClusterId());
            String group = String.valueOf(ci.getGroupId());
            String host = ci.getAddress().getHostAddress();
            String port = null;
            String type = null;
            if (this.sm.getContainerType() == 2) {
                port = String.valueOf(ci.getJoinPort());
                type = "server";
            } else {
                port = "N/A";
                type = "dispatcher";
            }
            String state = "";
            switch (ci.getState()) {
                case 0: {
                    state = "initial";
                    break;
                }
                case 1: {
                    state = "wait start";
                    break;
                }
                case 2: {
                    state = "starting";
                    break;
                }
                case 3: {
                    state = "running";
                    break;
                }
                case 4: {
                    state = "wait stop";
                    break;
                }
                case 6: {
                    state = "stopped";
                    break;
                }
                case 5: {
                    state = "stopping";
                    break;
                }
                case 7: {
                    state = "debugging";
                }
            }
            this.printName(ci.getName());
            this.out.print(this.placeCenter(id, 10));
            this.out.print(this.placeCenter(group, 10));
            this.out.print(this.placeCenter(host, 16));
            this.out.print(this.placeCenter(port, 5));
            this.out.print(this.placeCenter(type, 10));
            this.out.println(this.placeCenter(state, 10));
            this.out.println(_79);
            int k = 0;
            while (k < elements.length) {
                ci = elements[k];
                id = String.valueOf(ci.getClusterId());
                group = String.valueOf(ci.getGroupId());
                host = ci.getAddress().getHostAddress();
                ClusterElement cl = this.cm.getParticipant(ci.getClusterId());
                if (cl != null && cl.getType() == 2) {
                    port = String.valueOf(ci.getJoinPort());
                    type = "server";
                } else {
                    port = "N/A";
                    type = "dispatcher";
                }
                state = "";
                switch (ci.getState()) {
                    case 0: {
                        state = "initial";
                        break;
                    }
                    case 1: {
                        state = "wait start";
                        break;
                    }
                    case 2: {
                        state = "starting";
                        break;
                    }
                    case 3: {
                        state = "running";
                        break;
                    }
                    case 4: {
                        state = "wait stop";
                        break;
                    }
                    case 6: {
                        state = "stopped";
                        break;
                    }
                    case 5: {
                        state = "stopping";
                        break;
                    }
                    case 7: {
                        state = "debugging";
                    }
                }
                this.printName(ci.getName());
                this.out.print(this.placeCenter(id, 10));
                this.out.print(this.placeCenter(group, 10));
                this.out.print(this.placeCenter(host, 16));
                this.out.print(this.placeCenter(port, 5));
                this.out.print(this.placeCenter(type, 10));
                this.out.println(this.placeCenter(state, 10));
                this.out.println(_79);
                ++k;
            }
        }
    }

    private ClusterElement[] sort(ClusterElement[] elements) {
        TreeMap<String, ClusterElement> sorter = new TreeMap<String, ClusterElement>();
        int i = 0;
        while (i < elements.length) {
            sorter.put(elements[i].getName(), elements[i]);
            ++i;
        }
        Iterator it = sorter.keySet().iterator();
        int i2 = 0;
        while (i2 < elements.length) {
            elements[i2] = (ClusterElement)sorter.get(it.next());
            ++i2;
        }
        return elements;
    }

    private String placeCenter(String str, int len) {
        int rest = (len -= str.length()) % 2;
        len -= rest;
        String spLen = sp16.substring(0, len >>= 1);
        String spRest = rest == 0 ? "" : " ";
        return " " + spLen + str + spLen + spRest;
    }

    private void printName(String name) {
        if (name.length() < 11) {
            this.out.print(" " + name + sp16.substring(0, 11 - name.length()));
        } else {
            this.out.println(" " + name);
            this.out.print(sp16.substring(0, 12));
        }
    }

    public String getHelpMessage() {
        return "\r\nLists all active cluster machines.\r\nUsage: LSC [-state]\r\nParameters:\r\n  [-state] - simple cluster machines state list\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "LSC";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

