/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;

public class InfoCommand
implements Command {
    private final String[] sLabels = new String[]{"Current memory usage(Kb): ", "Total memory available(Kb): ", "Threads running: "};
    private int[] sResult;
    private int[] eResult;
    private int[] dResult;
    private final String[] jLabels = new String[]{"Java version: ", "Operating system: ", "Operating system version: ", "Java virtual machine version: ", "Java virtual machine vendor: ", "Java virtual machine name: ", "Java user directory: "};
    private PrintWriter pw;
    private Runtime runtime = null;
    private int currentUsage = 0;
    private int maxUsage = 0;
    private int[] lLens;
    private int[] rLens;
    private int[] sLens;
    private int[] lens;

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        this.pw = new PrintWriter(os, true);
        this.runtime = Runtime.getRuntime();
        if (params.length == 0) {
            this.list();
            return;
        }
        if (params.length > 0) {
            if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                this.pw.println(this.getHelpMessage());
                return;
            }
            if (params[0].equalsIgnoreCase("-system")) {
                this.listSystem();
                return;
            }
            if (params[0].equalsIgnoreCase("-java")) {
                this.listJava();
                return;
            }
            if (params.length == 2) {
                if (params[0].equalsIgnoreCase("-status")) {
                    this.listStatus(params[1]);
                } else {
                    new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> INFO] Unknown parameter " + params[0] + "\r\n");
                }
                return;
            }
        }
        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> INFO] Wrong number of parameters.\r\n");
    }

    private void listJava() {
        String[] jResult = new String[]{SystemProperties.getProperty((String)"java.version"), SystemProperties.getProperty((String)"os.name"), SystemProperties.getProperty((String)"os.version"), SystemProperties.getProperty((String)"java.vm.version"), SystemProperties.getProperty((String)"java.vm.vendor"), SystemProperties.getProperty((String)"java.vm.name"), SystemProperties.getProperty((String)"user.dir")};
        this.pw.print("\r\n");
        this.pw.println("JavaVM Info");
        this.lLens = new int[7];
        this.rLens = new int[7];
        int i = 0;
        while (i < 7) {
            this.lLens[i] = this.jLabels[i].length();
            this.rLens[i] = jResult[i].length();
            ++i;
        }
        Arrays.sort(this.lLens);
        Arrays.sort(this.rLens);
        int i2 = 0;
        while (i2 < this.lLens[6] + this.rLens[6] + this.spaces(2).length()) {
            this.pw.print("-");
            ++i2;
        }
        this.pw.print("\r\n");
        int i3 = 0;
        while (i3 < 7) {
            this.pw.println(this.jLabels[i3] + this.spaces(this.lLens[6] - this.jLabels[i3].length() + 2) + jResult[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.lLens[6] + this.rLens[6] + this.spaces(2).length()) {
            this.pw.print("-");
            ++i4;
        }
        this.pw.println();
    }

    private void listSystem() {
        this.sResult = new int[3];
        this.pw.print("\r\n");
        this.pw.println("System Info");
        this.lens = new int[3];
        int i = 0;
        while (i < 3) {
            this.lens[i] = this.sLabels[i].length();
            ++i;
        }
        Arrays.sort(this.lens);
        this.sResult = this.usageInfo();
        int i2 = 0;
        while (i2 < this.lens[2] + 28) {
            this.pw.print("-");
            ++i2;
        }
        this.pw.print("\r\n");
        this.pw.println(this.sLabels[0] + this.spaces(this.lens[2] - this.sLabels[0].length() + 4) + this.sResult[0]);
        this.pw.println(this.sLabels[1] + this.spaces(this.lens[2] - this.sLabels[1].length() + 4) + this.sResult[1]);
        this.pw.print("\r\n");
        this.pw.println(this.sLabels[2] + this.spaces(this.lens[2] - this.sLabels[2].length() + 4) + this.sResult[2]);
        int i3 = 0;
        while (i3 < this.lens[2] + 28) {
            this.pw.print("-");
            ++i3;
        }
        this.pw.println();
    }

    private int[] usageInfo() {
        int[] result = new int[3];
        float total = this.runtime.totalMemory();
        this.maxUsage = (int)(total / 1024.0f);
        float free = this.runtime.freeMemory();
        result[0] = this.currentUsage = (int)((total - free) / 1024.0f);
        result[1] = this.maxUsage;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        result[2] = threadGroup.enumerate(new Thread[threadGroup.activeCount()]);
        return result;
    }

    public synchronized void listStatus(String time) {
        this.sResult = new int[3];
        this.eResult = new int[3];
        this.dResult = new int[3];
        this.pw.print("\r\n");
        String com = "Status Compare:";
        String prev = "Previous";
        String now = "Current";
        String dif = "Compared";
        this.sLens = new int[3];
        int i = 0;
        while (i < 3) {
            this.sLens[i] = this.sLabels[i].length();
            ++i;
        }
        Arrays.sort(this.sLens);
        String res = com + this.spaces(this.sLens[2] - com.length() + 1) + prev + this.spaces(2) + now + this.spaces(2) + dif;
        this.pw.println(res);
        this.sResult = this.usageInfo();
        try {
            Thread.currentThread();
            Thread.sleep(new Long(time));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.eResult = this.usageInfo();
        this.dResult[0] = this.eResult[0] - this.sResult[0];
        this.dResult[1] = this.eResult[1] - this.sResult[1];
        this.dResult[2] = this.eResult[2] - this.sResult[2];
        int i2 = 0;
        while (i2 < res.length() + 1) {
            this.pw.print("-");
            ++i2;
        }
        this.pw.print("\r\n");
        new Integer(this.eResult[0]);
        this.pw.println(this.sLabels[0] + this.spaces(this.sLens[2] - this.sLabels[0].length() + 1) + this.sResult[0] + this.spaces(prev.length() - Integer.toString(this.sResult[0]).length() + 2) + this.eResult[0] + this.spaces(now.length() - new Integer(this.eResult[0]).toString().length() + 2) + this.dResult[0]);
        new Integer(this.eResult[1]);
        this.pw.println(this.sLabels[1] + this.spaces(this.sLens[2] - this.sLabels[1].length() + 1) + this.sResult[1] + this.spaces(prev.length() - Integer.toString(this.sResult[1]).length() + 2) + this.eResult[1] + this.spaces(now.length() - new Integer(this.eResult[1]).toString().length() + 2) + this.dResult[1]);
        this.pw.print("\r\n");
        new Integer(this.eResult[2]);
        this.pw.println(this.sLabels[2] + this.spaces(this.sLens[2] - this.sLabels[2].length() + 1) + this.sResult[2] + this.spaces(prev.length() - Integer.toString(this.sResult[2]).length() + 2) + this.eResult[2] + this.spaces(now.length() - new Integer(this.eResult[2]).toString().length() + 2) + this.dResult[2]);
        int h = 0;
        while (h < res.length() + 1) {
            this.pw.print("-");
            ++h;
        }
        this.pw.println();
    }

    public void list() {
        this.listJava();
        this.listSystem();
    }

    private String spaces(int n) {
        if (n > 0) {
            StringBuffer ret = new StringBuffer(n);
            int i = 0;
            while (i < n) {
                ret.append(' ');
                ++i;
            }
            return ret.toString();
        }
        return "";
    }

    public String getHelpMessage() {
        return "\r\nLists system information.\r\nUsage: INFO [-java] | [-system] | [-status <time>]\r\nParameters:\r\n  -java          - Lists javaVM information.\r\n  -system        - Lists system information.\r\n  -status <time> - Compares system information changes during \r\n                   this time lap (in milliseconds)\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "INFO";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

