/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class DebugManagerCommand
implements Command {
    private ServiceContext sc;

    public DebugManagerCommand(ServiceContext sc) {
        this.sc = sc;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        if (params.length == 0 || params.length > 2) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> DEBUGMANAGER] Wrong number of parameters.\r\n");
            return;
        }
        if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        String managerName = params[0];
        Object manager = this.sc.getCoreContext().getReflectContext().getCoreComponent(managerName);
        if (manager == null) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> DEBUGMANAGER] There is no manager with name '" + managerName + "'!\r\n");
            return;
        }
        int flag = -1;
        if (params.length == 2) {
            try {
                flag = Integer.parseInt(params[1], 16);
            }
            catch (NumberFormatException e) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> DEBUGMANAGER] The <flag> parameter must be valid 32-bit hexadecimal value without '0x' prefix.\r\n");
                return;
            }
        }
        String debugInfo = null;
        try {
            Method method = manager.getClass().getMethod("getDebugInfo", Integer.TYPE);
            debugInfo = (String)method.invoke(manager, new Integer(flag));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debugInfo == null) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> DEBUGMANAGER] There is no debug information available yet for this manager!\r\n");
            return;
        }
        out.println();
        out.println(debugInfo);
        out.println();
    }

    public String getHelpMessage() {
        return "\r\nDisplays debug information for a manager.\r\nUsage: DEBUGMANAGER <managerName> [<flag>]\r\nParameters:\r\n  <managerName> - The name of the manager for which will be displayed debug\r\n                  information.\r\n  <flag> - A 32-bit hexadecimal flag which determines which part of the whole\r\n           debug information will be displayed. If this parameter is missed,\r\n           it is set to FFFFFFFF.\r\n";
    }

    public String getGroup() {
        return "DEBUG";
    }

    public String getName() {
        return "DEBUGMANAGER";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

