/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class ChangeServicePropertyCommand
implements Command {
    private int currentClusterID;
    private int clusterID;
    private MBeanServer server;

    public ChangeServicePropertyCommand(int currentClusterID, MBeanServer server) {
        this.currentClusterID = currentClusterID;
        this.clusterID = currentClusterID;
        this.server = server;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        if (params.length == 0 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        Properties props = new Properties();
        String serviceName = null;
        if (params.length > 2) {
            int i = 0;
            while (i < params.length - 1) {
                if (params[i].equalsIgnoreCase("-f")) {
                    if (++i == params.length - 1) {
                        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] The fileName is not specified.\r\n");
                        return;
                    }
                    String fileName = params[i];
                    try {
                        props.load(new FileInputStream(fileName));
                    }
                    catch (IOException e) {
                        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] Properties can't be loaded from file : " + fileName + "\r\n");
                        return;
                    }
                }
                if (params[i].equalsIgnoreCase("-p")) {
                    serviceName = params[params.length - 1];
                    if (++i == params.length - 1) {
                        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] The name of the property is not specified.\r\n");
                        return;
                    }
                    if (++i == params.length - 1) {
                        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] The value of the property is not specified.\r\n");
                        return;
                    }
                    props.setProperty(params[i - 1], params[i]);
                } else {
                    try {
                        this.clusterID = Integer.valueOf(params[i]);
                        if (!this.correctClusterID()) {
                            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] The specified clusterID is not found.\r\n");
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] The clusterID is not specified correctly.\r\n");
                        return;
                    }
                }
                ++i;
            }
            if (((Hashtable)props).size() == 0) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] The properties are not specified.\r\n");
                return;
            }
            serviceName = params[params.length - 1];
            out.println("\r\n[Shell -> SETSP] Setting the properties of '" + serviceName + "'!");
            try {
                ObjectName serviceManagement = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)serviceName, (String)String.valueOf(this.clusterID), (String)"\"\"");
                if (((Boolean)this.server.invoke(serviceManagement, "setProperties", new Object[]{props}, new String[]{"java.util.Properties"})).booleanValue()) {
                    out.println("[Shell -> SETSP] Done.\r\n");
                }
                out.println("\r\n[Shell -> SETSP] Properties have not changed.\r\n");
            }
            catch (InstanceNotFoundException infe) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] The specified service name is not correct.\r\n");
                return;
            }
            catch (MBeanException mbe) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] Could not set the properties for the service. The reason reported by the service is : \"" + mbe.getTargetException().getMessage() + "\".\r\n");
            }
            catch (RuntimeMBeanException rmbe) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] Could not set the properties for the service. A runtime exception was thrown while setting properties. It's message is : \"" + rmbe.getTargetException().getMessage() + "\".\r\n");
            }
            catch (ReflectionException re) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] Could not set the properties for the service. No appropriate method was found.\r\n");
            }
            catch (MalformedObjectNameException mone) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] Could not set the properties for the service. Wrong MBean name was supplied.\r\n");
            }
        } else {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SETSP] Wrong number of parameters!\r\n");
        }
    }

    private boolean correctClusterID() {
        if (this.clusterID != this.currentClusterID) {
            boolean result = false;
            try {
                result = this.server.isRegistered(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)("kernel_" + this.clusterID), (String)String.valueOf(this.clusterID), (String)"\"\""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        return true;
    }

    public String getHelpMessage() {
        return "\r\nSet service properties - Loads new property values for the specified service.\r\nUsage: SETSP <[[-f <fileName1>] [-f <fileName2>]...] [[-p <key1> <value1>]\r\n             [-p <key2> <value2>]...]> [clusterID] <serviceName>\r\nParameters:\r\n  [-f <fileNameX>] - sets the properties from a file named <fileNameX>\r\n                     to the specified service.\r\n  [-p <keyX> <valueX> - sets the property named <keyX>, with value <valueX>\r\n                        to the specified service.\r\n  [clusterID] - sets the service properties to the specified cluster element.\r\n  <serviceName> - the service which properties will be set.\r\nExamples:\r\n  SETSP -f p4.properties p4\r\n  SETSP -p Port 80 -p SslPort 443 http\r\n  SETSP -f log1.properties -p DLog true -f log2.properties -p LogLevel 6\r\n        -p LogDumpLevel 3 4001 log\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "SETSP";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

