/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class ChangeManagerPropertyCommand
implements Command {
    private MBeanServer server;
    private int currentClusterID;
    private int clusterID;
    private ClusterMonitor cm;

    public ChangeManagerPropertyCommand(ClusterMonitor cm, MBeanServer server) {
        this.cm = cm;
        this.clusterID = this.currentClusterID = cm.getCurrentParticipant().getClusterId();
        this.server = server;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        PrintWriter err = new PrintWriter(env.getErrorStream(), true);
        if (params.length == 0 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        Properties props = new Properties();
        String managerName = null;
        this.clusterID = -1;
        if (params.length > 2) {
            int i = 0;
            while (i < params.length - 1) {
                if (params[i].equalsIgnoreCase("-f")) {
                    if (++i == params.length - 1) {
                        err.println("\r\n[Shell -> SETMP] The fileName is not specified.\r\n");
                        return;
                    }
                    String fileName = params[i];
                    try {
                        props.load(new FileInputStream(fileName));
                    }
                    catch (IOException e) {
                        err.println("\r\n[Shell -> SETMP] Properties can't be loaded from file : " + fileName + "\r\n");
                        return;
                    }
                }
                if (params[i].equalsIgnoreCase("-p")) {
                    managerName = params[params.length - 1];
                    if (++i == params.length - 1) {
                        err.println("\r\n[Shell -> SETMP] The name of the property is not specified.\r\n");
                        return;
                    }
                    if (++i == params.length - 1) {
                        err.println("\r\n[Shell -> SETMP] The value of the property is not specified.\r\n");
                        return;
                    }
                    props.setProperty(params[i - 1], params[i]);
                } else {
                    try {
                        this.clusterID = Integer.valueOf(params[i]);
                        if (this.clusterID != 0 && !this.correctClusterID()) {
                            err.println("\r\n[Shell -> SETMP] The specified clusterID is not found.\r\n");
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        err.println("\r\n[Shell -> SETMP] The clusterID is not specified correctly.\r\n");
                        return;
                    }
                }
                ++i;
            }
            if (this.clusterID == -1) {
                this.clusterID = this.currentClusterID;
            }
            if (((Hashtable)props).size() == 0) {
                err.println("\r\n[Shell -> SETMP] The properties are not specified.\r\n");
                return;
            }
            managerName = params[params.length - 1];
            if (this.clusterID != 0) {
                this.setProps(managerName, this.clusterID, props, out, err);
            } else {
                this.setProps(managerName, this.currentClusterID, props, out, err);
                ClusterElement[] elements = this.cm.getParticipants();
                int j = 0;
                while (j < elements.length) {
                    this.setProps(managerName, elements[j].getClusterId(), props, out, err);
                    ++j;
                }
            }
        } else {
            err.println("[Shell -> SETMP] Wrong number of parameters!\r\n");
        }
    }

    private void setProps(String managerName, int clusterID, Properties props, PrintWriter out, PrintWriter err) {
        out.println("\r\n[Shell -> SETMP] Setting the properties of '" + managerName + "' on cluster element '" + clusterID + "'!");
        try {
            if (((Boolean)this.server.invoke(this.generateKernelObjectName(clusterID), "setManagerProperties", new Object[]{managerName, props}, new String[]{"java.lang.String", "java.util.Properties"})).booleanValue()) {
                out.println("[Shell -> SETMP] Done.\r\n");
            } else {
                out.println("[Shell -> SETMP] Properties have not changed.\r\n");
            }
        }
        catch (InstanceNotFoundException infe) {
            err.println("\r\n[Shell -> SETMP] Could not set the properties for the manager. Kernel MBean not found.\r\n");
            return;
        }
        catch (MBeanException mbe) {
            err.println("\r\n[Shell -> SETMP] Could not set the properties for the manager. The reason reported by the manager is : \"" + mbe.getTargetException().getMessage() + "\".\r\n");
        }
        catch (RuntimeMBeanException rmbe) {
            err.println("\r\n[Shell -> SETMP] Could not set the properties for the manager. A runtime exception was thrown while setting properties. It's message is : \"" + rmbe.getTargetException().getMessage() + "\".\r\n");
        }
        catch (ReflectionException re) {
            err.println("\r\n[Shell -> SETMP] Could not set the properties for the manager. No appropriate method was found.\r\n");
        }
        catch (MalformedObjectNameException mone) {
            err.println("\r\n[Shell -> SETMP] Could not set the properties for the manager. Wrong MBean name was supplied.\r\n");
        }
    }

    private boolean correctClusterID() {
        if (this.clusterID != this.currentClusterID) {
            boolean result = false;
            try {
                result = this.server.isRegistered(this.generateKernelObjectName(this.clusterID));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        return true;
    }

    private ObjectName generateKernelObjectName(int id) throws MalformedObjectNameException {
        return ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)("kernel_" + id), (String)String.valueOf(id), (String)"\"\"");
    }

    public String getHelpMessage() {
        return "\r\nSet manager properties - Loads new property values for the specified manager.\r\nUsage: SETMP <[[-f <fileName1>] [-f <fileName2>]...] [[-p <key1> <value1>]\r\n             [-p <key2> <value2>]...]> [clusterID] <managerName>\r\nParameters:\r\n  [-f <fileNameX>] - sets the properties from a file named <fileNameX>\r\n                     to the specified manager.\r\n  [-p <keyX> <valueX>] - sets the property named <keyX>, with value <valueX> \r\n                         to the specified manager.\r\n  [clusterID] - sets the manager properties to the specified cluster element.\r\n                Default value is the ID of the current cluster element. If \r\n                [ClusterID] is 0, properties will be set to all cluster elements.\r\n  <managerName> - the manager which properties will be set.\r\nExamples:\r\n  SETMP -f cluster.properties ClusterManager\r\n  SETMP -p DefaultLogLevel INFO -p DefaultConsoleDumpLevel ERROR LogManager\r\n  SETMP -f cfg1.properties -p tracelevel 1 -f cfg2.properties\r\n        -p rdbms.user user -p rdbms.password pass 4001 ConfigurationManager\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "SETMP";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

