/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class AnalyseCommand
implements Command {
    private ServiceContext sc;
    private boolean standalone;
    private int currentClusterID;

    public AnalyseCommand(ServiceContext sc, boolean standalone, int currentClusterID) {
        this.sc = sc;
        this.standalone = standalone;
        this.currentClusterID = currentClusterID;
    }

    public native void doDump();

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        char sep = File.separatorChar;
        boolean leech = false;
        boolean threaddump = false;
        String engType = "cluster";
        String leechHost = "";
        int leechPort = -1;
        if (params != null && params.length > 0) {
            int i = 0;
            while (i < params.length) {
                if (params[i].equals("-engtype")) {
                    engType = params[i + 1];
                } else if (params[i].equals("-leech")) {
                    leech = true;
                    leechHost = params[i + 1];
                    leechPort = Integer.parseInt(params[i + 2]);
                } else if (params[i].equals("-threaddump")) {
                    threaddump = true;
                }
                ++i;
            }
        } else {
            engType = this.standalone ? "alone" : "cluster";
        }
        if (threaddump) {
            this.doDump();
            return;
        }
        System.out.println(" ANALYSE .... leech: " + leech + "   engType: " + engType);
        System.out.println(" ANALYSE .... leechHost: " + leechHost + "   leechPort: " + leechPort);
        try {
            String osName = System.getProperty("os.name");
            String cmd = osName.startsWith("Windows") ? ".." + sep + ".." + sep + "tools" + sep + "analyseIt" + sep + "startAnalyser.bat -" + engType : ".." + sep + ".." + sep + "tools" + sep + "analyseIt" + sep + "startAnalyser.sh -" + engType;
            if (leech) {
                cmd = cmd + " -leech " + leechHost + " " + leechPort;
            }
            Runtime.getRuntime().exec(cmd);
            Thread.sleep(5000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getHelpMessage() {
        return "       Collects all available info from the SAP J2EE Engine, \r\n when the info is collected it is stored in a zip file somewhere :)USSAGE: ANALYSE [KEY]KEYS: \t<-all>      - collects online info from the runnig system and \t              offline info from alone and cluster if available  <-alone>    - collects online info from the system and offline from alone  <-cluster>  - collects online info from the system and offline from cluster";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "ANALYSE";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

