/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.adminadapter.AdminAdapterFrame;
import com.sap.engine.services.adminadapter.interfaces.MBeanRegistrationEventListener;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.engine.services.adminadapter.interfaces.ServiceEventListener;
import com.sap.engine.services.basicadmin.mbean.StandardServiceNotification;
import com.sap.engine.services.rmi_p4.P4RuntimeException;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ServiceTattler
implements NotificationListener,
MBeanRegistrationEventListener {
    private Vector listeners = null;
    private RemoteAdminInterface remoteAdminInterface = null;
    private MBeanServer jmxconn = null;
    private boolean isIntermediator = false;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$impl$ServiceTattler;

    public ServiceTattler(MBeanServer jmxconn, RemoteAdminInterface remoteAdminInterface) {
        this.jmxconn = jmxconn;
        this.remoteAdminInterface = remoteAdminInterface;
        this.listeners = new Vector();
    }

    public void registerServiceEventListener(ServiceEventListener sel) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.add(sel) && this.listeners.size() == 1) {
                this.registerAsIntermediator();
            }
        }
    }

    public void unregisterServiceEventListener(ServiceEventListener sel) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.remove(sel) && this.listeners.size() == 0) {
                this.unregisterAsIntermediator();
            }
        }
    }

    public void handleNotification(Notification notification, Object o) {
        block57: {
            int clusterId;
            String serviceName;
            String type;
            StandardServiceNotification note;
            block66: {
                block65: {
                    block64: {
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        block59: {
                                            block58: {
                                                block56: {
                                                    if (!(notification instanceof StandardServiceNotification)) {
                                                        return;
                                                    }
                                                    note = (StandardServiceNotification)notification;
                                                    type = note.getType();
                                                    serviceName = note.getServiceName();
                                                    clusterId = note.getClusterId();
                                                    if (!type.equals("service.lodaded")) break block56;
                                                    int i = 0;
                                                    while (i < this.listeners.size()) {
                                                        try {
                                                            ((ServiceEventListener)this.listeners.elementAt(i)).serviceLoaded(clusterId, serviceName);
                                                        }
                                                        catch (P4RuntimeException prex) {
                                                            this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                            --i;
                                                        }
                                                        catch (RemoteException rex) {
                                                            rex.printStackTrace();
                                                        }
                                                        catch (Exception exc) {
                                                            this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                            --i;
                                                        }
                                                        ++i;
                                                    }
                                                    break block57;
                                                }
                                                if (!type.equals("service.unloaded")) break block58;
                                                int i = 0;
                                                while (i < this.listeners.size()) {
                                                    try {
                                                        ((ServiceEventListener)this.listeners.elementAt(i)).serviceUnloaded(clusterId, serviceName);
                                                    }
                                                    catch (P4RuntimeException prex) {
                                                        this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                        --i;
                                                    }
                                                    catch (RemoteException rex) {
                                                        rex.printStackTrace();
                                                    }
                                                    catch (Exception exc) {
                                                        this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                        --i;
                                                    }
                                                    ++i;
                                                }
                                                break block57;
                                            }
                                            if (!type.equals("service.started")) break block59;
                                            int i = 0;
                                            while (i < this.listeners.size()) {
                                                try {
                                                    ((ServiceEventListener)this.listeners.elementAt(i)).serviceStarted(clusterId, serviceName);
                                                }
                                                catch (P4RuntimeException prex) {
                                                    this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                    --i;
                                                }
                                                catch (RemoteException rex) {
                                                    rex.printStackTrace();
                                                }
                                                catch (Exception exc) {
                                                    this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                    --i;
                                                }
                                                ++i;
                                            }
                                            break block57;
                                        }
                                        if (!type.equals("service.stopped")) break block60;
                                        int i = 0;
                                        while (i < this.listeners.size()) {
                                            try {
                                                ((ServiceEventListener)this.listeners.elementAt(i)).serviceStopped(clusterId, serviceName);
                                            }
                                            catch (P4RuntimeException prex) {
                                                this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                --i;
                                            }
                                            catch (RemoteException rex) {
                                                rex.printStackTrace();
                                            }
                                            catch (Exception exc) {
                                                this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                                --i;
                                            }
                                            ++i;
                                        }
                                        break block57;
                                    }
                                    if (!type.equals("service.startup.mode.changed")) break block61;
                                    int i = 0;
                                    while (i < this.listeners.size()) {
                                        try {
                                            ((ServiceEventListener)this.listeners.elementAt(i)).serviceStartupModeChanged(clusterId, serviceName, note.getStartupMode());
                                        }
                                        catch (P4RuntimeException prex) {
                                            this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                            --i;
                                        }
                                        catch (RemoteException rex) {
                                            rex.printStackTrace();
                                        }
                                        catch (Exception exc) {
                                            this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                            --i;
                                        }
                                        ++i;
                                    }
                                    break block57;
                                }
                                if (!type.equals("global.custom.service.properties.changed")) break block62;
                                int i = 0;
                                while (i < this.listeners.size()) {
                                    try {
                                        ((ServiceEventListener)this.listeners.elementAt(i)).globalCustomServicePropertiesChanged(clusterId, serviceName, note.getGlobalCustomProperties());
                                    }
                                    catch (P4RuntimeException prex) {
                                        this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                        --i;
                                    }
                                    catch (RemoteException rex) {
                                        rex.printStackTrace();
                                    }
                                    catch (Exception exc) {
                                        this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                        --i;
                                    }
                                    ++i;
                                }
                                break block57;
                            }
                            if (!type.equals("global.custom.service.properties.deleted")) break block63;
                            int i = 0;
                            while (i < this.listeners.size()) {
                                try {
                                    ((ServiceEventListener)this.listeners.elementAt(i)).globalCustomServicePropertiesDeleted(clusterId, serviceName, note.getGlobalCustomDeletedKeys());
                                }
                                catch (P4RuntimeException prex) {
                                    this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                    --i;
                                }
                                catch (RemoteException rex) {
                                    rex.printStackTrace();
                                }
                                catch (Exception exc) {
                                    this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                    --i;
                                }
                                ++i;
                            }
                            break block57;
                        }
                        if (!type.equals("local.custom.service.properties.changed")) break block64;
                        int i = 0;
                        while (i < this.listeners.size()) {
                            try {
                                ((ServiceEventListener)this.listeners.elementAt(i)).localCustomServicePropertiesChanged(clusterId, serviceName, note.getLocalCustomProperties());
                            }
                            catch (P4RuntimeException prex) {
                                this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                --i;
                            }
                            catch (RemoteException rex) {
                                rex.printStackTrace();
                            }
                            catch (Exception exc) {
                                this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                                --i;
                            }
                            ++i;
                        }
                        break block57;
                    }
                    if (!type.equals("local.custom.service.properties.deleted")) break block65;
                    int i = 0;
                    while (i < this.listeners.size()) {
                        try {
                            ((ServiceEventListener)this.listeners.elementAt(i)).localCustomServicePropertiesDeleted(clusterId, serviceName, note.getLocalCustomDeletedKeys());
                        }
                        catch (P4RuntimeException prex) {
                            this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                            --i;
                        }
                        catch (RemoteException rex) {
                            rex.printStackTrace();
                        }
                        catch (Exception exc) {
                            this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                            --i;
                        }
                        ++i;
                    }
                    break block57;
                }
                if (!type.equals("local.default.service.properties.changed")) break block66;
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        ((ServiceEventListener)this.listeners.elementAt(i)).localDefaultServicePropertiesChanged(clusterId, serviceName, note.getLocalDefaultProperties());
                    }
                    catch (P4RuntimeException prex) {
                        this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    catch (RemoteException rex) {
                        rex.printStackTrace();
                    }
                    catch (Exception exc) {
                        this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    ++i;
                }
                break block57;
            }
            if (!type.equals("runtime.service.properties.changed")) break block57;
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((ServiceEventListener)this.listeners.elementAt(i)).runtimeServicePropertiesChanged(clusterId, serviceName, note.getRuntimeProperties());
                }
                catch (P4RuntimeException prex) {
                    this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                    --i;
                }
                catch (RemoteException rex) {
                    rex.printStackTrace();
                }
                catch (Exception exc) {
                    this.unregisterServiceEventListener((ServiceEventListener)this.listeners.elementAt(i));
                    --i;
                }
                ++i;
            }
        }
    }

    private void registerAsIntermediator() {
        this.isIntermediator = true;
    }

    private void unregisterAsIntermediator() {
        this.isIntermediator = false;
        Object[] clusterNodeRepresentatives = AdminAdapterFrame.getAllClusterRepresentatives();
        int i = 0;
        while (i < clusterNodeRepresentatives.length) {
            ObjectName clusterNodeRepresentative = (ObjectName)clusterNodeRepresentatives[i];
            try {
                this.jmxconn.removeNotificationListener(clusterNodeRepresentative, this);
            }
            catch (Exception exc) {
                Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$impl$ServiceTattler == null ? ServiceTattler.class$("com.sap.engine.services.adminadapter.impl.ServiceTattler") : class$com$sap$engine$services$adminadapter$impl$ServiceTattler)).catching((Throwable)exc);
            }
            ++i;
        }
    }

    private Object[] getAllServices() {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)"SAP_J2EEServicePerNode", (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
            return new ObjectName[0];
        }
        return this.jmxconn.queryNames(pattern, null).toArray();
    }

    public void addedMBeanTreeNode(MBeanTreeNode node) throws RemoteException {
    }

    public void removedMBeanTreeNode(MBeanTreeNode node) throws RemoteException {
    }

    public void newClusterNodeAvailable(ObjectName clusterNodeRepresentative) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.size() > 0) {
                try {
                    this.jmxconn.addNotificationListener(clusterNodeRepresentative, this, null, null);
                }
                catch (Exception exc) {
                    Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$impl$ServiceTattler == null ? (class$com$sap$engine$services$adminadapter$impl$ServiceTattler = ServiceTattler.class$("com.sap.engine.services.adminadapter.impl.ServiceTattler")) : class$com$sap$engine$services$adminadapter$impl$ServiceTattler));
                    location.logT(500, "Couldn't register tattler as an intermediator to MBean : " + clusterNodeRepresentative);
                    LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"newClusterNodeAvailable(ObjectName clusterNodeRepresentative)", (String)"Unable to register for administrative events on remote node", (Throwable)exc);
                }
            }
        }
    }

    public void connectTo(ObjectName clusterNodeRepresentative) {
        if (this.isIntermediator) {
            try {
                this.jmxconn.addNotificationListener(clusterNodeRepresentative, this, null, null);
            }
            catch (Exception exc) {
                Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$impl$ServiceTattler == null ? (class$com$sap$engine$services$adminadapter$impl$ServiceTattler = ServiceTattler.class$("com.sap.engine.services.adminadapter.impl.ServiceTattler")) : class$com$sap$engine$services$adminadapter$impl$ServiceTattler));
                location.logT(500, "Couldn't register service tattler as an intermediator to MBean : " + clusterNodeRepresentative);
                LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"connectTo(ObjectName clusterNodeRepresentative)", (String)"Unable to register for administrative events on remote node", (Throwable)exc);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

