/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.adminadapter.descriptor.ComponentDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceDescriptor;
import com.sap.engine.services.adminadapter.impl.ServiceTattler;
import com.sap.engine.services.adminadapter.impl.Util;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.engine.services.adminadapter.interfaces.ServiceAdministrator;
import com.sap.engine.services.adminadapter.interfaces.ServiceEventListener;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.rmi.PortableRemoteObject;

public class ServiceAdministratorImpl
extends PortableRemoteObject
implements ServiceAdministrator {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$impl$ServiceAdministratorImpl == null ? (class$com$sap$engine$services$adminadapter$impl$ServiceAdministratorImpl = ServiceAdministratorImpl.class$("com.sap.engine.services.adminadapter.impl.ServiceAdministratorImpl")) : class$com$sap$engine$services$adminadapter$impl$ServiceAdministratorImpl));
    private MBeanServer mBeanServer = null;
    private ServiceTattler tattler = null;
    private LoadContext loadContext = null;
    private ClusterMonitor clusterMonitor = null;
    private int currentClusterId = -1;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$impl$ServiceAdministratorImpl;

    public ServiceAdministratorImpl(MBeanServer mBeanServer, ApplicationServiceContext serviceContext, RemoteAdminInterface remoteAdminInterface) throws RemoteException {
        this.mBeanServer = mBeanServer;
        this.loadContext = serviceContext.getCoreContext().getLoadContext();
        this.clusterMonitor = serviceContext.getClusterContext().getClusterMonitor();
        this.currentClusterId = serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        this.tattler = new ServiceTattler(mBeanServer, remoteAdminInterface);
    }

    public ServiceTattler getTattler() {
        return this.tattler;
    }

    public void registerServiceEventListener(ServiceEventListener sel) throws RemoteException {
        this.tattler.registerServiceEventListener(sel);
    }

    public void unregisterServiceEventListener(ServiceEventListener sel) throws RemoteException {
        this.tattler.unregisterServiceEventListener(sel);
    }

    public void stopService(int clusterID, String serviceName) throws RemoteException {
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(standardServiceManagementObjectName, "stop", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not stop service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not stop service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public void startService(int clusterID, String serviceName) throws RemoteException {
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(standardServiceManagementObjectName, "start", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not start service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not start service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public boolean setServiceProperties(int clusterID, String serviceName, Properties sp) throws RemoteException {
        boolean result = false;
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            result = (Boolean)this.mBeanServer.invoke(standardServiceManagementObjectName, "setProperties", new Object[]{sp}, new String[]{"java.util.Properties"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not set properties for service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not set properties for service " + serviceName + " on cluster ID " + clusterID, e);
        }
        return result;
    }

    public Properties getServiceProperties(int clusterID, String serviceName) throws RemoteException {
        Properties properties = null;
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            properties = (Properties)this.mBeanServer.invoke(standardServiceManagementObjectName, "getProperties", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get properties for service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get properties for service " + serviceName + " on cluster ID " + clusterID, e);
        }
        return properties;
    }

    public boolean restoreDefaultLocalServiceProperties(int clusterID, String serviceName) throws RemoteException {
        boolean result = false;
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            result = (Boolean)this.mBeanServer.invoke(standardServiceManagementObjectName, "restoreDefaultLocalProperties", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not restore default local properties for service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not restore default local properties for service " + serviceName + " on cluster ID " + clusterID, e);
        }
        return result;
    }

    public boolean setServiceProperty(int clusterID, String serviceName, String key, String value) throws RemoteException {
        boolean result = false;
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            result = (Boolean)this.mBeanServer.invoke(standardServiceManagementObjectName, "setProperty", new Object[]{key, value}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not set property " + key + " for service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not set property " + key + " for service " + serviceName + " on cluster ID " + clusterID, e);
        }
        return result;
    }

    public String getServiceProperty(int clusterID, String serviceName, String key) throws RemoteException {
        String serviceProperty = null;
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            serviceProperty = (String)this.mBeanServer.invoke(standardServiceManagementObjectName, "getProperty", new Object[]{key}, new String[]{"java.lang.String"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get property " + key + " for service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get property " + key + " for service " + serviceName + " on cluster ID " + clusterID, e);
        }
        return serviceProperty;
    }

    public ComponentDescriptor getDescriptor(int clusterID, String serviceName) throws RemoteException {
        ServiceDescriptor componentDescriptor = new ServiceDescriptor();
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        componentDescriptor.setClusterID(clusterID);
        try {
            AttributeList list = this.mBeanServer.getAttributes(standardServiceManagementObjectName, new String[]{"Name", "ProviderName", "DisplayName", "Description", "GroupName", "CommunicationFrameClassName", "ApplicationFrameClassName", "RuntimeControlClassName", "MajorVersion", "MinorVersion", "MicroVersion", "Core", "Status", "StartupState", "StartupMode", "References", "Jars"});
            int i = 0;
            while (i < list.size()) {
                Attribute attr = (Attribute)list.get(i);
                String attrName = attr.getName();
                if ("Name".equals(attrName)) {
                    componentDescriptor.setName((String)attr.getValue());
                } else if ("ProviderName".equals(attrName)) {
                    componentDescriptor.setProviderName((String)attr.getValue());
                } else if ("DisplayName".equals(attrName)) {
                    componentDescriptor.setDisplayName((String)attr.getValue());
                } else if ("Description".equals(attrName)) {
                    componentDescriptor.setDescription((String)attr.getValue());
                } else if ("GroupName".equals(attrName)) {
                    componentDescriptor.setGroupName((String)attr.getValue());
                } else if ("CommunicationFrameClassName".equals(attrName)) {
                    componentDescriptor.setCommunicationServiceFrameClassName((String)attr.getValue());
                } else if ("ApplicationFrameClassName".equals(attrName)) {
                    componentDescriptor.setApplicationServiceFrameClassName((String)attr.getValue());
                } else if ("RuntimeControlClassName".equals(attrName)) {
                    componentDescriptor.setRuntimeControlClassName((String)attr.getValue());
                } else if ("MajorVersion".equals(attrName)) {
                    componentDescriptor.setMajorVersion((String)attr.getValue());
                } else if ("MinorVersion".equals(attrName)) {
                    componentDescriptor.setMinorVersion((String)attr.getValue());
                } else if ("MicroVersion".equals(attrName)) {
                    componentDescriptor.setMicroVersion((String)attr.getValue());
                } else if ("Core".equals(attrName)) {
                    componentDescriptor.setCore((Boolean)attr.getValue());
                } else if ("Status".equals(attrName)) {
                    componentDescriptor.setStatus((Byte)attr.getValue());
                } else if ("StartupState".equals(attrName)) {
                    componentDescriptor.setStartupState((Byte)attr.getValue());
                } else if ("StartupMode".equals(attrName)) {
                    componentDescriptor.setStartupMode((Byte)attr.getValue());
                } else if ("References".equals(attrName)) {
                    componentDescriptor.setReferences((String[][])attr.getValue());
                } else if ("Jars".equals(attrName)) {
                    componentDescriptor.setJars((String[])attr.getValue());
                } else {
                    LoggingHelper.SYS_SERVER.errorT(LOCATION, "getDescriptor(int,String)", "unexpected service attribute found " + attrName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RemoteException("Unable to get service descriptor", e);
        }
        return componentDescriptor;
    }

    public boolean changeDescriptor(int clusterID, String serviceName, ComponentDescriptor serviceDescriptor) throws RemoteException {
        return false;
    }

    public Class getRuntimeControlClass(int clusterId, String serviceName) throws RemoteException {
        String className = ((ServiceDescriptor)this.getDescriptor(clusterId, serviceName)).getRuntimeControlClassName();
        if (className != null) {
            try {
                return this.loadContext.getClassLoader("service:" + serviceName).loadClass(className);
            }
            catch (Exception exc) {
                return null;
            }
        }
        return null;
    }

    private ObjectName generateStandardServiceObjectName(int clusterId, String serviceName) {
        try {
            return ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)serviceName, (String)String.valueOf(clusterId), (String)"\"\"");
        }
        catch (MalformedObjectNameException exc) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"generateStandardServiceObjectName(int,String)", (String)("unable to create service standard mbean name" + serviceName), (Throwable)exc);
            return null;
        }
    }

    private ObjectName generateRuntimeServiceObjectName(int clusterId, String serviceName) {
        try {
            return ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)serviceName, (String)String.valueOf(clusterId), (String)"\"\"");
        }
        catch (MalformedObjectNameException exc) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"generateRuntimeServiceObjectName(int,String)", (String)("unable to create service runtime mbean name" + serviceName), (Throwable)exc);
            return null;
        }
    }

    public void newClusterNodeAvailable(ObjectName clusterNodeRepresentative) {
        this.tattler.newClusterNodeAvailable(clusterNodeRepresentative);
    }

    public Properties getGlobalDefaultProperties(String serviceName, byte clusterNodeType) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            return (Properties)this.mBeanServer.invoke(serviceObjectName, "getGlobalDefaultProperties", new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return null;
    }

    public Properties getGlobalCustomProperties(String serviceName, byte clusterNodeType) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            return (Properties)this.mBeanServer.invoke(serviceObjectName, "getGlobalCustomProperties", new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return null;
    }

    public void updateGlobalCustomProperties(String serviceName, Properties properties, byte clusterNodeType) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(serviceObjectName, "setGlobalCustomProperties", new Object[]{properties}, new String[]{"java.util.Properties"});
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not set global custom properties of service " + serviceName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
    }

    public void updateLocalCustomProperties(int clusterID, String serviceName, Properties properties) throws RemoteException {
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(standardServiceManagementObjectName, "setLocalCustomProperties", new Object[]{properties}, new String[]{"java.util.Properties"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not set local custom properties of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not set local custom properties of service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public void updateLocalDefaultProperties(int clusterID, String serviceName, Properties properties) throws RemoteException {
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(standardServiceManagementObjectName, "setLocalDefaultProperties", new Object[]{properties}, new String[]{"java.util.Properties"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not set local default properties of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not set local default properties of service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public Properties getLocalCustomProperties(int clusterID, String serviceName) throws RemoteException {
        Properties properties = null;
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            properties = (Properties)this.mBeanServer.invoke(standardServiceManagementObjectName, "getLocalCustomProperties", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get local custom properties of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get local custom properties of service " + serviceName + " on cluster ID " + clusterID, e);
        }
        return properties;
    }

    public Properties getLocalDefaultProperties(int clusterID, String serviceName) throws RemoteException {
        Properties properties = null;
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            properties = (Properties)this.mBeanServer.invoke(standardServiceManagementObjectName, "getLocalDefaultProperties", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get local default properties of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get local default properties of service " + serviceName + " on cluster ID " + clusterID, e);
        }
        return properties;
    }

    public void restoreGlobalProperties(String serviceName, String[] keys, byte clusterNodeType) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(serviceObjectName, "restoreGlobalProperties", new Object[]{keys}, new String[]{"[Ljava.lang.String;"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not restore global properties of service " + serviceName, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not restore global properties of service " + serviceName, e);
        }
    }

    public void restoreLocalProperties(int clusterID, String serviceName, String[] keys) throws RemoteException {
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(serviceObjectName, "restoreLocalProperties", new Object[]{keys}, new String[]{"[Ljava.lang.String;"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not restore local properties of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not restore local properties of service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public boolean notifyServiceOfPropertiesChange(int clusterID, String serviceName, Properties properties) throws RemoteException {
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            return (Boolean)this.mBeanServer.invoke(standardServiceManagementObjectName, "notifyServiceOfPropertiesChange", new Object[]{properties}, new String[]{"java.util.Properties"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not notify service " + serviceName + " on cluster ID " + clusterID + " for change of properties", e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not notify service " + serviceName + " on cluster ID " + clusterID + " for change of properties", e);
        }
    }

    public Set getLocalSecuredKeys(int clusterID, String serviceName) throws RemoteException {
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            return (Set)this.mBeanServer.invoke(serviceObjectName, "getLocalSecuredKeys", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get local secure properties' keys of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get local secure properties' keys of service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public Set getGlobalSecuredKeys(int clusterID, String serviceName) throws RemoteException {
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            return (Set)this.mBeanServer.invoke(serviceObjectName, "getGlobalSecuredKeys", new Object[0], new String[0]);
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get global secure properties' keys of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get global secure properties' keys of service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public void updateGlobalCustomProperties(String serviceName, Properties properties, byte clusterNodeType, Set securedKeys) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName serviceObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(serviceObjectName, "setGlobalCustomProperties", new Object[]{properties, securedKeys}, new String[]{"java.util.Properties", "java.util.Set"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not update global custom properties of service " + serviceName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not update global custom properties of service " + serviceName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not update global custom properties of service " + serviceName, re.getTargetException());
        }
    }

    public void updateLocalDefaultProperties(int clusterID, String serviceName, Properties properties, Set securedKeys) throws RemoteException {
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(standardServiceManagementObjectName, "setLocalDefaultProperties", new Object[]{properties, securedKeys}, new String[]{"java.util.Properties", "java.util.Set"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not update local default properties of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not update local default properties of service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    public void updateLocalCustomProperties(int clusterID, String serviceName, Properties properties, Set securedKeys) throws RemoteException {
        ObjectName standardServiceManagementObjectName = this.generateStandardServiceObjectName(clusterID, serviceName);
        try {
            this.mBeanServer.invoke(standardServiceManagementObjectName, "setLocalCustomProperties", new Object[]{properties, securedKeys}, new String[]{"java.util.Properties", "java.util.Set"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not update local custom properties of service " + serviceName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not update local custom properties of service " + serviceName + " on cluster ID " + clusterID, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

