/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.services.adminadapter.impl.ClusterAdministratorImpl;
import com.sap.engine.services.adminadapter.impl.ConvenienceEngineAdministratorImpl;
import com.sap.engine.services.adminadapter.impl.DefaultMBeanAdministratorImpl;
import com.sap.engine.services.adminadapter.impl.InterfaceAdministratorImpl;
import com.sap.engine.services.adminadapter.impl.KernelAdministratorImpl;
import com.sap.engine.services.adminadapter.impl.LibraryAdministratorImpl;
import com.sap.engine.services.adminadapter.impl.MBeanTreeNodeImpl;
import com.sap.engine.services.adminadapter.impl.ServiceAdministratorImpl;
import com.sap.engine.services.adminadapter.interfaces.ClusterAdministrator;
import com.sap.engine.services.adminadapter.interfaces.ConvenienceEngineAdministrator;
import com.sap.engine.services.adminadapter.interfaces.DefaultMBeanAdministrator;
import com.sap.engine.services.adminadapter.interfaces.InterfaceAdministrator;
import com.sap.engine.services.adminadapter.interfaces.KernelAdministrator;
import com.sap.engine.services.adminadapter.interfaces.LibraryAdministrator;
import com.sap.engine.services.adminadapter.interfaces.MBeanRegistrationEventListener;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.engine.services.adminadapter.interfaces.ServiceAdministrator;
import com.sap.engine.services.rmi_p4.P4RuntimeException;
import com.sap.jmx.ObjectNameFactory;
import com.sap.pj.jmx.mbeaninfo.AdditionalInfo;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.rmi.PortableRemoteObject;

public class RemoteAdminInterfaceImpl
extends PortableRemoteObject
implements RemoteAdminInterface,
NotificationListener {
    private DefaultMBeanAdministratorImpl defaultMBeanAdministrator = null;
    private ClusterAdministratorImpl clusterAdministrator = null;
    private KernelAdministratorImpl kernelAdministrator = null;
    private ServiceAdministratorImpl serviceAdministrator = null;
    private LibraryAdministratorImpl libraryAdministrator = null;
    private InterfaceAdministratorImpl interfaceAdministrator = null;
    private ConvenienceEngineAdministratorImpl convenienceEngineAdministrator = null;
    private Vector listeners = null;
    private MBeanServer mBeanServer = null;
    private ApplicationServiceContext serviceContext = null;
    private final ClassLoader adminLoader = (class$com$sap$engine$services$adminadapter$impl$RemoteAdminInterfaceImpl == null ? (class$com$sap$engine$services$adminadapter$impl$RemoteAdminInterfaceImpl = RemoteAdminInterfaceImpl.class$("com.sap.engine.services.adminadapter.impl.RemoteAdminInterfaceImpl")) : class$com$sap$engine$services$adminadapter$impl$RemoteAdminInterfaceImpl).getClassLoader();
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$impl$RemoteAdminInterfaceImpl;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative;

    public RemoteAdminInterfaceImpl(MBeanServer mBeanServer, ApplicationServiceContext serviceContext) throws RemoteException {
        this.mBeanServer = mBeanServer;
        this.serviceContext = serviceContext;
        this.listeners = new Vector();
        this.defaultMBeanAdministrator = new DefaultMBeanAdministratorImpl(mBeanServer);
        this.clusterAdministrator = new ClusterAdministratorImpl(mBeanServer);
        this.kernelAdministrator = new KernelAdministratorImpl(mBeanServer, this);
        this.serviceAdministrator = new ServiceAdministratorImpl(mBeanServer, serviceContext, this);
        this.libraryAdministrator = new LibraryAdministratorImpl(mBeanServer);
        this.interfaceAdministrator = new InterfaceAdministratorImpl(mBeanServer);
        this.convenienceEngineAdministrator = new ConvenienceEngineAdministratorImpl(this.clusterAdministrator, this.kernelAdministrator, this.serviceAdministrator, mBeanServer, serviceContext);
    }

    public DefaultMBeanAdministrator getDefaultMBeanAdministrator() throws RemoteException {
        return this.defaultMBeanAdministrator;
    }

    public ClusterAdministrator getClusterAdministrator() throws RemoteException {
        return this.clusterAdministrator;
    }

    public KernelAdministrator getKernelAdministrator() throws RemoteException {
        return this.kernelAdministrator;
    }

    public ServiceAdministrator getServiceAdministrator() throws RemoteException {
        return this.serviceAdministrator;
    }

    public LibraryAdministrator getLibraryAdministrator() throws RemoteException {
        return this.libraryAdministrator;
    }

    public InterfaceAdministrator getInterfaceAdministrator() throws RemoteException {
        return this.interfaceAdministrator;
    }

    public MBeanTreeNode getRootMBeanTreeNode() throws RemoteException {
        ObjectName pattern = null;
        try {
            pattern = new ObjectName(":j2eeType=SAP_J2EECluster,*");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Object[] result = this.mBeanServer.queryNames(pattern, null).toArray();
        ObjectName mbeanName = (ObjectName)result[0];
        AdditionalInfo info = null;
        try {
            info = (AdditionalInfo)this.mBeanServer.getMBeanInfo(mbeanName);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        String path = info.getProperty("admin.path");
        String displayName = info.getProperty("admin.displayName");
        return MBeanTreeNodeImpl.buildTree(this.mBeanServer, path, mbeanName, displayName, this.serviceContext.getCoreContext().getLoadContext());
    }

    public MBeanTreeNode getMBeanTreeNode(String path) throws RemoteException {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)"\"\"");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Object[] mbeans = this.mBeanServer.queryNames(pattern, null).toArray();
        int i = 0;
        while (i < mbeans.length) {
            String mbeanPath;
            ObjectName mbean = (ObjectName)mbeans[i];
            MBeanInfo info = null;
            try {
                info = this.mBeanServer.getMBeanInfo(mbean);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (info instanceof AdditionalInfo && (mbeanPath = ((AdditionalInfo)info).getProperty("admin.path")) != null && mbeanPath.equals(path)) {
                String displayName = ((AdditionalInfo)info).getProperty("admin.displayName");
                return MBeanTreeNodeImpl.buildTree(this.mBeanServer, path, mbean, displayName, this.serviceContext.getCoreContext().getLoadContext());
            }
            ++i;
        }
        return null;
    }

    public ConvenienceEngineAdministrator getConvenienceEngineAdministrator() throws RemoteException {
        return this.convenienceEngineAdministrator;
    }

    public void registerRegistrationEventListener(MBeanRegistrationEventListener listener) throws RemoteException {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.add(listener) && this.listeners.size() == 1) {
                this.registerIntermediator(this);
            }
        }
    }

    public void unregisterRegistrationEventListener(MBeanRegistrationEventListener listener) throws RemoteException {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.remove(listener) && this.listeners.size() == 0) {
                this.unregisterIntermediator(this);
            }
        }
    }

    private void registerIntermediator(NotificationListener listener) {
        try {
            this.mBeanServer.addNotificationListener(this.getMBeanServerDelegateName(), listener, null, null);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void unregisterIntermediator(NotificationListener listener) {
        try {
            this.mBeanServer.removeNotificationListener(this.getMBeanServerDelegateName(), listener, null, null);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void handleNotification(Notification notification, Object o) {
        if (notification.getType().equals("container.started")) {
            return;
        }
        MBeanServerNotification serverNote = (MBeanServerNotification)notification;
        ObjectName mbeanName = serverNote.getMBeanName();
        if (!this.isInCluster(mbeanName) || this.isRuntimeMBean(mbeanName) || this.isOnlyOfflineDeployable(mbeanName)) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.adminLoader);
        if (serverNote.getType().equals("JMX.mbean.registered")) {
            this.notifyAdded(mbeanName);
        } else {
            this.notifyRemoved(mbeanName);
        }
        Thread.currentThread().setContextClassLoader(loader);
    }

    public void ping() throws RemoteException {
    }

    private void notifyAdded(ObjectName mbeanName) {
        if (ObjectNameFactory.getJ2eeType((ObjectName)mbeanName).equals((class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative == null ? (class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative = RemoteAdminInterfaceImpl.class$("com.sap.engine.services.adminadapter.impl.ClusterNodeRepresentative")) : class$com$sap$engine$services$adminadapter$impl$ClusterNodeRepresentative).getName())) {
            this.kernelAdministrator.newClusterNodeAvailable(mbeanName);
            this.serviceAdministrator.newClusterNodeAvailable(mbeanName);
            String mbeanClusterId = ObjectNameFactory.getClusterNode((ObjectName)mbeanName);
            if (Integer.parseInt(mbeanClusterId) != this.serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId()) {
                this.elementAdded(mbeanClusterId);
            }
            return;
        }
        AdditionalInfo info = null;
        try {
            info = (AdditionalInfo)this.mBeanServer.getMBeanInfo(mbeanName);
        }
        catch (Exception exc) {
            return;
        }
        String path = info.getProperty("admin.path");
        if (path == null) {
            return;
        }
        String descriptiveName = info.getProperty("admin.displayName");
        if (path.startsWith("/Cluster")) {
            MBeanTreeNodeImpl treeNode = new MBeanTreeNodeImpl(path, null, mbeanName, null, descriptiveName, null);
            treeNode.buildUserObject(this.mBeanServer, this.serviceContext.getCoreContext().getLoadContext());
            Vector vector = this.listeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        ((MBeanRegistrationEventListener)this.listeners.elementAt(i)).addedMBeanTreeNode(treeNode);
                    }
                    catch (P4RuntimeException exc) {
                        try {
                            this.unregisterRegistrationEventListener((MBeanRegistrationEventListener)this.listeners.elementAt(i));
                            --i;
                        }
                        catch (Exception internalExc) {}
                    }
                    catch (RemoteException exc) {
                    }
                    catch (Exception exc) {
                        try {
                            this.unregisterRegistrationEventListener((MBeanRegistrationEventListener)this.listeners.elementAt(i));
                            --i;
                        }
                        catch (Exception internalExc) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void notifyRemoved(ObjectName mbeanName) {
        MBeanTreeNodeImpl treeNode = new MBeanTreeNodeImpl(null, null, mbeanName, null, null, null);
        Vector vector = this.listeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((MBeanRegistrationEventListener)this.listeners.elementAt(i)).removedMBeanTreeNode(treeNode);
                }
                catch (P4RuntimeException exc) {
                    try {
                        this.unregisterRegistrationEventListener((MBeanRegistrationEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    catch (Exception internalExc) {}
                }
                catch (RemoteException exc) {
                }
                catch (Exception exc) {
                    try {
                        this.unregisterRegistrationEventListener((MBeanRegistrationEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    catch (Exception internalExc) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    private boolean isInCluster(ObjectName mbeanName) {
        return mbeanName.getKeyProperty("SAP_J2EECluster") != null;
    }

    private boolean isRuntimeMBean(ObjectName mbeanName) {
        String j2eeType = ObjectNameFactory.getJ2eeType((ObjectName)mbeanName);
        return j2eeType != null && (j2eeType.equals("SAP_J2EEServiceRuntimePerNode") || j2eeType.equals("SAP_J2EEKernelRuntimePerNode"));
    }

    private boolean isOnlyOfflineDeployable(ObjectName mbeanName) {
        String j2eeType = ObjectNameFactory.getJ2eeType((ObjectName)mbeanName);
        return j2eeType != null && (j2eeType.equals("SAP_J2EECluster") || j2eeType.equals("SAP_J2EEClusterNode") || j2eeType.equals("SAP_J2EEKernelPerNode") || j2eeType.equals("SAP_J2EEServicePerNode") || j2eeType.equals("SAP_J2EEInterfacePerNode"));
    }

    public ObjectName getMBeanServerDelegateName() {
        try {
            return new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public void elementDied(int clusterId) {
        try {
            this.notifyRemoved(ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(clusterId), (String)"\"\""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void elementAdded(String clusterId) {
        String rootPath = "/Cluster/" + clusterId;
        ObjectName rootMBean = null;
        try {
            rootMBean = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)clusterId, (String)"\"\"");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        MBeanTreeNode treeNode = null;
        try {
            treeNode = this.convenienceEngineAdministrator.getClusterNodeSubTree(rootPath, rootMBean);
        }
        catch (RemoteException exc) {
            // empty catch block
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((MBeanRegistrationEventListener)this.listeners.elementAt(i)).addedMBeanTreeNode(treeNode);
                }
                catch (P4RuntimeException exc) {
                    try {
                        this.unregisterRegistrationEventListener((MBeanRegistrationEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    catch (Exception internalExc) {}
                }
                catch (RemoteException exc) {
                }
                catch (Exception exc) {
                    try {
                        this.unregisterRegistrationEventListener((MBeanRegistrationEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    catch (Exception internalExc) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

