/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.services.adminadapter.exception.AdminException;
import com.sap.engine.services.adminadapter.interfaces.ManagementInterfaceProxyFactory;
import com.sap.jmx.ObjectNameFactory;
import com.sap.jmx.remote.JmxConnectionFactory;
import com.sap.jmx.remote.JmxConnector;
import java.io.IOException;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;

public class ManagementInterfaceProxyFactoryImpl
implements ManagementInterfaceProxyFactory {
    private MBeanServerConnection mbsc;
    private JmxConnector cc;

    public ManagementInterfaceProxyFactoryImpl(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public ManagementInterfaceProxyFactoryImpl(Hashtable jndiCtxEnv) throws IOException {
        Hashtable env = jndiCtxEnv == null ? new Hashtable() : new Hashtable(jndiCtxEnv);
        this.cc = JmxConnectionFactory.getConnector((String)"service:jmx:com.sap.engine.services.jmx.connector.p4:", env);
    }

    public ManagementInterface generateCurrentManagementInterfaceProxy(String serviceName, Class managementInterface) throws AdminException {
        return this.generateManagementInterfaceProxy(null, serviceName, managementInterface, null);
    }

    public ManagementInterface generateManagementInterfaceProxy(int clusterID, String serviceName, Class managementInterface) throws AdminException {
        return this.generateManagementInterfaceProxy(String.valueOf(clusterID), serviceName, managementInterface, null);
    }

    private ManagementInterface generateManagementInterfaceProxy(String clusterID, String serviceName, Class managementInterface, ClassLoader loader) throws AdminException {
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)serviceName, (String)clusterID, null);
            MBeanServerConnection conn = this.getMbsc(loader);
            if (managementInterface == null) {
                String intfName = (String)conn.invoke(objectName, "_getMBeanInterface", new Object[0], new String[0]);
                managementInterface = loader != null ? Class.forName(intfName, true, loader) : Class.forName(intfName);
            }
            return (ManagementInterface)MBeanServerInvocationHandler.newProxyInstance(conn, objectName, managementInterface, false);
        }
        catch (Throwable e) {
            throw new AdminException(e);
        }
    }

    private MBeanServerConnection getMbsc(ClassLoader loader) throws IOException {
        if (this.cc != null) {
            return this.cc.getMBeanServerConnection(loader);
        }
        return this.mbsc;
    }

    public ManagementInterface generateCurrentManagementInterfaceProxy(String serviceName, ClassLoader loader) throws AdminException {
        return this.generateManagementInterfaceProxy(null, serviceName, null, loader);
    }

    public ManagementInterface generateCurrentManagementInterfaceProxy(String serviceName) throws AdminException {
        return this.generateManagementInterfaceProxy(null, serviceName, null, null);
    }

    public ManagementInterface generateManagementInterfaceProxy(int clusterID, String serviceName, ClassLoader loader) throws AdminException {
        return this.generateManagementInterfaceProxy(String.valueOf(clusterID), serviceName, null, loader);
    }

    public ManagementInterface generateManagementInterfaceProxy(int clusterID, String serviceName) throws AdminException {
        return this.generateManagementInterfaceProxy(String.valueOf(clusterID), serviceName, null, null);
    }
}

