/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.monitor.CoreMonitor;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.services.adminadapter.AdminAdapterFrame;
import com.sap.engine.services.adminadapter.descriptor.ClusterDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ClusterElementNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ComponentDescriptor;
import com.sap.engine.services.adminadapter.descriptor.MBeanNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertySheet;
import com.sap.engine.services.adminadapter.gui.GlobalPropertySheet;
import com.sap.engine.services.adminadapter.impl.Util;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.jmx.ObjectNameFactory;
import com.sap.pj.jmx.mbeaninfo.AdditionalInfo;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;

public class MBeanTreeNodeImpl
implements MBeanTreeNode,
Comparable {
    public static final long serialVersionUID = -3339678659867100300L;
    public static final String ROOT_PATH = "/Cluster";
    public static final String ROOT_DISPLAY_NAME = AdminAdapterFrame.getClusterName();
    protected String path = null;
    protected byte type = (byte)-1;
    protected Vector successors = null;
    protected MBeanTreeNodeImpl parent = null;
    protected MBeanTreeNodeImpl root = null;
    protected ObjectName objectName = null;
    protected String descriptiveName = null;
    protected String manipulationName = null;
    protected Object userObject = null;
    protected HashMapObjectObject nodes = null;
    protected HashMapObjectObject objectNameToTreeNodeMap = null;

    public MBeanTreeNodeImpl(String path, MBeanTreeNode root, ObjectName objectName, String manipulationName, String descriptiveName, Object userObject) {
        this.type = objectName == null ? (byte)6 : MBeanTreeNodeImpl.getMbeanTreeNodeType(objectName);
        this.path = path;
        this.root = (MBeanTreeNodeImpl)root;
        this.objectName = objectName;
        this.manipulationName = manipulationName == null && objectName != null ? ObjectNameFactory.getName((ObjectName)objectName) : manipulationName;
        this.descriptiveName = descriptiveName == null && path != null ? MBeanTreeNodeImpl.getDescriptiveName(path) : descriptiveName;
        this.userObject = userObject;
        this.successors = new Vector();
    }

    public MBeanTreeNodeImpl(String path, ObjectName objectName, String manipulationName, String descriptiveName, Object userObject) {
        this(path, null, objectName, manipulationName, descriptiveName, userObject);
        this.root = this;
        this.nodes = new HashMapObjectObject();
        this.objectNameToTreeNodeMap = new HashMapObjectObject();
    }

    public String getPath() {
        return this.path;
    }

    public byte getType() {
        return this.type;
    }

    public Vector getSuccessors() {
        return this.successors;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    public String getManipulationName() {
        return this.manipulationName;
    }

    public MBeanTreeNode addInSubTree(MBeanTreeNode node) {
        String wholePath = node.getPath();
        if (wholePath.equals(this.path)) {
            if (this.objectName != null) {
                this.root.objectNameToTreeNodeMap.remove((Object)this.objectName);
            }
            this.setType(node.getType());
            this.setObjectName(node.getObjectName());
            this.setDescriptiveName(node.getDescriptiveName());
            this.setUserObject(node.getUserObject());
            this.root.objectNameToTreeNodeMap.put((Object)this.objectName, (Object)this);
            if (((MBeanTreeNodeImpl)node).nodes != null) {
                this.successors.removeAllElements();
                Vector nodeSuccessors = node.getSuccessors();
                int i = 0;
                while (i < nodeSuccessors.size()) {
                    MBeanTreeNodeImpl nodeSuccessor = (MBeanTreeNodeImpl)nodeSuccessors.elementAt(i);
                    nodeSuccessor.setParent(this);
                    this.addSuccessor(nodeSuccessor);
                    ++i;
                }
                MBeanTreeNodeImpl.addMapTo(((MBeanTreeNodeImpl)node).nodes, this.root.nodes);
                MBeanTreeNodeImpl.addMapTo(((MBeanTreeNodeImpl)node).objectNameToTreeNodeMap, this.root.objectNameToTreeNodeMap);
            }
            return this;
        }
        if (wholePath.startsWith(this.path)) {
            MBeanTreeNodeImpl actualTreeNode = this.root.buildChainOfNodes(this.path, wholePath.substring(this.path.length()), this, node.getObjectName(), node.getDescriptiveName(), null, null, node.getUserObject());
            if (((MBeanTreeNodeImpl)node).nodes != null) {
                actualTreeNode.getSuccessors().removeAllElements();
                Vector nodeSuccessors = node.getSuccessors();
                int i = 0;
                while (i < nodeSuccessors.size()) {
                    MBeanTreeNodeImpl nodeSuccessor = (MBeanTreeNodeImpl)nodeSuccessors.elementAt(i);
                    nodeSuccessor.setParent(actualTreeNode);
                    actualTreeNode.addSuccessor(nodeSuccessor);
                    ++i;
                }
                MBeanTreeNodeImpl.addMapTo(((MBeanTreeNodeImpl)node).nodes, actualTreeNode.root.nodes);
                MBeanTreeNodeImpl.addMapTo(((MBeanTreeNodeImpl)node).objectNameToTreeNodeMap, actualTreeNode.root.objectNameToTreeNodeMap);
            }
            return actualTreeNode;
        }
        return null;
    }

    public MBeanTreeNode removeFromSubTree(MBeanTreeNode node) {
        ObjectName mbean = node.getObjectName();
        if (mbean == null) {
            return null;
        }
        MBeanTreeNodeImpl originalNode = (MBeanTreeNodeImpl)this.root.objectNameToTreeNodeMap.get((Object)mbean);
        if (originalNode == null) {
            return null;
        }
        String originalPath = originalNode.getPath();
        if (!originalPath.startsWith(this.path)) {
            return null;
        }
        this.root.nodes.remove((Object)originalPath);
        this.root.objectNameToTreeNodeMap.remove((Object)mbean);
        MBeanTreeNodeImpl originalParent = (MBeanTreeNodeImpl)originalNode.getParent();
        if (originalParent != null) {
            originalParent.removeSuccessor(originalNode);
        }
        MBeanTreeNode parent = originalNode.getParent();
        originalNode.setParent(null);
        return parent;
    }

    public MBeanTreeNode getParent() {
        return this.parent;
    }

    public MBeanTreeNode getRoot() {
        return this.root;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void buildUserObject(MBeanServer jmxconn, LoadContext loadContext) {
        try {
            switch (this.type) {
                case 1: {
                    Properties nodeInfo = (Properties)jmxconn.invoke(this.objectName, "getInfo", new Object[0], new String[0]);
                    ClusterElementNodeDescriptor userObject = new ClusterElementNodeDescriptor();
                    userObject.setName(nodeInfo.getProperty("Name"));
                    userObject.setType(nodeInfo.getProperty("Type"));
                    userObject.setKernelVersion(nodeInfo.getProperty("KernelVersion"));
                    userObject.setId(nodeInfo.getProperty("ID"));
                    userObject.setHost(nodeInfo.getProperty("Host"));
                    userObject.setHostName(nodeInfo.getProperty("HostName"));
                    userObject.setDebuggable(nodeInfo.getProperty("Debuggable").equals("Yes"));
                    userObject.setDebugMode(nodeInfo.getProperty("DebugMode").equals("On"));
                    this.userObject = userObject;
                    break;
                }
                case 3: {
                    String key;
                    ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
                    serviceDescriptor.setClusterID(Integer.parseInt(this.objectName.getKeyProperty("SAP_J2EEClusterNode")));
                    AttributeList list = jmxconn.getAttributes(this.objectName, new String[]{"Name", "ProviderName", "DisplayName", "RuntimeControlClassName", "MajorVersion", "MinorVersion", "MicroVersion", "Core", "Status", "StartupMode", "References", "Jars"});
                    int i = 0;
                    while (i < list.size()) {
                        Attribute attr = (Attribute)list.get(i);
                        String attrName = attr.getName();
                        if ("Name".equals(attrName)) {
                            serviceDescriptor.setName((String)attr.getValue());
                        } else if ("ProviderName".equals(attrName)) {
                            serviceDescriptor.setProviderName((String)attr.getValue());
                        } else if ("DisplayName".equals(attrName)) {
                            serviceDescriptor.setDisplayName((String)attr.getValue());
                        } else if ("RuntimeControlClassName".equals(attrName)) {
                            serviceDescriptor.setRuntimeControlClassName((String)attr.getValue());
                        } else if ("MajorVersion".equals(attrName)) {
                            serviceDescriptor.setMajorVersion((String)attr.getValue());
                        } else if ("MinorVersion".equals(attrName)) {
                            serviceDescriptor.setMinorVersion((String)attr.getValue());
                        } else if ("MicroVersion".equals(attrName)) {
                            serviceDescriptor.setMicroVersion((String)attr.getValue());
                        } else if ("Core".equals(attrName)) {
                            serviceDescriptor.setCore((Boolean)attr.getValue());
                        } else if ("StartupMode".equals(attrName)) {
                            serviceDescriptor.setStartupMode((Byte)attr.getValue());
                        } else if ("Status".equals(attrName)) {
                            serviceDescriptor.setStatus((Byte)attr.getValue());
                        } else if ("References".equals(attrName)) {
                            serviceDescriptor.setReferences((String[][])attr.getValue());
                        } else if ("Jars".equals(attrName)) {
                            serviceDescriptor.setJars((String[])attr.getValue());
                        }
                        ++i;
                    }
                    Properties localDefaultProperties = (Properties)jmxconn.invoke(this.objectName, "getLocalDefaultProperties", new Object[0], new String[0]);
                    Properties localCustomProperties = (Properties)jmxconn.invoke(this.objectName, "getLocalCustomProperties", new Object[0], new String[0]);
                    Properties runtimeProperties = (Properties)jmxconn.invoke(this.objectName, "getProperties", new Object[0], new String[0]);
                    Set securedKeys = (Set)jmxconn.invoke(this.objectName, "getLocalSecuredKeys", new Object[0], new String[0]);
                    Set localDefaultPropertiesKeys = ((Hashtable)localDefaultProperties).keySet();
                    Set localCustomPropertiesKeys = ((Hashtable)localCustomProperties).keySet();
                    TreeSet keys = new TreeSet();
                    keys.addAll(localDefaultPropertiesKeys);
                    keys.addAll(localCustomPropertiesKeys);
                    TreeMap<String, ExtendedPropertySheet> propertySheets = new TreeMap<String, ExtendedPropertySheet>();
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        key = (String)iterator.next();
                        ExtendedPropertySheet propertySheet = !securedKeys.contains(key) ? new ExtendedPropertySheet(null, null, localDefaultProperties.getProperty(key), localCustomProperties.getProperty(key), false) : new ExtendedPropertySheet(null, null, null, null, true);
                        propertySheets.put(key, propertySheet);
                    }
                    iterator = securedKeys.iterator();
                    while (iterator.hasNext()) {
                        key = (String)iterator.next();
                        ((Hashtable)runtimeProperties).remove(key);
                    }
                    ServiceNodeDescriptor userObject = new ServiceNodeDescriptor(serviceDescriptor, propertySheets);
                    String className = serviceDescriptor.getRuntimeControlClassName();
                    Class<?> runtimeControlClass = null;
                    if (className != null) {
                        try {
                            runtimeControlClass = loadContext.getClassLoader("service:" + this.manipulationName).loadClass(className);
                        }
                        catch (Exception exc) {
                            Location.getLocation(this.getClass()).logT(400, "Couldn't load the runtime control class for service : " + this.manipulationName + ". The exception is : " + exc.getMessage());
                        }
                        catch (NoClassDefFoundError error) {
                            Location.getLocation(this.getClass()).logT(400, "Couldn't load the runtime control class for service : " + this.manipulationName + "because of NoClassDefFoundError : " + error.getMessage());
                        }
                    }
                    userObject.setRuntimeControlClass(this.manipulationName, runtimeControlClass);
                    userObject.setRuntimeProperties(runtimeProperties);
                    this.userObject = userObject;
                    break;
                }
                case 2: {
                    ManagerNodeDescriptor managerNodeDescriptor = null;
                    int clusterId = Integer.parseInt(this.objectName.getKeyProperty("SAP_J2EEClusterNode"));
                    String[] managerNames = (String[])jmxconn.invoke(this.objectName, "getAllManagers", new Object[0], new String[0]);
                    Vector userObject = new Vector(managerNames.length);
                    int i = 0;
                    while (i < managerNames.length) {
                        String key;
                        Properties localDefaultProperties = (Properties)jmxconn.invoke(this.objectName, "getLocalDefaultProperties", new Object[]{managerNames[i]}, new String[]{"java.lang.String"});
                        Properties localCustomProperties = (Properties)jmxconn.invoke(this.objectName, "getLocalCustomProperties", new Object[]{managerNames[i]}, new String[]{"java.lang.String"});
                        Properties runtimeProperties = (Properties)jmxconn.invoke(this.objectName, "getManagerProperties", new Object[]{managerNames[i]}, new String[]{"java.lang.String"});
                        Set securedKeys = (Set)jmxconn.invoke(this.objectName, "getLocalSecuredKeys", new Object[]{managerNames[i]}, new String[]{"java.lang.String"});
                        Set localDefaultPropertiesKeys = ((Hashtable)localDefaultProperties).keySet();
                        Set localCustomPropertiesKeys = ((Hashtable)localCustomProperties).keySet();
                        TreeSet keys = new TreeSet();
                        keys.addAll(localDefaultPropertiesKeys);
                        keys.addAll(localCustomPropertiesKeys);
                        TreeMap<String, ExtendedPropertySheet> propertySheets = new TreeMap<String, ExtendedPropertySheet>();
                        Iterator iterator = keys.iterator();
                        while (iterator.hasNext()) {
                            key = (String)iterator.next();
                            ExtendedPropertySheet propertySheet = !securedKeys.contains(key) ? new ExtendedPropertySheet(null, null, localDefaultProperties.getProperty(key), localCustomProperties.getProperty(key), false) : new ExtendedPropertySheet(null, null, null, null, true);
                            propertySheets.put(key, propertySheet);
                        }
                        iterator = securedKeys.iterator();
                        while (iterator.hasNext()) {
                            key = (String)iterator.next();
                            ((Hashtable)runtimeProperties).remove(key);
                        }
                        managerNodeDescriptor = new ManagerNodeDescriptor(managerNames[i], clusterId, propertySheets);
                        managerNodeDescriptor.setRuntimeProperties(runtimeProperties);
                        this.addSortedKernelChild(userObject, managerNodeDescriptor);
                        ++i;
                    }
                    this.userObject = userObject;
                    break;
                }
                case 4: {
                    this.userObject = this.buildComponentDescriptor(jmxconn);
                    break;
                }
                case 5: {
                    this.userObject = this.buildComponentDescriptor(jmxconn);
                    break;
                }
                case -1: {
                    this.userObject = this.buildMBeanNodeDescriptor(jmxconn);
                    break;
                }
                default: {
                    this.userObject = null;
                    break;
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.userObject = null;
        }
    }

    protected ComponentDescriptor buildComponentDescriptor(MBeanServer jmxconn) throws Exception {
        ServiceDescriptor componentDescriptor = new ServiceDescriptor();
        componentDescriptor.setClusterID(Integer.parseInt(this.objectName.getKeyProperty("SAP_J2EEClusterNode")));
        AttributeList list = jmxconn.getAttributes(this.objectName, new String[]{"Name", "ProviderName", "DisplayName", "Description", "MajorVersion", "MinorVersion", "MicroVersion", "References", "Jars"});
        int i = 0;
        while (i < list.size()) {
            Attribute attr = (Attribute)list.get(i);
            String attrName = attr.getName();
            if ("Name".equals(attrName)) {
                componentDescriptor.setName((String)attr.getValue());
            } else if ("ProviderName".equals(attrName)) {
                componentDescriptor.setProviderName((String)attr.getValue());
            } else if ("DisplayName".equals(attrName)) {
                componentDescriptor.setDisplayName((String)attr.getValue());
            } else if ("Description".equals(attrName)) {
                componentDescriptor.setDescription((String)attr.getValue());
            } else if ("MajorVersion".equals(attrName)) {
                componentDescriptor.setMajorVersion((String)attr.getValue());
            } else if ("MinorVersion".equals(attrName)) {
                componentDescriptor.setMinorVersion((String)attr.getValue());
            } else if ("MicroVersion".equals(attrName)) {
                componentDescriptor.setMicroVersion((String)attr.getValue());
            } else if ("References".equals(attrName)) {
                componentDescriptor.setReferences((String[][])attr.getValue());
            } else if ("Jars".equals(attrName)) {
                componentDescriptor.setJars((String[])attr.getValue());
            }
            ++i;
        }
        return componentDescriptor;
    }

    protected MBeanNodeDescriptor buildMBeanNodeDescriptor(MBeanServer jmxconn) {
        MBeanNodeDescriptor mBeanNodeDescriptor = null;
        try {
            MBeanInfo mBeanInfo = jmxconn.getMBeanInfo(this.objectName);
            HashMap<MBeanAttributeInfo, Object> attributes = new HashMap<MBeanAttributeInfo, Object>();
            MBeanAttributeInfo[] attributesInfo = mBeanInfo.getAttributes();
            int i = 0;
            while (i < attributesInfo.length) {
                Object attributeValue = jmxconn.getAttribute(this.objectName, attributesInfo[i].getName());
                attributes.put(attributesInfo[i], attributeValue);
                ++i;
            }
            mBeanNodeDescriptor = new MBeanNodeDescriptor(mBeanInfo, attributes, null);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (AttributeNotFoundException ae) {
            ae.printStackTrace();
        }
        return mBeanNodeDescriptor;
    }

    protected void expandAsRoot(MBeanServer jmxconn, ObjectName objectNamePattern, LoadContext loadContext) {
        Object[] mbeans = jmxconn.queryNames(objectNamePattern, null).toArray();
        int i = 0;
        while (i < mbeans.length) {
            ObjectName mbeanName = (ObjectName)mbeans[i];
            if (!mbeanName.equals(this.objectName)) {
                String subpath = null;
                String displayName = null;
                try {
                    String mbeanPath;
                    MBeanInfo info = null;
                    info = jmxconn.getMBeanInfo(mbeanName);
                    if (info instanceof AdditionalInfo && (mbeanPath = ((AdditionalInfo)info).getProperty("admin.path")) != null && mbeanPath.startsWith(this.path)) {
                        subpath = mbeanPath.substring(this.path.length());
                        displayName = ((AdditionalInfo)info).getProperty("admin.displayName");
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                if (subpath != null && !subpath.equals("")) {
                    this.buildChainOfNodes(this.path, subpath, this, mbeanName, displayName, jmxconn, loadContext, null);
                }
            }
            ++i;
        }
    }

    protected void oneLevelExpandAsClusterRoot(MBeanServer jmxconn, ClusterMonitor clusterMonitor, CoreMonitor coreMonitor) {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)"SAP_J2EEClusterNode", (String)"\"\"");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Set<ObjectName> clusterNodeMBeans = jmxconn.queryNames(pattern, null);
        Iterator<ObjectName> elements = clusterNodeMBeans.iterator();
        while (elements.hasNext()) {
            ObjectName clusterNodeMBean = elements.next();
            String clusterIdAsString = ObjectNameFactory.getName((ObjectName)clusterNodeMBean);
            int clusterId = Integer.parseInt(clusterIdAsString);
            ClusterElement clusterElement = clusterMonitor.getParticipant(clusterId);
            if (clusterElement == null) continue;
            String clusterNodePath = "/Cluster/" + clusterIdAsString;
            MBeanTreeNodeImpl clusterNode = new MBeanTreeNodeImpl(clusterNodePath, this, clusterNodeMBean, null, clusterElement.getName(), null);
            boolean isDebuggable = (clusterElement.getModifiers() & 2) == 2;
            boolean isDebugging = clusterElement.getState() == 7;
            ClusterElementNodeDescriptor nodeDescriptor = new ClusterElementNodeDescriptor();
            nodeDescriptor.setName(clusterElement.getName());
            nodeDescriptor.setType(clusterElement.getType() == 2 ? "Server" : "Dispatcher");
            nodeDescriptor.setKernelVersion(coreMonitor.getCoreVersion());
            nodeDescriptor.setId(clusterIdAsString);
            nodeDescriptor.setHost(clusterElement.getAddress().getHostAddress());
            nodeDescriptor.setHostName(clusterElement.getAddress().getHostName());
            nodeDescriptor.setDebuggable(isDebuggable);
            nodeDescriptor.setDebugMode(isDebugging);
            clusterNode.setUserObject(nodeDescriptor);
            this.nodes.put((Object)clusterNodePath, (Object)clusterNode);
            this.objectNameToTreeNodeMap.put((Object)clusterNodeMBean, (Object)clusterNode);
            clusterNode.setParent(this);
            this.addSuccessor(clusterNode);
        }
    }

    protected MBeanTreeNodeImpl buildChainOfNodes(String parentPath, String remainingPath, MBeanTreeNodeImpl parent, ObjectName lastNode, String displayName, MBeanServer jmxconn, LoadContext loadContext, Object userObject) {
        int index = remainingPath.indexOf(47, 1);
        if (index == -1) {
            String path = parentPath + remainingPath;
            MBeanTreeNodeImpl treeNode = (MBeanTreeNodeImpl)this.nodes.get((Object)path);
            if (treeNode == null) {
                treeNode = new MBeanTreeNodeImpl(path, this, lastNode, null, displayName, null);
                this.nodes.put((Object)path, (Object)treeNode);
            } else {
                if (treeNode.getObjectName() != null) {
                    this.objectNameToTreeNodeMap.remove((Object)treeNode.getObjectName());
                }
                treeNode.setType(MBeanTreeNodeImpl.getMbeanTreeNodeType(lastNode));
                treeNode.setObjectName(lastNode);
                treeNode.setDescriptiveName(displayName);
            }
            if (userObject == null && jmxconn != null) {
                treeNode.buildUserObject(jmxconn, loadContext);
            } else {
                treeNode.setUserObject(userObject);
            }
            this.objectNameToTreeNodeMap.put((Object)lastNode, (Object)treeNode);
            if (treeNode.getParent() == null) {
                treeNode.setParent(parent);
                parent.addSuccessor(treeNode);
            }
            return treeNode;
        }
        String token = remainingPath.substring(0, index);
        String path = parentPath + token;
        remainingPath = remainingPath.substring(token.length());
        MBeanTreeNodeImpl treeNode = (MBeanTreeNodeImpl)this.nodes.get((Object)path);
        if (treeNode == null) {
            String nodeDescriptiveName = token.substring(1);
            if (nodeDescriptiveName.startsWith("$GROUP_")) {
                treeNode = new MBeanTreeNodeImpl(path, this, null, null, nodeDescriptiveName.substring(7), null);
                treeNode.setParent(parent);
                parent.addSuccessor(treeNode);
            } else {
                treeNode = new MBeanTreeNodeImpl(path, this, null, null, null, null);
            }
            this.nodes.put((Object)path, (Object)treeNode);
        }
        return this.buildChainOfNodes(path, remainingPath, treeNode, lastNode, displayName, jmxconn, loadContext, userObject);
    }

    protected void addSuccessor(MBeanTreeNodeImpl node) {
        this.addSorted(node);
    }

    protected void removeSuccessor(MBeanTreeNodeImpl node) {
        this.successors.remove(node);
    }

    protected void setParent(MBeanTreeNodeImpl parent) {
        this.parent = parent;
    }

    protected void setType(byte type) {
        this.type = type;
    }

    protected void setDescriptiveName(String descriptiveName) {
        this.descriptiveName = descriptiveName;
    }

    protected void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
        if (this.manipulationName == null && objectName != null) {
            this.manipulationName = ObjectNameFactory.getName((ObjectName)objectName);
        }
    }

    protected static byte getMbeanTreeNodeType(ObjectName objectName) {
        String stringType = ObjectNameFactory.getJ2eeType((ObjectName)objectName);
        if (stringType == null) {
            return -1;
        }
        int type = -1;
        type = stringType.equals("SAP_J2EECluster") ? 0 : (stringType.equals("SAP_J2EEClusterNode") ? 1 : (stringType.equals("SAP_J2EEKernelPerNode") ? 2 : (stringType.equals("SAP_J2EEServicePerNode") ? 3 : (stringType.equals("SAP_J2EELibraryPerNode") ? 4 : (stringType.equals("SAP_J2EEInterfacePerNode") ? 5 : -1)))));
        return (byte)type;
    }

    protected static String getDescriptiveName(String path) {
        return path.substring(path.lastIndexOf(47) + 1, path.length());
    }

    protected static void addMapTo(HashMapObjectObject source, HashMapObjectObject destination) {
        RootIterator sourceKeys = source.keysIterator();
        RootIterator sourceValues = source.elementsIterator();
        while (!sourceKeys.isAtEnd()) {
            destination.put(sourceKeys.next(), sourceValues.next());
        }
    }

    public static MBeanTreeNode buildTree(MBeanServer jmxconn, String rootPath, ObjectName rootMbean, String rootDisplayName, LoadContext loadContext) {
        MBeanTreeNodeImpl root = new MBeanTreeNodeImpl(rootPath, rootMbean, null, rootDisplayName, null);
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)"\"\"");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        root.buildUserObject(jmxconn, loadContext);
        root.expandAsRoot(jmxconn, pattern, loadContext);
        return root;
    }

    public static MBeanTreeNode buildRootMBeanUserObject(MBeanServer jmxconn) {
        ClusterDescriptor clusterDescriptor = null;
        Map[][] globalProperties = null;
        try {
            ObjectName clusterManagementObjectName = ObjectNameFactory.getObjectName((String)"SAP_J2EECluster", (String)AdminAdapterFrame.getClusterName());
            globalProperties = (Map[][])jmxconn.invoke(clusterManagementObjectName, "getGlobalProperties", new Object[0], new String[0]);
            Map[] globalDispatcherProperties = globalProperties[0];
            Map[] globalServerProperties = globalProperties[1];
            Map globalDispatcherManagerPropertySheets = MBeanTreeNodeImpl.createGlobalPropertySheets(globalDispatcherProperties[0], globalDispatcherProperties[1], globalDispatcherProperties[2]);
            Map globalDispatcherServicePropertySheets = MBeanTreeNodeImpl.createGlobalPropertySheets(globalDispatcherProperties[3], globalDispatcherProperties[4], globalDispatcherProperties[5]);
            Map globalServerManagerPropertySheets = MBeanTreeNodeImpl.createGlobalPropertySheets(globalServerProperties[0], globalServerProperties[1], globalServerProperties[2]);
            Map globalServerServicePropertySheets = MBeanTreeNodeImpl.createGlobalPropertySheets(globalServerProperties[3], globalServerProperties[4], globalServerProperties[5]);
            clusterDescriptor = new ClusterDescriptor(globalDispatcherManagerPropertySheets, globalDispatcherServicePropertySheets, globalServerManagerPropertySheets, globalServerServicePropertySheets);
            return new MBeanTreeNodeImpl(null, null, null, null, clusterDescriptor);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return null;
    }

    public static MBeanTreeNode buildTopOfTree(MBeanServer jmxconn, ClusterMonitor clusterMonitor, CoreMonitor coreMonitor, ObjectName rootMBean) {
        MBeanTreeNodeImpl root = new MBeanTreeNodeImpl(ROOT_PATH, rootMBean, null, ROOT_DISPLAY_NAME, null);
        root.oneLevelExpandAsClusterRoot(jmxconn, clusterMonitor, coreMonitor);
        return root;
    }

    public static MBeanTreeNode buildClusterNodeSubTree(MBeanServer jmxconn, String rootPath, ObjectName rootMbean, String rootDisplayName, LoadContext loadContext) {
        MBeanTreeNodeImpl root = new MBeanTreeNodeImpl(rootPath, rootMbean, null, rootDisplayName, null);
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChildPerNode((String)root.getManipulationName(), (String)"\"\"");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        root.buildUserObject(jmxconn, loadContext);
        root.expandAsRoot(jmxconn, pattern, loadContext);
        return root;
    }

    private static Map getGlobalManagerPropertySheets(MBeanServer mBeanServer, String clusterID) {
        TreeMap resultMap = new TreeMap();
        ObjectName kernelObjectName = Util.generateKernelObjectName(clusterID);
        try {
            String[] managerNames = (String[])mBeanServer.invoke(kernelObjectName, "getAllManagers", new Object[0], new String[0]);
            int i = 0;
            while (i < managerNames.length) {
                Properties globalDefaultProperties = (Properties)mBeanServer.invoke(kernelObjectName, "getGlobalDefaultProperties", new Object[]{managerNames[i]}, new String[]{"java.lang.String"});
                Properties globalCustomProperties = (Properties)mBeanServer.invoke(kernelObjectName, "getGlobalCustomProperties", new Object[]{managerNames[i]}, new String[]{"java.lang.String"});
                Set globalSecuredKeys = (Set)mBeanServer.invoke(kernelObjectName, "getGlobalSecuredKeys", new Object[]{managerNames[i]}, new String[]{"java.lang.String"});
                TreeSet keys = new TreeSet();
                TreeMap<String, GlobalPropertySheet> propertySheets = new TreeMap<String, GlobalPropertySheet>();
                Set defaultKeys = ((Hashtable)globalDefaultProperties).keySet();
                Set customKeys = ((Hashtable)globalCustomProperties).keySet();
                keys.addAll(defaultKeys);
                keys.addAll(customKeys);
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    GlobalPropertySheet globalPropertySheet = !globalSecuredKeys.contains(key) ? new GlobalPropertySheet(globalDefaultProperties.getProperty(key), globalCustomProperties.getProperty(key), false) : new GlobalPropertySheet(null, null, true);
                    propertySheets.put(key, globalPropertySheet);
                }
                resultMap.put(managerNames[i], propertySheets);
                ++i;
            }
            return resultMap;
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        catch (RuntimeErrorException ree) {
            ree.printStackTrace();
        }
        return null;
    }

    private static Map getGlobalServicePropertySheets(MBeanServer mBeanServer, String clusterID) {
        TreeMap resultMap = new TreeMap();
        ObjectName servicesObjectNamePattern = null;
        try {
            servicesObjectNamePattern = ObjectNameFactory.getPatternForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)clusterID, (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        Set<ObjectName> set = mBeanServer.queryNames(servicesObjectNamePattern, null);
        Iterator<ObjectName> servicesIterator = set.iterator();
        try {
            while (servicesIterator.hasNext()) {
                ObjectName serviceObjectName = servicesIterator.next();
                String serviceDisplayName = (String)mBeanServer.invoke(serviceObjectName, "getDisplayName", new Object[0], new String[0]);
                Properties globalDefaultProperties = (Properties)mBeanServer.invoke(serviceObjectName, "getGlobalDefaultProperties", new Object[0], new String[0]);
                Properties globalCustomProperties = (Properties)mBeanServer.invoke(serviceObjectName, "getGlobalCustomProperties", new Object[0], new String[0]);
                Set globalSecuredKeys = (Set)mBeanServer.invoke(serviceObjectName, "getGlobalSecuredKeys", new Object[0], new String[0]);
                TreeSet keys = new TreeSet();
                TreeMap<String, GlobalPropertySheet> propertySheets = new TreeMap<String, GlobalPropertySheet>();
                Set defaultKeys = ((Hashtable)globalDefaultProperties).keySet();
                Set customKeys = ((Hashtable)globalCustomProperties).keySet();
                keys.addAll(defaultKeys);
                keys.addAll(customKeys);
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    GlobalPropertySheet globalPropertySheet = !globalSecuredKeys.contains(key) ? new GlobalPropertySheet(globalDefaultProperties.getProperty(key), globalCustomProperties.getProperty(key), false) : new GlobalPropertySheet(null, null, true);
                    propertySheets.put(key, globalPropertySheet);
                }
                resultMap.put(serviceDisplayName, propertySheets);
            }
            return resultMap;
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return null;
    }

    private static Map getGlobalServiceNames(MBeanServer mBeanServer, String clusterID) {
        TreeMap<String, String> resultMap = new TreeMap<String, String>();
        ObjectName servicesObjectNamePattern = null;
        try {
            servicesObjectNamePattern = ObjectNameFactory.getPatternForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)clusterID, (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        Set<ObjectName> set = mBeanServer.queryNames(servicesObjectNamePattern, null);
        Iterator<ObjectName> servicesIterator = set.iterator();
        try {
            while (servicesIterator.hasNext()) {
                ObjectName serviceObjectName = servicesIterator.next();
                String serviceDisplayName = (String)mBeanServer.invoke(serviceObjectName, "getDisplayName", new Object[0], new String[0]);
                String serviceManagementName = (String)mBeanServer.invoke(serviceObjectName, "getName", new Object[0], new String[0]);
                resultMap.put(serviceDisplayName, serviceManagementName);
            }
            return resultMap;
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return null;
    }

    public int compareTo(Object o) {
        MBeanTreeNodeImpl mBeanTreeNode = (MBeanTreeNodeImpl)o;
        return this.getDescriptiveName().compareToIgnoreCase(mBeanTreeNode.getDescriptiveName());
    }

    public String toString() {
        return this.descriptiveName == null ? "" : this.descriptiveName;
    }

    public static MBeanTreeNode getSimpleRootMBeanTreeNode(MBeanServer jmxconn, String rootPath, ObjectName rootMBean, String rootDisplayName) {
        MBeanTreeNodeImpl root = new MBeanTreeNodeImpl(rootPath, rootMBean, null, rootDisplayName, null);
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)"\"\"");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Object[] mbeans = jmxconn.queryNames(pattern, null).toArray();
        int i = 0;
        while (i < mbeans.length) {
            ObjectName mbeanName = (ObjectName)mbeans[i];
            if (!mbeanName.equals(rootMBean)) {
                String subpath = null;
                String displayName = null;
                try {
                    String mbeanPath;
                    MBeanInfo info = null;
                    info = jmxconn.getMBeanInfo(mbeanName);
                    if (info instanceof AdditionalInfo && (mbeanPath = ((AdditionalInfo)info).getProperty("admin.path")) != null && mbeanPath.startsWith(rootPath)) {
                        subpath = mbeanPath.substring(rootPath.length());
                        displayName = ((AdditionalInfo)info).getProperty("admin.displayName");
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                if (subpath != null && !subpath.equals("")) {
                    root.buildChainOfNodes(rootPath, subpath, root, mbeanName, displayName, null, null, null);
                }
            }
            ++i;
        }
        return root;
    }

    private void addSortedKernelChild(Vector vector, ManagerNodeDescriptor kernelChildUserObject) {
        int position = 0;
        while (position < vector.size()) {
            if (((ManagerNodeDescriptor)vector.elementAt(position)).compareTo(kernelChildUserObject) > 0) break;
            ++position;
        }
        vector.insertElementAt(kernelChildUserObject, position);
    }

    private void addSorted(MBeanTreeNode mBeanTreeNode) {
        int position = 0;
        if (!this.isManagersRoot(mBeanTreeNode) && !this.isUnknownGroup(mBeanTreeNode)) {
            while (position < this.successors.size()) {
                if (((MBeanTreeNodeImpl)this.successors.elementAt(position)).compareTo(mBeanTreeNode) <= 0 || this.isManagersRoot((MBeanTreeNode)this.successors.elementAt(position))) {
                    ++position;
                    continue;
                }
                break;
            }
        } else if (this.isUnknownGroup(mBeanTreeNode)) {
            position = this.successors.size();
        }
        this.successors.insertElementAt(mBeanTreeNode, position);
    }

    private boolean isManagersRoot(MBeanTreeNode mBeanTreeNode) {
        return mBeanTreeNode.getType() == 2;
    }

    private boolean isUnknownGroup(MBeanTreeNode mBeanTreeNode) {
        return mBeanTreeNode.getType() == 6 && mBeanTreeNode.getPath().indexOf("$GROUP_Services") == -1 && mBeanTreeNode.getPath().indexOf("$GROUP_Interfaces") == -1 && mBeanTreeNode.getPath().indexOf("$GROUP_Libraries") == -1;
    }

    public MBeanTreeNode getFromSubTree(ObjectName objectName) {
        if (this.root == null) {
            return objectName.equals(this.objectName) ? this : null;
        }
        MBeanTreeNode node = (MBeanTreeNode)this.root.objectNameToTreeNodeMap.get((Object)objectName);
        return node != null && node.getPath().startsWith(this.path) ? node : null;
    }

    private static Map createGlobalPropertySheets(Map componentNameToDefaultPropsMap, Map componentNameToCustomPropsMap, Map componentNameToSecuredKeysMap) {
        TreeMap resultMap = new TreeMap();
        Iterator keysIterator = componentNameToDefaultPropsMap.keySet().iterator();
        while (keysIterator.hasNext()) {
            String componentName = (String)keysIterator.next();
            Properties globalDefaultProperties = (Properties)componentNameToDefaultPropsMap.get(componentName);
            Properties globalCustomProperties = (Properties)componentNameToCustomPropsMap.get(componentName);
            Set globalSecuredKeys = (Set)componentNameToSecuredKeysMap.get(componentName);
            TreeSet keys = new TreeSet();
            TreeMap<String, GlobalPropertySheet> propertySheets = new TreeMap<String, GlobalPropertySheet>();
            Set defaultKeys = ((Hashtable)globalDefaultProperties).keySet();
            Set customKeys = ((Hashtable)globalCustomProperties).keySet();
            keys.addAll(defaultKeys);
            keys.addAll(customKeys);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                GlobalPropertySheet globalPropertySheet = !globalSecuredKeys.contains(key) ? new GlobalPropertySheet(globalDefaultProperties.getProperty(key), globalCustomProperties.getProperty(key), false) : new GlobalPropertySheet(null, null, true);
                propertySheets.put(key, globalPropertySheet);
            }
            resultMap.put(componentName, propertySheets);
        }
        return resultMap;
    }

    public void printTree(int n) {
        this.printNode(n);
        Vector s = this.getSuccessors();
        int i = 0;
        while (i < s.size()) {
            ((MBeanTreeNodeImpl)s.elementAt(i)).printTree(n + 5);
            ++i;
        }
    }

    public void printNode(int n) {
        int i = 0;
        while (i < n) {
            System.out.print(" ");
            ++i;
        }
        byte type = this.getType();
        System.out.print("* ");
        if (type != 6) {
            System.out.print(this.getDescriptiveName() + " | ");
            System.out.print(this.getManipulationName() + " | ");
            System.out.print(this.getObjectName() + " | ");
            System.out.println(type);
        } else {
            System.out.print(this.getDescriptiveName() + " | ");
            System.out.println(type);
        }
        System.out.println();
    }
}

