/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.adminadapter.AdminAdapterFrame;
import com.sap.engine.services.adminadapter.interfaces.KernelEventListener;
import com.sap.engine.services.adminadapter.interfaces.MBeanRegistrationEventListener;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.engine.services.basicadmin.mbean.KernelNotification;
import com.sap.engine.services.rmi_p4.P4RuntimeException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class KernelTattler
implements NotificationListener,
MBeanRegistrationEventListener {
    Vector listeners = null;
    private RemoteAdminInterface remoteAdminInterface = null;
    private MBeanServer jmxconn = null;
    private boolean isIntermediator = false;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$impl$KernelTattler;

    public KernelTattler(MBeanServer jmxconn, RemoteAdminInterface remoteAdminInterface) {
        this.jmxconn = jmxconn;
        this.remoteAdminInterface = remoteAdminInterface;
        this.listeners = new Vector();
    }

    public void registerKernelEventListener(KernelEventListener kel) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.add(kel) && this.listeners.size() == 1) {
                this.registerAsIntermediator();
            }
        }
    }

    public void unregisterKernelEventListener(KernelEventListener kel) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.remove(kel) && this.listeners.size() == 0) {
                this.unregisterAsIntermediator();
            }
        }
    }

    public void handleNotification(Notification notification, Object o) {
        block32: {
            int clusterId;
            String manager;
            String type;
            KernelNotification note;
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block31: {
                                if (!(notification instanceof KernelNotification)) {
                                    return;
                                }
                                note = (KernelNotification)notification;
                                type = note.getType();
                                manager = note.getManager();
                                clusterId = note.getClusterId();
                                if (!type.equals("global.custom.manager.properties.changed")) break block31;
                                int i = 0;
                                while (i < this.listeners.size()) {
                                    try {
                                        ((KernelEventListener)this.listeners.elementAt(i)).globalCustomManagerPropertiesChanged(clusterId, manager, note.getGlobalCustomProperties());
                                    }
                                    catch (P4RuntimeException prex) {
                                        this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                                        --i;
                                    }
                                    catch (RemoteException rex) {
                                        rex.printStackTrace();
                                    }
                                    catch (Exception exc) {
                                        this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                                        --i;
                                    }
                                    ++i;
                                }
                                break block32;
                            }
                            if (!type.equals("global.custom.manager.properties.deleted")) break block33;
                            int i = 0;
                            while (i < this.listeners.size()) {
                                try {
                                    ((KernelEventListener)this.listeners.elementAt(i)).globalCustomManagerPropertiesDeleted(clusterId, manager, note.getGlobalCustomDeletedKeys());
                                }
                                catch (P4RuntimeException prex) {
                                    this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                                    --i;
                                }
                                catch (RemoteException rex) {
                                    rex.printStackTrace();
                                }
                                catch (Exception exc) {
                                    this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                                    --i;
                                }
                                ++i;
                            }
                            break block32;
                        }
                        if (!type.equals("local.custom.manager.properties.changed")) break block34;
                        int i = 0;
                        while (i < this.listeners.size()) {
                            try {
                                ((KernelEventListener)this.listeners.elementAt(i)).localCustomManagerPropertiesChanged(clusterId, manager, note.getLocalCustomManagerProperties());
                            }
                            catch (P4RuntimeException prex) {
                                this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                                --i;
                            }
                            catch (RemoteException rex) {
                                rex.printStackTrace();
                            }
                            catch (Exception exc) {
                                this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                                --i;
                            }
                            ++i;
                        }
                        break block32;
                    }
                    if (!type.equals("local.custom.manager.properties.deleted")) break block35;
                    int i = 0;
                    while (i < this.listeners.size()) {
                        try {
                            ((KernelEventListener)this.listeners.elementAt(i)).localCustomManagerPropertiesDeleted(clusterId, manager, note.getLocalCustomDeletedKeys());
                        }
                        catch (P4RuntimeException prex) {
                            this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                            --i;
                        }
                        catch (RemoteException rex) {
                            rex.printStackTrace();
                        }
                        catch (Exception exc) {
                            this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                            --i;
                        }
                        ++i;
                    }
                    break block32;
                }
                if (!type.equals("local.default.manager.properties.changed")) break block36;
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        ((KernelEventListener)this.listeners.elementAt(i)).localDefaultManagerPropertiesChanged(clusterId, manager, note.getLocalDefaultManagerProperties());
                    }
                    catch (P4RuntimeException prex) {
                        this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    catch (RemoteException rex) {
                        rex.printStackTrace();
                    }
                    catch (Exception exc) {
                        this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                        --i;
                    }
                    ++i;
                }
                break block32;
            }
            if (!type.equals("runtime.manager.properties.changed")) break block32;
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((KernelEventListener)this.listeners.elementAt(i)).runtimeManagerPropertiesChanged(clusterId, manager, note.getRuntimeProperties());
                }
                catch (P4RuntimeException prex) {
                    this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                    --i;
                }
                catch (RemoteException rex) {
                    rex.printStackTrace();
                }
                catch (Exception exc) {
                    this.unregisterKernelEventListener((KernelEventListener)this.listeners.elementAt(i));
                    --i;
                }
                ++i;
            }
        }
    }

    private void registerAsIntermediator() {
        this.isIntermediator = true;
    }

    private void unregisterAsIntermediator() {
        this.isIntermediator = false;
        Object[] clusterNodeRepresentatives = AdminAdapterFrame.getAllClusterRepresentatives();
        int i = 0;
        while (i < clusterNodeRepresentatives.length) {
            ObjectName clusterNodeRepresentative = (ObjectName)clusterNodeRepresentatives[i];
            try {
                this.jmxconn.removeNotificationListener(clusterNodeRepresentative, this);
            }
            catch (Exception exc) {
                Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$impl$KernelTattler == null ? KernelTattler.class$("com.sap.engine.services.adminadapter.impl.KernelTattler") : class$com$sap$engine$services$adminadapter$impl$KernelTattler)).catching((Throwable)exc);
            }
            ++i;
        }
    }

    public void addedMBeanTreeNode(MBeanTreeNode node) throws RemoteException {
    }

    public void removedMBeanTreeNode(MBeanTreeNode node) throws RemoteException {
    }

    public void newClusterNodeAvailable(ObjectName clusterNodeRepresentative) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.size() > 0) {
                try {
                    this.jmxconn.addNotificationListener(clusterNodeRepresentative, this, null, null);
                }
                catch (Exception exc) {
                    Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$impl$KernelTattler == null ? (class$com$sap$engine$services$adminadapter$impl$KernelTattler = KernelTattler.class$("com.sap.engine.services.adminadapter.impl.KernelTattler")) : class$com$sap$engine$services$adminadapter$impl$KernelTattler));
                    location.logT(500, "Couldn't register tattler as an intermediator to MBean : " + clusterNodeRepresentative);
                    LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"newClusterNodeAvailable(ObjectName clusterNodeRepresentative)", (String)"Unable to register for administrative events on remote node", (Throwable)exc);
                }
            }
        }
    }

    public void connectTo(ObjectName clusterNodeRepresentative) {
        if (this.isIntermediator) {
            try {
                this.jmxconn.addNotificationListener(clusterNodeRepresentative, this, null, null);
            }
            catch (Exception exc) {
                Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$impl$KernelTattler == null ? (class$com$sap$engine$services$adminadapter$impl$KernelTattler = KernelTattler.class$("com.sap.engine.services.adminadapter.impl.KernelTattler")) : class$com$sap$engine$services$adminadapter$impl$KernelTattler));
                location.logT(500, "Couldn't register kernel tattler as an intermediator to MBean : " + clusterNodeRepresentative);
                LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"connectTo(ObjectName clusterNodeRepresentative)", (String)"Unable to register for administrative events on remote node", (Throwable)exc);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

