/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.services.adminadapter.impl.KernelTattler;
import com.sap.engine.services.adminadapter.impl.Util;
import com.sap.engine.services.adminadapter.interfaces.KernelAdministrator;
import com.sap.engine.services.adminadapter.interfaces.KernelEventListener;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.jmx.ObjectNameFactory;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.rmi.PortableRemoteObject;

public class KernelAdministratorImpl
extends PortableRemoteObject
implements KernelAdministrator {
    private MBeanServer mBeanServer = null;
    private KernelTattler tattler = null;

    public KernelAdministratorImpl(MBeanServer mBeanServer, RemoteAdminInterface remoteAdminInterface) throws RemoteException {
        this.mBeanServer = mBeanServer;
        this.tattler = new KernelTattler(mBeanServer, remoteAdminInterface);
    }

    public KernelTattler getTattler() {
        return this.tattler;
    }

    public String[] getAllManagers(int clusterID) throws RemoteException {
        String[] managers = null;
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            managers = (String[])this.mBeanServer.invoke(kernelAdministratorObjectName, "getAllManagers", new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return managers;
    }

    public Properties getManagerProperties(int clusterID, String managerName) throws RemoteException {
        Properties properties = null;
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            properties = (Properties)this.mBeanServer.invoke(kernelAdministratorObjectName, "getManagerProperties", new Object[]{managerName}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not get properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not get properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not get properties of manager " + managerName, re.getTargetException());
        }
        return properties;
    }

    public boolean setManagerProperties(int clusterID, String managerName, Properties properties) throws RemoteException {
        boolean result = false;
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            result = (Boolean)this.mBeanServer.invoke(kernelAdministratorObjectName, "setManagerProperties", new Object[]{managerName, properties}, new String[]{"java.lang.String", "java.util.Properties"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not set properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not set properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not set properties of manager " + managerName, re.getTargetException());
        }
        return result;
    }

    public String getManagerProperty(int clusterID, String manager, String key) throws RemoteException {
        String managerProperty = null;
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            managerProperty = (String)this.mBeanServer.invoke(kernelAdministratorObjectName, "getManagerProperty", new Object[]{manager, key}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not get property " + key + " of manager " + manager, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not get property " + key + " of manager " + manager, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not get property " + key + " of manager " + manager, re.getTargetException());
        }
        return managerProperty;
    }

    public boolean setManagerProperty(int clusterID, String manager, String key, String value) throws RemoteException {
        boolean result = false;
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            result = (Boolean)this.mBeanServer.invoke(kernelAdministratorObjectName, "setManagerProperty", new Object[]{manager, key, value}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not set property " + key + " of manager " + manager, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not set property " + key + " of manager " + manager, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not set property " + key + " of manager " + manager, re.getTargetException());
        }
        return result;
    }

    public void registerKernelEventListener(KernelEventListener kel) throws RemoteException {
        this.tattler.registerKernelEventListener(kel);
    }

    public void unregisterKernelEventListener(KernelEventListener kel) throws RemoteException {
        this.tattler.unregisterKernelEventListener(kel);
    }

    private ObjectName generateObjectName(int clusterId) {
        ObjectName objectName = null;
        try {
            objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)("kernel_" + clusterId), (String)String.valueOf(clusterId), (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        return objectName;
    }

    protected void newMBean(ObjectName mbeanName) {
        try {
            this.mBeanServer.addNotificationListener(mbeanName, this.tattler, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void newClusterNodeAvailable(ObjectName clusterNodeRepresentative) {
        this.tattler.newClusterNodeAvailable(clusterNodeRepresentative);
    }

    public Properties getGlobalDefaultProperties(String managerName, byte clusterNodeType) throws RemoteException {
        Properties properties = null;
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
        try {
            properties = (Properties)this.mBeanServer.invoke(kernelAdministratorObjectName, "getGlobalDefaultProperties", new Object[]{managerName}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not get global default properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not get global default properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not get global default properties of manager " + managerName, re.getTargetException());
        }
        return properties;
    }

    public Properties getGlobalCustomProperties(String managerName, byte clusterNodeType) throws RemoteException {
        Properties properties = null;
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
        try {
            properties = (Properties)this.mBeanServer.invoke(kernelAdministratorObjectName, "getGlobalCustomProperties", new Object[]{managerName}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not get global custom properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not get global custom properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not get global custom properties of manager " + managerName, re.getTargetException());
        }
        return properties;
    }

    public void updateGlobalCustomProperties(String managerName, Properties properties, byte clusterNodeType) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
        try {
            this.mBeanServer.invoke(kernelAdministratorObjectName, "setGlobalCustomProperties", new Object[]{managerName, properties}, new String[]{"java.lang.String", "java.util.Properties"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not update global custom properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not update global custom properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not update global custom properties of manager " + managerName, re.getTargetException());
        }
    }

    public Properties getLocalDefaultProperties(int clusterID, String managerName) throws RemoteException {
        Properties properties = null;
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            properties = (Properties)this.mBeanServer.invoke(kernelAdministratorObjectName, "getLocalDefaultProperties", new Object[]{managerName}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not get local default properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not get local default properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not get local default properties of manager " + managerName, re.getTargetException());
        }
        return properties;
    }

    public Properties getLocalCustomProperties(int clusterID, String managerName) throws RemoteException {
        Properties properties = null;
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            properties = (Properties)this.mBeanServer.invoke(kernelAdministratorObjectName, "getLocalCustomProperties", new Object[]{managerName}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not get local custom properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not get local custom properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not get local custom properties of manager " + managerName, re.getTargetException());
        }
        return properties;
    }

    public void updateLocalDefaultProperties(int clusterID, String managerName, Properties properties) throws RemoteException {
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            this.mBeanServer.invoke(kernelAdministratorObjectName, "setLocalDefaultProperties", new Object[]{managerName, properties}, new String[]{"java.lang.String", "java.util.Properties"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not update local default properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not update local default properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not update local default properties of manager " + managerName, re.getTargetException());
        }
    }

    public void updateLocalCustomProperties(int clusterID, String managerName, Properties properties) throws RemoteException {
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            this.mBeanServer.invoke(kernelAdministratorObjectName, "setLocalCustomProperties", new Object[]{managerName, properties}, new String[]{"java.lang.String", "java.util.Properties"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not update local custom properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not update local custom properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not update local custom properties of manager " + managerName, re.getTargetException());
        }
    }

    public void restoreGlobalProperties(String managerName, String[] keys, byte clusterNodeType) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
        try {
            this.mBeanServer.invoke(kernelAdministratorObjectName, "restoreGlobalProperties", new Object[]{managerName, keys}, new String[]{"java.lang.String", "[Ljava.lang.String;"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not restore global properties of manager " + managerName, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not restore global properties of manager " + managerName, e);
        }
    }

    public void restoreLocalProperties(int clusterID, String managerName, String[] keys) throws RemoteException {
        ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
        try {
            this.mBeanServer.invoke(kernelAdministratorObjectName, "restoreLocalProperties", new Object[]{managerName, keys}, new String[]{"java.lang.String", "[Ljava.lang.String;"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not restore local properties of manager " + managerName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not restore local properties of manager " + managerName + " on cluster ID " + clusterID, e);
        }
    }

    public boolean notifyManagerOfPropertiesChange(int clusterID, String managerName, Properties properties) throws RemoteException {
        ObjectName kernelManagementObjectName = this.generateObjectName(clusterID);
        try {
            return (Boolean)this.mBeanServer.invoke(kernelManagementObjectName, "notifyManagerOfPropertiesChange", new Object[]{managerName, properties}, new String[]{"java.lang.String", "java.util.Properties"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not notify manager " + managerName + " on cluster ID " + clusterID + " for change of properties", e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not notify manager " + managerName + " on cluster ID " + clusterID + " for change of properties", e);
        }
    }

    public Set getLocalSecuredKeys(int clusterID, String managerName) throws RemoteException {
        ObjectName kernelManagementObjectName = this.generateObjectName(clusterID);
        try {
            return (Set)this.mBeanServer.invoke(kernelManagementObjectName, "getLocalSecuredKeys", new Object[]{managerName}, new String[]{"java.lang.String"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get local secure properties' keys of manager " + managerName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get local secure properties' keys of manager " + managerName + " on cluster ID " + clusterID, e);
        }
    }

    public Set getGlobalSecuredKeys(int clusterID, String managerName) throws RemoteException {
        ObjectName kernelManagementObjectName = this.generateObjectName(clusterID);
        try {
            return (Set)this.mBeanServer.invoke(kernelManagementObjectName, "getGlobalSecuredKeys", new Object[]{managerName}, new String[]{"java.lang.String"});
        }
        catch (MBeanException e) {
            throw new RemoteException("Could not get global secure properties' keys of manager " + managerName + " on cluster ID " + clusterID, e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("Could not get global secure properties' keys of manager " + managerName + " on cluster ID " + clusterID, e);
        }
    }

    public void updateGlobalCustomProperties(String managerName, Properties properties, byte clusterNodeType, Set securedKeys) throws RemoteException {
        int clusterID = Util.getRandomClusterID(this.mBeanServer, clusterNodeType);
        ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
        try {
            this.mBeanServer.invoke(kernelAdministratorObjectName, "setManagerGlobalCustomProperties", new Object[]{managerName, properties, securedKeys}, new String[]{"java.lang.String", "java.util.Properties", "java.util.Set"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not update global custom properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not update global custom properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not update global custom properties of manager " + managerName, re.getTargetException());
        }
    }

    public void updateLocalDefaultProperties(int clusterID, String manager, Properties properties, Set securedKeys) throws RemoteException {
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            this.mBeanServer.invoke(kernelAdministratorObjectName, "setManagerLocalDefaultProperties", new Object[]{manager, properties, securedKeys}, new String[]{"java.lang.String", "java.util.Properties", "java.util.Set"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not update local default properties of manager " + manager, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not update local default properties of manager " + manager, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not update local default properties of manager " + manager, re.getTargetException());
        }
    }

    public void updateLocalCustomProperties(int clusterID, String managerName, Properties properties, Set securedKeys) throws RemoteException {
        try {
            ObjectName kernelAdministratorObjectName = this.generateObjectName(clusterID);
            this.mBeanServer.invoke(kernelAdministratorObjectName, "setManagerLocalCustomProperties", new Object[]{managerName, properties, securedKeys}, new String[]{"java.lang.String", "java.util.Properties", "java.util.Set"});
        }
        catch (InstanceNotFoundException infe) {
            throw new RemoteException("Could not update local custom properties of manager " + managerName, infe);
        }
        catch (MBeanException mbe) {
            throw new RemoteException("Could not update local custom properties of manager " + managerName, mbe.getTargetException());
        }
        catch (ReflectionException re) {
            throw new RemoteException("Could not update local custom properties of manager " + managerName, re.getTargetException());
        }
    }
}

