/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.services.adminadapter.descriptor.ComponentDescriptor;
import com.sap.engine.services.adminadapter.interfaces.InterfaceAdministrator;
import com.sap.jmx.ObjectNameFactory;
import java.rmi.RemoteException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class InterfaceAdministratorImpl
implements InterfaceAdministrator {
    private MBeanServer mBeanServer;

    public InterfaceAdministratorImpl(MBeanServer mBeanServer) throws RemoteException {
        this.mBeanServer = mBeanServer;
    }

    public ComponentDescriptor getDescriptor(int clusterID, String interfaceName) throws RemoteException {
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        ObjectName standardInterfaceManagementObjectName = this.generateStandardInterfaceObjectName(clusterID, interfaceName);
        componentDescriptor.setClusterID(clusterID);
        try {
            AttributeList list = this.mBeanServer.getAttributes(standardInterfaceManagementObjectName, new String[]{"Name", "ProviderName", "DisplayName", "Description", "GroupName", "MajorVersion", "MinorVersion", "MicroVersion", "Status", "References", "Jars"});
            int i = 0;
            while (i < list.size()) {
                Attribute attr = (Attribute)list.get(i);
                String attrName = attr.getName();
                if ("Name".equals(attrName)) {
                    componentDescriptor.setName((String)attr.getValue());
                } else if ("ProviderName".equals(attrName)) {
                    componentDescriptor.setProviderName((String)attr.getValue());
                } else if ("DisplayName".equals(attrName)) {
                    componentDescriptor.setDisplayName((String)attr.getValue());
                } else if ("Description".equals(attrName)) {
                    componentDescriptor.setDescription((String)attr.getValue());
                } else if ("GroupName".equals(attrName)) {
                    componentDescriptor.setGroupName((String)attr.getValue());
                } else if ("MajorVersion".equals(attrName)) {
                    componentDescriptor.setMajorVersion((String)attr.getValue());
                } else if ("MinorVersion".equals(attrName)) {
                    componentDescriptor.setMinorVersion((String)attr.getValue());
                } else if ("MicroVersion".equals(attrName)) {
                    componentDescriptor.setMicroVersion((String)attr.getValue());
                } else if ("Status".equals(attrName)) {
                    componentDescriptor.setStatus((Byte)attr.getValue());
                } else if ("References".equals(attrName)) {
                    componentDescriptor.setReferences((String[][])attr.getValue());
                } else if ("Jars".equals(attrName)) {
                    componentDescriptor.setJars((String[])attr.getValue());
                } else {
                    System.out.println("unexpected attribute found");
                }
                ++i;
            }
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return componentDescriptor;
    }

    public boolean changeDescriptor(int clusterID, String componentName, ComponentDescriptor componentDescriptor) throws RemoteException {
        return false;
    }

    private ObjectName generateStandardInterfaceObjectName(int clusterId, String interfaceName) {
        try {
            return ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEInterfacePerNode", (String)interfaceName, (String)String.valueOf(clusterId), (String)"\"\"");
        }
        catch (MalformedObjectNameException exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

