/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.monitor.CoreMonitor;
import com.sap.engine.services.adminadapter.AdminAdapterFrame;
import com.sap.engine.services.adminadapter.impl.KernelAdministratorImpl;
import com.sap.engine.services.adminadapter.impl.MBeanTreeNodeImpl;
import com.sap.engine.services.adminadapter.impl.ServiceAdministratorImpl;
import com.sap.engine.services.adminadapter.interfaces.ClusterAdministrator;
import com.sap.engine.services.adminadapter.interfaces.ConvenienceEngineAdministrator;
import com.sap.engine.services.adminadapter.interfaces.KernelAdministrator;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.engine.services.adminadapter.interfaces.ServiceAdministrator;
import com.sap.jmx.ObjectNameFactory;
import com.sap.pj.jmx.mbeaninfo.AdditionalInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.rmi.PortableRemoteObject;

public class ConvenienceEngineAdministratorImpl
extends PortableRemoteObject
implements ConvenienceEngineAdministrator {
    private ServiceAdministrator serviceAdmin;
    private KernelAdministrator kernelAdmin;
    private ClusterAdministrator clusterAdmin;
    private MBeanServer server;
    private ApplicationServiceContext serviceContext = null;

    public ConvenienceEngineAdministratorImpl(ClusterAdministrator clusterAdmin, KernelAdministrator kernelAdmin, ServiceAdministrator serviceAdmin, MBeanServer server, ApplicationServiceContext serviceContext) throws RemoteException {
        this.clusterAdmin = clusterAdmin;
        this.kernelAdmin = kernelAdmin;
        this.serviceAdmin = serviceAdmin;
        this.server = server;
        this.serviceContext = serviceContext;
    }

    public Properties getServiceProperties(int clusterID, String serviceName) throws RemoteException {
        return this.serviceAdmin.getServiceProperties(clusterID, serviceName);
    }

    public String[] getAllManagers(int clusterId) throws RemoteException {
        return this.kernelAdmin.getAllManagers(clusterId);
    }

    public String[] getAllServices(int clusterId) throws RemoteException {
        try {
            Set<ObjectName> services = this.server.queryNames(ObjectNameFactory.getPatternForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)String.valueOf(clusterId), (String)"\"\""), null);
            String[] result = new String[services.size()];
            Iterator<ObjectName> elements = services.iterator();
            int count = 0;
            while (elements.hasNext()) {
                ObjectName serviceManagement = elements.next();
                result[count] = (String)this.server.invoke(serviceManagement, "getName", new Object[0], new String[0]);
                ++count;
            }
            return result;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public byte getClusterNodeType(int clusterId) throws RemoteException {
        return this.clusterAdmin.getType(clusterId).equals("server") ? (byte)2 : 1;
    }

    public String getClusterName() throws RemoteException {
        return this.clusterAdmin.getClusterInfo().getProperty("Name");
    }

    public int[] getClusterNodeIds() throws RemoteException {
        try {
            Set<ObjectName> clusterNodes = this.server.queryNames(ObjectNameFactory.getPatternForServerChild((String)"SAP_J2EEClusterNode", (String)"\"\""), null);
            int[] result = new int[clusterNodes.size()];
            Iterator<ObjectName> elements = clusterNodes.iterator();
            int count = 0;
            while (elements.hasNext()) {
                ObjectName serviceManagement = elements.next();
                result[count] = Integer.parseInt(((Properties)this.server.invoke(serviceManagement, "getInfo", new Object[0], new String[0])).getProperty("ID"));
                ++count;
            }
            return result;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public String[] getClusterNodeNames() throws RemoteException {
        try {
            Set<ObjectName> clusterNodes = this.server.queryNames(ObjectNameFactory.getPatternForServerChild((String)"SAP_J2EEClusterNode", (String)"\"\""), null);
            String[] result = new String[clusterNodes.size()];
            Iterator<ObjectName> elements = clusterNodes.iterator();
            int count = 0;
            while (elements.hasNext()) {
                ObjectName serviceManagement = elements.next();
                result[count] = ((Properties)this.server.invoke(serviceManagement, "getInfo", new Object[0], new String[0])).getProperty("Name");
                ++count;
            }
            return result;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public MBeanTreeNode getTopOfTree() throws RemoteException {
        ClusterMonitor clusterMonitor = this.serviceContext.getClusterContext().getClusterMonitor();
        CoreMonitor coreMonitor = this.serviceContext.getCoreContext().getCoreMonitor();
        Hashtable<String, String> nameTable = new Hashtable<String, String>();
        nameTable.put("j2eeType", "SAP_J2EECluster");
        nameTable.put("name", clusterMonitor.getClusterName());
        ObjectName rootObjectName = null;
        try {
            rootObjectName = new ObjectName("", nameTable);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        return MBeanTreeNodeImpl.buildTopOfTree(this.server, clusterMonitor, coreMonitor, rootObjectName);
    }

    public MBeanTreeNode getClusterNodeSubTree(String rootPath, ObjectName rootMBean) throws RemoteException {
        if (rootPath == null && rootMBean == null) {
            return MBeanTreeNodeImpl.buildRootMBeanUserObject(this.server);
        }
        int clusterId = Integer.parseInt(ObjectNameFactory.getName((ObjectName)rootMBean));
        ObjectName representativeMBean = AdminAdapterFrame.getRepresentativeMBeanObjectName(clusterId);
        try {
            ((ServiceAdministratorImpl)this.serviceAdmin).getTattler().connectTo(representativeMBean);
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            ((KernelAdministratorImpl)this.kernelAdmin).getTattler().connectTo(representativeMBean);
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            return (MBeanTreeNode)this.server.invoke(representativeMBean, "getClusterNodeMBeanSubTree", new Object[0], new String[0]);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public Vector getAdditionalMBeans() {
        Vector<MBeanTreeNodeImpl> mBeanTreeNodes = new Vector<MBeanTreeNodeImpl>();
        try {
            ObjectName objectNamesPattern = ObjectNameFactory.getPatternForServerChild((String)"\"\"");
            Set<ObjectName> mBeans = this.server.queryNames(objectNamesPattern, null);
            if (mBeans != null) {
                Iterator<ObjectName> iterator = mBeans.iterator();
                while (iterator.hasNext()) {
                    MBeanTreeNodeImpl mBeanTreeNode;
                    String mBeanPath;
                    ObjectName objectName = iterator.next();
                    MBeanInfo mBeanInfo = this.server.getMBeanInfo(objectName);
                    if (!(mBeanInfo instanceof AdditionalInfo) || (mBeanPath = ((AdditionalInfo)mBeanInfo).getProperty("admin.path")) == null || (mBeanTreeNode = new MBeanTreeNodeImpl(mBeanPath, null, objectName, null, null, null)).getType() != -1) continue;
                    mBeanTreeNode.buildUserObject(this.server, this.serviceContext.getCoreContext().getLoadContext());
                    mBeanTreeNodes.addElement(mBeanTreeNode);
                }
            }
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return mBeanTreeNodes;
    }

    public int getProviderClusterNodeID() {
        return this.serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
    }

    public String getClusterNodeName(int clusterId) throws RemoteException {
        return this.clusterAdmin.getNodeInfo(clusterId).getProperty("Name");
    }

    public Properties getManagerProperties(int clusterId, String manager) throws RemoteException {
        return this.kernelAdmin.getManagerProperties(clusterId, manager);
    }

    public String getManagerProperty(int clusterId, String manager, String key) throws RemoteException {
        return this.kernelAdmin.getManagerProperty(clusterId, manager, key);
    }

    public String getServiceProperty(int clusterID, String serviceName, String key) throws RemoteException {
        return this.serviceAdmin.getServiceProperty(clusterID, serviceName, key);
    }

    public void rebootClusterNode(int clusterId) throws RemoteException {
        this.clusterAdmin.rebootNode(clusterId);
    }

    public boolean setManagerProperties(int clusterId, String manager, Properties properties) throws RemoteException {
        return this.kernelAdmin.setManagerProperties(clusterId, manager, properties);
    }

    public boolean setManagerProperty(int clusterId, String manager, String key, String value) throws RemoteException {
        return this.kernelAdmin.setManagerProperty(clusterId, manager, key, value);
    }

    public boolean setServiceProperties(int clusterID, String serviceName, Properties sp) throws RemoteException {
        return this.serviceAdmin.setServiceProperties(clusterID, serviceName, sp);
    }

    public boolean setServiceProperty(int clusterID, String serviceName, String key, String value) throws RemoteException {
        return this.serviceAdmin.setServiceProperty(clusterID, serviceName, key, value);
    }

    public void shutdownClusterNode(int clusterId) throws RemoteException {
        this.clusterAdmin.shutdownNode(clusterId);
    }

    public void startService(int clusterId, String serviceName) throws RemoteException {
        this.serviceAdmin.startService(clusterId, serviceName);
    }

    public void stopService(int clusterId, String serviceName) throws RemoteException {
        this.serviceAdmin.stopService(clusterId, serviceName);
    }

    public MBeanTreeNode getSimpleRootMBeanTreeNode() throws RemoteException {
        ObjectName pattern = null;
        try {
            pattern = new ObjectName(":j2eeType=SAP_J2EECluster,*");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Object[] result = this.server.queryNames(pattern, null).toArray();
        ObjectName mbeanName = (ObjectName)result[0];
        AdditionalInfo info = null;
        try {
            info = (AdditionalInfo)this.server.getMBeanInfo(mbeanName);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        String path = info.getProperty("admin.path");
        String displayName = info.getProperty("admin.displayName");
        return MBeanTreeNodeImpl.getSimpleRootMBeanTreeNode(this.server, path, mbeanName, displayName);
    }

    public String[] getConfigurationFilesList() throws ConfigurationException {
        return this.serviceContext.getContainerContext().getSystemMonitor().getConfigurationFilesList();
    }

    public String archiveConfiguration(String archiveFileName, String[][] configurationFileNames) {
        ZipOutputStream zout = null;
        SystemMonitor sm = this.serviceContext.getContainerContext().getSystemMonitor();
        try {
            zout = new ZipOutputStream(new FileOutputStream(archiveFileName));
        }
        catch (FileNotFoundException e) {
            return "Can't create archive: " + e.getMessage();
        }
        String result = "";
        byte[] buffer = new byte[10000];
        int i = 0;
        while (i < configurationFileNames.length) {
            try {
                ZipEntry z = new ZipEntry(configurationFileNames[i][1]);
                zout.putNextEntry(z);
                InputStream in = sm.getConfigurationFile(configurationFileNames[i][0]);
                while (in.available() != 0) {
                    int readed = in.read(buffer);
                    zout.write(buffer, 0, readed);
                }
            }
            catch (Exception e) {
                result = result + "Can't add '" + configurationFileNames[i] + "': " + e.getMessage() + "\n";
            }
            ++i;
        }
        try {
            zout.closeEntry();
            zout.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    public long getFileSize(String fileName) {
        return new File(fileName).length();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readFromFile(String fileName, long offset, int length) {
        block11: {
            block10: {
                in = null;
                try {
                    try {
                        in = new FileInputStream(fileName);
                        in.skip(offset);
                        buffer = new byte[length];
                        readed = in.read(buffer);
                        if (readed != length) {
                            result = new byte[readed];
                            System.arraycopy(buffer, 0, result, 0, readed);
                            var9_11 = result;
                            var11_12 = null;
                            break block10;
                        }
                        var8_10 = buffer;
                        break block11;
                    }
                    catch (Exception e) {
                        var7_8 = null;
                        var11_14 = null;
                        try {
                            in.close();
                            return var7_8;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var7_8;
                    }
                }
                catch (Throwable var10_20) {
                    var11_15 = null;
                    try {}
                    catch (IOException e) {
                        throw var10_20;
                    }
                    in.close();
                    throw var10_20;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 100->108)] { 
lbl39:
            // 1 sources

            in.close();
            return var9_11;
lbl41:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var9_11;
        }
        var11_13 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 100->108)] { 
lbl47:
        // 1 sources

        in.close();
        return var8_10;
lbl49:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var8_10;
    }

    public void deleteArchive(String fileName) {
        new File(fileName).delete();
    }
}

