/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.container.monitor.InterfaceMonitor;
import com.sap.engine.frame.container.monitor.LibraryMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.services.adminadapter.impl.ClusterNodeRepresentativeMBean;
import com.sap.engine.services.adminadapter.impl.MBeanTreeNodeImpl;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.engine.services.adminadapter.shell.ListInterfacesCommand;
import com.sap.engine.services.adminadapter.shell.ListLibrariesCommand;
import com.sap.engine.services.adminadapter.shell.ListServicesCommand;
import com.sap.jmx.ObjectNameFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ClusterNodeRepresentative
extends NotificationBroadcasterSupport
implements ClusterNodeRepresentativeMBean,
NotificationListener,
MBeanRegistration {
    public static final String CONTAINER_STARTED = "container.started";
    private MBeanServer jmxconn = null;
    ClusterElement thisClusterNode = null;
    LoadContext loadContext = null;
    private SystemMonitor systemMonitor = null;
    private long notifNumber = 0L;
    private ObjectName objectName = null;

    public ClusterNodeRepresentative(MBeanServer jmxconn, LoadContext loadContext, ClusterElement thisClusterNode, SystemMonitor systemMonitor) {
        this.jmxconn = jmxconn;
        this.loadContext = loadContext;
        this.thisClusterNode = thisClusterNode;
        this.systemMonitor = systemMonitor;
        Object[] services = this.getAllServices();
        int i = 0;
        while (i < services.length) {
            ObjectName service = (ObjectName)services[i];
            try {
                jmxconn.addNotificationListener(service, this, null, null);
            }
            catch (InstanceNotFoundException infe) {
                infe.printStackTrace();
            }
            ++i;
        }
        try {
            jmxconn.addNotificationListener(this.getKernel(), this, null, null);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
    }

    public MBeanTreeNode getClusterNodeMBeanSubTree() {
        String rootPath = "/Cluster/" + String.valueOf(this.thisClusterNode.getClusterId());
        String rootDisplayName = this.thisClusterNode.getName();
        ObjectName rootObjectName = null;
        try {
            rootObjectName = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(this.thisClusterNode.getClusterId()), (String)"\"\"");
        }
        catch (Exception exc) {
            return null;
        }
        return MBeanTreeNodeImpl.buildClusterNodeSubTree(this.jmxconn, rootPath, rootObjectName, rootDisplayName, this.loadContext);
    }

    public String[][] getAllServicesInfo() {
        ServiceMonitor[] services = this.systemMonitor.getServices();
        String[][] result = new String[services.length][5];
        int i = 0;
        while (i < services.length) {
            result[i][0] = services[i].getDisplayName();
            result[i][1] = services[i].getComponentName();
            result[i][2] = ListServicesCommand.statusToString(services[i].getStatus());
            result[i][3] = ListServicesCommand.startupModeToString(services[i].getStartupMode());
            result[i][4] = ListServicesCommand.isCoreToString(services[i].isCore());
            ++i;
        }
        return result;
    }

    public String[][] getAllLibrariesInfo() {
        LibraryMonitor[] libraries = this.systemMonitor.getLibraries();
        String[][] result = new String[libraries.length][3];
        int i = 0;
        while (i < libraries.length) {
            result[i][0] = libraries[i].getDisplayName();
            result[i][1] = libraries[i].getComponentName();
            result[i][2] = ListLibrariesCommand.statusToString(libraries[i].getStatus());
            ++i;
        }
        return result;
    }

    public String[][] getAllInterfacesInfo() {
        InterfaceMonitor[] interfaces = this.systemMonitor.getInterfaces();
        String[][] result = new String[interfaces.length][3];
        int i = 0;
        while (i < interfaces.length) {
            result[i][0] = interfaces[i].getDisplayName();
            result[i][1] = interfaces[i].getComponentName();
            result[i][2] = ListInterfacesCommand.statusToString(interfaces[i].getStatus());
            ++i;
        }
        return result;
    }

    protected Object[] getAllServices() {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)"\"\"", (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
            return new ObjectName[0];
        }
        return this.jmxconn.queryNames(pattern, null).toArray();
    }

    private ObjectName getKernel() {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChildPerNode((String)"SAP_J2EEKernelPerNode", (String)"\"\"", (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
            return null;
        }
        return this.jmxconn.queryNames(pattern, null).iterator().next();
    }

    public void handleNotification(Notification notification, Object o) {
        try {
            this.sendNotification(notification);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"service.lodaded", "service.unloaded", "service.started", "service.stopped", "service.startup.mode.changed", "global.custom.service.properties.changed", "global.custom.service.properties.deleted", "local.custom.service.properties.changed", "local.custom.service.properties.deleted", "local.default.service.properties.changed", "runtime.service.properties.changed", "global.custom.manager.properties.changed", "global.custom.manager.properties.deleted", "local.custom.manager.properties.changed", "local.custom.manager.properties.deleted", "local.default.manager.properties.changed", "runtime.manager.properties.changed", CONTAINER_STARTED};
        MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.Notification", "Notifications sent by ClusterNodeRepresentative MBean")};
        return notifsInfo;
    }

    public void containerStarted() {
        this.sendNotification(new Notification(CONTAINER_STARTED, this.objectName, this.getNotifNumber()));
    }

    private synchronized long getNotifNumber() {
        return this.notifNumber++;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        return objectName;
    }

    public void postDeregister() {
    }

    public void preDeregister() throws Exception {
    }

    public void postRegister(Boolean aBoolean) {
    }
}

