/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.impl;

import com.sap.engine.services.adminadapter.AdminAdapterFrame;
import com.sap.engine.services.adminadapter.interfaces.ClusterAdministrator;
import com.sap.jmx.ObjectNameFactory;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.rmi.PortableRemoteObject;

public class ClusterAdministratorImpl
extends PortableRemoteObject
implements ClusterAdministrator {
    String clusterName = null;
    MBeanServer mBeanServer = null;

    public ClusterAdministratorImpl(MBeanServer mBeanServer) throws RemoteException {
        this.mBeanServer = mBeanServer;
        this.clusterName = AdminAdapterFrame.getClusterName();
    }

    public Properties getClusterInfo() throws RemoteException {
        Properties properties = null;
        try {
            ObjectName clusterManagementObjectName = ObjectNameFactory.getObjectName((String)"SAP_J2EECluster", (String)this.clusterName);
            properties = (Properties)this.mBeanServer.invoke(clusterManagementObjectName, "getInfo", new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return properties;
    }

    public Properties getNodeInfo(int clusterID) throws RemoteException {
        Properties properties = null;
        try {
            ObjectName clusterNodeManagementObjectName = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(clusterID), (String)"\"\"");
            properties = (Properties)this.mBeanServer.invoke(clusterNodeManagementObjectName, "getInfo", new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return properties;
    }

    public void rebootNode(int clusterID) throws RemoteException {
        try {
            ObjectName clusterNodeManagementObjectName = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(clusterID), (String)"\"\"");
            this.mBeanServer.invoke(clusterNodeManagementObjectName, "reboot", new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
    }

    public void shutdownNode(int clusterID) throws RemoteException {
        try {
            ObjectName clusterNodeManagementObjectName = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(clusterID), (String)"\"\"");
            this.mBeanServer.invoke(clusterNodeManagementObjectName, "shutdown", new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
    }

    public String getType(int clusterId) throws RemoteException {
        String result = null;
        try {
            ObjectName clusterNodeManagementObjectName = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)String.valueOf(clusterId), (String)"\"\"");
            result = (String)this.mBeanServer.invoke(clusterNodeManagementObjectName, "getType", new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
        }
        catch (ReflectionException re) {
            re.printStackTrace();
        }
        return result;
    }

    public void rebootCluster() throws RemoteException {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)"SAP_J2EEClusterNode", (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            // empty catch block
        }
        Object[] mbeans = this.mBeanServer.queryNames(pattern, null).toArray();
        int i = 0;
        while (i < mbeans.length) {
            ObjectName mbean = (ObjectName)mbeans[i];
            try {
                this.mBeanServer.invoke(mbean, "reboot", new Object[0], new String[0]);
            }
            catch (Exception exc) {
                System.out.println("couldn't reboot cluster node " + ObjectNameFactory.getName((ObjectName)mbean));
                exc.printStackTrace();
            }
            ++i;
        }
    }

    public void shutdownCluster() throws RemoteException {
        ObjectName pattern = null;
        try {
            pattern = ObjectNameFactory.getPatternForServerChild((String)"SAP_J2EEClusterNode", (String)"\"\"");
        }
        catch (MalformedObjectNameException mone) {
            // empty catch block
        }
        Object[] mbeans = this.mBeanServer.queryNames(pattern, null).toArray();
        int i = 0;
        while (i < mbeans.length) {
            ObjectName mbean = (ObjectName)mbeans[i];
            try {
                this.mBeanServer.invoke(mbean, "shutdown", new Object[0], new String[0]);
            }
            catch (Exception exc) {
                System.out.println("couldn't shut cluster node " + ObjectNameFactory.getName((ObjectName)mbean) + " down");
                exc.printStackTrace();
            }
            ++i;
        }
    }
}

