/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;

public class ShutDownTask
extends InfiniteTaskItem
implements Runnable {
    private String clusterNodeDisplayName;
    private int clusterID;
    private String message;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$ShutDownTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$ShutDownTask = ShutDownTask.class$("com.sap.engine.services.adminadapter.gui.tasks.ShutDownTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$ShutDownTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$ShutDownTask;

    public ShutDownTask(String clusterNodeDisplayName, int clusterID) {
        super(1, 0, "Shut Down " + clusterNodeDisplayName);
        this.clusterNodeDisplayName = clusterNodeDisplayName;
        this.clusterID = clusterID;
        this.message = "Cluster node ID : " + clusterID;
    }

    public void run() {
        try {
            ClusterTreeGenerator.clusterAdministrator.shutdownNode(this.clusterID);
            this.message = this.message + "\nSuccessful !";
        }
        catch (Exception ex) {
            this.status = 2;
            this.message = ex.toString();
            location.traceThrowableT(500, "Error while shutting down cluster node " + this.clusterNodeDisplayName + " with cluster ID " + this.clusterID + ": " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Error while shutting down cluster node " + this.clusterNodeDisplayName + " with cluster ID " + this.clusterID + ": " + ex.getMessage());
        }
        this.finished();
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

