/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public final class SetServicePropertiesTask
extends InfiniteTaskItem
implements Runnable {
    private AdminManager manager;
    private String serviceName;
    private ServiceNodeDescriptor serviceNodeDescriptor;
    private String message;
    private String serviceDisplayName;
    private String clusterNodeDisplayName;
    private Properties localDefaultPropertiesToChange;
    private Properties localCustomPropertiesToChange;
    private Properties runtimePropertiesToChange;
    private Properties securedPropertiesToChange;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$SetServicePropertiesTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$SetServicePropertiesTask = SetServicePropertiesTask.class$("com.sap.engine.services.adminadapter.gui.tasks.SetServicePropertiesTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$SetServicePropertiesTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$SetServicePropertiesTask;

    public SetServicePropertiesTask(AdminManager manager, ServiceNodeDescriptor serviceNodeDescriptor, String clusterNodeDisplayName, String serviceDisplayName, Properties localDefaultPropertiesToChange, Properties localCustomPropertiesToChange, Properties runtimePropertiesToChange, Properties securedPropertiesToChange) {
        super(1, 0, "Set properties of service " + serviceDisplayName + " on " + clusterNodeDisplayName);
        this.manager = manager;
        this.serviceName = serviceNodeDescriptor.getServiceDescriptor().getName();
        this.serviceDisplayName = serviceDisplayName;
        this.clusterNodeDisplayName = clusterNodeDisplayName;
        this.serviceNodeDescriptor = serviceNodeDescriptor;
        this.localDefaultPropertiesToChange = localDefaultPropertiesToChange;
        this.localCustomPropertiesToChange = localCustomPropertiesToChange;
        this.runtimePropertiesToChange = runtimePropertiesToChange;
        this.securedPropertiesToChange = securedPropertiesToChange;
        this.message = "Cluster node ID : " + serviceNodeDescriptor.getServiceDescriptor().getClusterID();
    }

    public void run() {
        int result = -1;
        try {
            if (((Hashtable)this.localDefaultPropertiesToChange).size() > 0 || ((Hashtable)this.securedPropertiesToChange).size() > 0) {
                Set keySet = ((Hashtable)this.securedPropertiesToChange).keySet();
                HashSet serializableSet = new HashSet(keySet);
                Iterator iterator = serializableSet.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    this.localDefaultPropertiesToChange.setProperty(key, this.securedPropertiesToChange.getProperty(key));
                }
                ClusterTreeGenerator.serviceAdministrator.updateLocalDefaultProperties(this.serviceNodeDescriptor.getServiceDescriptor().getClusterID(), this.serviceName, this.localDefaultPropertiesToChange, serializableSet);
            }
            if (((Hashtable)this.localCustomPropertiesToChange).size() > 0) {
                ClusterTreeGenerator.serviceAdministrator.updateLocalCustomProperties(this.serviceNodeDescriptor.getServiceDescriptor().getClusterID(), this.serviceName, this.localCustomPropertiesToChange);
            }
            if ((result = this.runtimePropertiesToChange != null ? (ClusterTreeGenerator.serviceAdministrator.notifyServiceOfPropertiesChange(this.serviceNodeDescriptor.getServiceDescriptor().getClusterID(), this.serviceName, this.runtimePropertiesToChange) ? 1 : 0) : 1) == 0 && this.serviceNodeDescriptor.getServiceDescriptor().isCore()) {
                result = 2;
            }
            this.message = this.message + "\nSuccessful !";
        }
        catch (Exception ex) {
            result = -1;
            this.status = 2;
            this.message = ex.toString();
            location.traceThrowableT(500, "Error occured while trying to change properties of service " + this.serviceDisplayName + ": " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Error occured while trying to change properties of service " + this.serviceDisplayName);
        }
        this.finished(new Integer(result));
        if (result == 1) {
            this.message = this.message + "\nProperties of " + this.serviceDisplayName + " changed.";
            location.logT(300, "Properties of service " + this.serviceDisplayName + " changed.");
            AdminConfig.category.logT(300, location, "Properties of service " + this.serviceDisplayName + " changed.");
        } else if (result == 0 || result == 2) {
            this.message = this.message + "\nProperties of service " + this.serviceDisplayName + " changed, but restart is needed to take effect.";
            location.logT(500, "Properties of service " + this.serviceDisplayName + " changed, but restart is needed to take effect.");
            AdminConfig.category.logT(500, location, "Properties of service " + this.serviceDisplayName + " changed, but restart is needed to take effect.");
        }
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    public int getClusterID() {
        return this.serviceNodeDescriptor.getServiceDescriptor().getClusterID();
    }

    public String getClusterNodeDisplayName() {
        return this.clusterNodeDisplayName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

