/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public final class SetManagerPropertiesTask
extends InfiniteTaskItem
implements Runnable {
    private ManagerNodeDescriptor managerNodeDescriptor;
    private String clusterNodeDisplayName;
    private String message;
    private Properties localDefaultPropertiesToChange;
    private Properties localCustomPropertiesToChange;
    private Properties runtimePropertiesToChange;
    private Properties securedProperties;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$SetManagerPropertiesTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$SetManagerPropertiesTask = SetManagerPropertiesTask.class$("com.sap.engine.services.adminadapter.gui.tasks.SetManagerPropertiesTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$SetManagerPropertiesTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$SetManagerPropertiesTask;

    public SetManagerPropertiesTask(ManagerNodeDescriptor managerNodeDescriptor, String clusterNodeDisplayName, Properties localDefaultPropertiesToChange, Properties localCustomPropertiesToChange, Properties runtimePropertiesToChange, Properties securedProperties) {
        super(1, 0, "Set properties of manager " + managerNodeDescriptor.getManagerName() + " on " + clusterNodeDisplayName);
        this.managerNodeDescriptor = managerNodeDescriptor;
        this.clusterNodeDisplayName = clusterNodeDisplayName;
        this.localDefaultPropertiesToChange = localDefaultPropertiesToChange;
        this.localCustomPropertiesToChange = localCustomPropertiesToChange;
        this.runtimePropertiesToChange = runtimePropertiesToChange;
        this.securedProperties = securedProperties;
        this.message = "Cluster node ID : " + managerNodeDescriptor.getClusterID();
    }

    public void run() {
        int result = -1;
        try {
            if (((Hashtable)this.localDefaultPropertiesToChange).size() > 0 || ((Hashtable)this.securedProperties).size() > 0) {
                Set keySet = ((Hashtable)this.securedProperties).keySet();
                HashSet serializableSet = new HashSet(keySet);
                Iterator iterator = serializableSet.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    this.localDefaultPropertiesToChange.setProperty(key, this.securedProperties.getProperty(key));
                }
                ClusterTreeGenerator.kernelAdministrator.updateLocalDefaultProperties(this.managerNodeDescriptor.getClusterID(), this.managerNodeDescriptor.getManagerName(), this.localDefaultPropertiesToChange, serializableSet);
            }
            if (((Hashtable)this.localCustomPropertiesToChange).size() > 0) {
                ClusterTreeGenerator.kernelAdministrator.updateLocalCustomProperties(this.managerNodeDescriptor.getClusterID(), this.managerNodeDescriptor.getManagerName(), this.localCustomPropertiesToChange);
            }
            result = ClusterTreeGenerator.kernelAdministrator.notifyManagerOfPropertiesChange(this.managerNodeDescriptor.getClusterID(), this.managerNodeDescriptor.getManagerName(), this.runtimePropertiesToChange) ? 1 : 0;
            this.message = this.message + "\nSuccessful !";
        }
        catch (Exception ex) {
            result = -1;
            this.status = 2;
            this.message = ex.toString();
            location.traceThrowableT(500, "Error occured while trying to change properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + ": " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Error occured while trying to change properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName);
        }
        this.finished(new Integer(result));
        if (result == 1) {
            this.message = this.message + "\nProperties of " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " changed.";
            location.logT(300, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " changed.");
            AdminConfig.category.logT(300, location, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " changed.");
        } else if (result == 0) {
            this.message = this.message + "\nProperties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " changed, but restart is needed to take effect.";
            location.logT(500, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " changed, but restart is needed to take effect.");
            AdminConfig.category.logT(500, location, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " changed, but restart is needed to take effect.");
        }
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public int getClusterID() {
        return this.managerNodeDescriptor.getClusterID();
    }

    public String getManagerName() {
        return this.managerNodeDescriptor.getManagerName();
    }

    public String getClusterNodeDisplayName() {
        return this.clusterNodeDisplayName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

