/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.util.HashMapObjectInt;
import com.sap.engine.services.adminadapter.descriptor.GlobalDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class SetGlobalPropertiesTask
extends InfiniteTaskItem
implements Runnable {
    private AdminManager adminManager;
    private GlobalDescriptor globalDescriptor;
    private String message;
    private Properties customProperties;
    private HashMapObjectInt clusterElements;
    private HashMapIntObject idToLocalDefaultPropertiesMap;
    private HashMapIntObject idToLocalCustomPropertiesMap;
    private HashMapIntObject idToRuntimePropertiesMap;
    private Properties securedProperties;
    private Set coreServices;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$SetGlobalPropertiesTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$SetGlobalPropertiesTask = SetGlobalPropertiesTask.class$("com.sap.engine.services.adminadapter.gui.tasks.SetGlobalPropertiesTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$SetGlobalPropertiesTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$SetGlobalPropertiesTask;

    public SetGlobalPropertiesTask(AdminManager adminManager, GlobalDescriptor globalDescriptor, Properties customProperties, HashMapObjectInt clusterElements, HashMapIntObject idToLocalDefaultPropertiesMap, HashMapIntObject idToLocalCustomPropertiesMap, HashMapIntObject idToRuntimePropertiesMap, Properties securedProperties, Set coreServices) {
        super(1, 0, "Set global properties of " + (globalDescriptor.getComponentType() == 0 ? "manager " : "service ") + globalDescriptor.getComponentName());
        this.adminManager = adminManager;
        this.globalDescriptor = globalDescriptor;
        this.customProperties = customProperties;
        this.clusterElements = clusterElements;
        this.idToLocalDefaultPropertiesMap = idToLocalDefaultPropertiesMap;
        this.idToLocalCustomPropertiesMap = idToLocalCustomPropertiesMap;
        this.idToRuntimePropertiesMap = idToRuntimePropertiesMap;
        this.securedProperties = securedProperties;
        this.coreServices = coreServices;
        this.message = "";
    }

    public void run() {
        int[] result = new int[this.clusterElements != null ? this.clusterElements.size() + 1 : 1];
        result[0] = 1;
        String componentType = this.getComponentTypeAsString();
        String nodeType = this.getClusterNodeTypeAsString();
        int i = 0;
        Set keySet = ((Hashtable)this.securedProperties).keySet();
        HashSet serializableSet = new HashSet(keySet);
        try {
            if (this.globalDescriptor.getComponentType() == 0) {
                ClusterTreeGenerator.kernelAdministrator.updateGlobalCustomProperties(this.globalDescriptor.getComponentManagementName(), this.customProperties, this.globalDescriptor.getClusterNodeType(), serializableSet);
            } else if (this.globalDescriptor.getComponentType() == 1) {
                ClusterTreeGenerator.serviceAdministrator.updateGlobalCustomProperties(this.globalDescriptor.getComponentManagementName(), this.customProperties, this.globalDescriptor.getClusterNodeType(), serializableSet);
            } else {
                throw new RuntimeException("Unknown component type!");
            }
            this.message = this.message + "\nGlobal " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " changed.";
            location.logT(300, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " changed.");
            AdminConfig.category.logT(300, location, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " changed.");
        }
        catch (Exception ex) {
            this.status = 2;
            result[0] = -1;
            this.message = this.message + "\nGlobal " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be changed: " + ex.toString();
            location.traceThrowableT(500, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be changed: " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be changed: " + ex.getMessage());
        }
        if (this.idToLocalCustomPropertiesMap != null) {
            Enumeration enumeration = this.clusterElements.keys();
            while (enumeration.hasMoreElements()) {
                String clusterNodeName = (String)enumeration.nextElement();
                int clusterID = this.clusterElements.get((Object)clusterNodeName);
                Properties localDefaultPropertiesToUpdate = (Properties)this.idToLocalDefaultPropertiesMap.get(clusterID);
                Properties localCustomPropertiesToUpdate = (Properties)this.idToLocalCustomPropertiesMap.get(clusterID);
                Properties runtimePropertiesToChange = (Properties)this.idToRuntimePropertiesMap.get(clusterID);
                if (localDefaultPropertiesToUpdate == null) {
                    localDefaultPropertiesToUpdate = new Properties();
                }
                Iterator iterator = serializableSet.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    localDefaultPropertiesToUpdate.setProperty(key, this.securedProperties.getProperty(key));
                }
                try {
                    if (localDefaultPropertiesToUpdate != null && ((Hashtable)localDefaultPropertiesToUpdate).size() > 0) {
                        if (this.globalDescriptor.getComponentType() == 0) {
                            if (serializableSet.size() == 0) {
                                ClusterTreeGenerator.kernelAdministrator.updateLocalDefaultProperties(clusterID, this.globalDescriptor.getComponentManagementName(), localDefaultPropertiesToUpdate);
                            } else {
                                ClusterTreeGenerator.kernelAdministrator.updateLocalDefaultProperties(clusterID, this.globalDescriptor.getComponentManagementName(), localDefaultPropertiesToUpdate, serializableSet);
                            }
                        } else if (this.globalDescriptor.getComponentType() == 1) {
                            if (serializableSet.size() == 0) {
                                ClusterTreeGenerator.serviceAdministrator.updateLocalDefaultProperties(clusterID, this.globalDescriptor.getComponentManagementName(), localDefaultPropertiesToUpdate);
                            } else {
                                ClusterTreeGenerator.serviceAdministrator.updateLocalDefaultProperties(clusterID, this.globalDescriptor.getComponentManagementName(), localDefaultPropertiesToUpdate, serializableSet);
                            }
                        }
                    }
                    if (localCustomPropertiesToUpdate != null && ((Hashtable)localCustomPropertiesToUpdate).size() > 0) {
                        if (this.globalDescriptor.getComponentType() == 0) {
                            ClusterTreeGenerator.kernelAdministrator.updateLocalCustomProperties(clusterID, this.globalDescriptor.getComponentManagementName(), localCustomPropertiesToUpdate);
                        } else if (this.globalDescriptor.getComponentType() == 1) {
                            ClusterTreeGenerator.serviceAdministrator.updateLocalCustomProperties(clusterID, this.globalDescriptor.getComponentManagementName(), localCustomPropertiesToUpdate);
                        }
                    }
                    if (runtimePropertiesToChange != null && ((Hashtable)runtimePropertiesToChange).size() > 0) {
                        if (this.globalDescriptor.getComponentType() == 0) {
                            result[++i] = ClusterTreeGenerator.kernelAdministrator.notifyManagerOfPropertiesChange(clusterID, this.globalDescriptor.getComponentManagementName(), runtimePropertiesToChange) ? 1 : 0;
                        } else if (this.globalDescriptor.getComponentType() == 1) {
                            int n = result[++i] = ClusterTreeGenerator.serviceAdministrator.notifyServiceOfPropertiesChange(clusterID, this.globalDescriptor.getComponentManagementName(), runtimePropertiesToChange) ? 1 : 0;
                            if (result[i] == 0 && this.coreServices.contains(this.globalDescriptor.getComponentManagementName())) {
                                result[i] = 2;
                            }
                        }
                    } else {
                        result[++i] = 1;
                    }
                    this.message = this.message + "\nProperties of " + componentType + " " + this.globalDescriptor.getComponentName() + " changed on " + clusterNodeName + ".";
                    location.logT(300, "Properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " changed on " + clusterNodeName + ".");
                    AdminConfig.category.logT(300, location, "Properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " changed on " + clusterNodeName + ".");
                }
                catch (Exception ex) {
                    this.status = 2;
                    result[i] = -1;
                    this.message = this.message + "\nProperties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be changed on " + clusterNodeName + ": " + ex.toString();
                    location.traceThrowableT(500, "Properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be changed on " + clusterNodeName + ": " + ex.getMessage(), (Throwable)ex);
                    AdminConfig.category.logT(500, location, "Properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be changed on " + clusterNodeName + ": " + ex.getMessage());
                }
            }
        }
        this.finished(result);
    }

    public byte getComponentType() {
        return this.globalDescriptor.getComponentType();
    }

    public String getComponentTypeAsString() {
        return this.globalDescriptor.getComponentType() == 0 ? "manager" : "service";
    }

    public String getClusterNodeTypeAsString() {
        return this.globalDescriptor.getClusterNodeType() == 1 ? "dispatcher" : (this.globalDescriptor.getClusterNodeType() == 2 ? "server" : "");
    }

    public String getComponentName() {
        return this.globalDescriptor.getComponentName();
    }

    public String getComponentManagementName() {
        return this.globalDescriptor.getComponentManagementName();
    }

    public byte getClusterNodeType() {
        return this.globalDescriptor.getClusterNodeType();
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public HashMapObjectInt getClusterElementsToUpdate() {
        return this.clusterElements;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

