/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.Properties;

public class RestoreServicePropertiesTask
extends InfiniteTaskItem
implements Runnable {
    private AdminManager manager;
    private String serviceName;
    private ServiceNodeDescriptor serviceNodeDescriptor;
    private String message;
    private String serviceDisplayName;
    private String clusterNodeDisplayName;
    private String[] keysToChange;
    private Properties runtimePropertiesToChange;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$RestoreServicePropertiesTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$RestoreServicePropertiesTask = RestoreServicePropertiesTask.class$("com.sap.engine.services.adminadapter.gui.tasks.RestoreServicePropertiesTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$RestoreServicePropertiesTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$RestoreServicePropertiesTask;

    public RestoreServicePropertiesTask(AdminManager manager, ServiceNodeDescriptor serviceNodeDescriptor, String clusterNodeDisplayName, String serviceDisplayName, String[] keysToChange, Properties runtimePropertiesToChange) {
        super(1, 0, "Restore properties of service " + serviceDisplayName + " on " + clusterNodeDisplayName);
        this.manager = manager;
        this.serviceName = serviceNodeDescriptor.getServiceDescriptor().getName();
        this.serviceDisplayName = serviceDisplayName;
        this.clusterNodeDisplayName = clusterNodeDisplayName;
        this.serviceNodeDescriptor = serviceNodeDescriptor;
        this.keysToChange = keysToChange;
        this.runtimePropertiesToChange = runtimePropertiesToChange;
        this.message = "Cluster node ID : " + serviceNodeDescriptor.getServiceDescriptor().getClusterID();
    }

    public void run() {
        int result = -1;
        try {
            if (this.keysToChange != null) {
                ClusterTreeGenerator.serviceAdministrator.restoreLocalProperties(this.serviceNodeDescriptor.getServiceDescriptor().getClusterID(), this.serviceName, this.keysToChange);
            }
            if ((result = this.runtimePropertiesToChange != null && ((Hashtable)this.runtimePropertiesToChange).size() > 0 ? (ClusterTreeGenerator.serviceAdministrator.notifyServiceOfPropertiesChange(this.serviceNodeDescriptor.getServiceDescriptor().getClusterID(), this.serviceName, this.runtimePropertiesToChange) ? 1 : 0) : 1) == 0 && this.serviceNodeDescriptor.getServiceDescriptor().isCore()) {
                result = 2;
            }
            this.message = this.message + "\nSuccessful !";
        }
        catch (Exception ex) {
            result = -1;
            this.status = 2;
            this.message = ex.toString();
            location.traceThrowableT(500, "Error occured while trying to change properties of service " + this.serviceDisplayName + ": " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Error occured while trying to restore properties of service " + this.serviceDisplayName);
        }
        this.finished(new Integer(result));
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    public int getClusterID() {
        return this.serviceNodeDescriptor.getServiceDescriptor().getClusterID();
    }

    public String getClusterNodeDisplayName() {
        return this.clusterNodeDisplayName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

