/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.Properties;

public class RestoreManagerPropertiesTask
extends InfiniteTaskItem
implements Runnable {
    private AdminManager manager;
    private String managerName;
    private ManagerNodeDescriptor managerNodeDescriptor;
    private String clusterNodeDisplayName;
    private String message;
    private String[] keysToChange;
    private Properties runtimePropertiesToChange;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$RestoreManagerPropertiesTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$RestoreManagerPropertiesTask = RestoreManagerPropertiesTask.class$("com.sap.engine.services.adminadapter.gui.tasks.RestoreManagerPropertiesTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$RestoreManagerPropertiesTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$RestoreManagerPropertiesTask;

    public RestoreManagerPropertiesTask(AdminManager manager, ManagerNodeDescriptor managerNodeDescriptor, String clusterNodeDisplayName, String[] keysToChange, Properties runtimePropertiesToChange) {
        super(1, 0, "Reset properties of manager " + managerNodeDescriptor.getManagerName() + " on " + clusterNodeDisplayName);
        this.manager = manager;
        this.managerName = managerNodeDescriptor.getManagerName();
        this.managerNodeDescriptor = managerNodeDescriptor;
        this.clusterNodeDisplayName = clusterNodeDisplayName;
        this.keysToChange = keysToChange;
        this.runtimePropertiesToChange = runtimePropertiesToChange;
        this.message = "Cluster node ID : " + managerNodeDescriptor.getClusterID();
    }

    public void run() {
        int result = -1;
        try {
            if (this.keysToChange != null) {
                ClusterTreeGenerator.kernelAdministrator.restoreLocalProperties(this.managerNodeDescriptor.getClusterID(), this.managerName, this.keysToChange);
            }
            result = ((Hashtable)this.runtimePropertiesToChange).size() > 0 ? (ClusterTreeGenerator.kernelAdministrator.notifyManagerOfPropertiesChange(this.managerNodeDescriptor.getClusterID(), this.managerName, this.runtimePropertiesToChange) ? 1 : 0) : 1;
            this.message = this.message + "\nSuccessful !";
        }
        catch (Exception ex) {
            result = -1;
            this.status = 2;
            this.message = ex.toString();
            location.traceThrowableT(500, "Error occured while trying to restore properties of manager " + this.managerName + " on " + this.clusterNodeDisplayName + ": " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Error occured while trying to restore properties of manager " + this.managerName + " on " + this.clusterNodeDisplayName);
        }
        if (result == 1) {
            this.message = this.message + "\nProperties of " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " restored.";
            location.logT(300, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " restored.");
            AdminConfig.category.logT(300, location, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " restored.");
        } else if (result == 0) {
            this.message = this.message + "\nProperties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " restored, but restart is needed to take effect.";
            location.logT(500, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " restored, but restart is needed to take effect.");
            AdminConfig.category.logT(500, location, "Properties of manager " + this.managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " restored, but restart is needed to take effect.");
        }
        this.finished(new Integer(result));
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public int getClusterID() {
        return this.managerNodeDescriptor.getClusterID();
    }

    public String getManagerName() {
        return this.managerNodeDescriptor.getManagerName();
    }

    public String getClusterNodeDisplayName() {
        return this.clusterNodeDisplayName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

