/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.lib.util.HashMapObjectInt;
import com.sap.engine.services.adminadapter.descriptor.GlobalDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;
import java.util.Properties;

public class RestoreGlobalPropertiesTask
extends InfiniteTaskItem
implements Runnable {
    private AdminManager adminManager;
    private GlobalDescriptor globalDescriptor;
    private String message;
    private String[] globalCustomKeysToDelete;
    private Properties localCustomPropertiesToUpdate;
    private HashMapObjectInt clusterElementsToUpdate;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$RestoreGlobalPropertiesTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$RestoreGlobalPropertiesTask = RestoreGlobalPropertiesTask.class$("com.sap.engine.services.adminadapter.gui.tasks.RestoreGlobalPropertiesTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$RestoreGlobalPropertiesTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$RestoreGlobalPropertiesTask;

    public RestoreGlobalPropertiesTask(AdminManager adminManager, GlobalDescriptor globalDescriptor, String[] globalCustomKeysToDelete, Properties localCustomPropertiesToUpdate, HashMapObjectInt clusterElementsToUpdate) {
        super(1, 0, "Restore global properties of " + globalDescriptor.getComponentName());
        this.adminManager = adminManager;
        this.globalDescriptor = globalDescriptor;
        this.globalCustomKeysToDelete = globalCustomKeysToDelete;
        this.localCustomPropertiesToUpdate = localCustomPropertiesToUpdate;
        this.clusterElementsToUpdate = clusterElementsToUpdate;
        this.message = "";
    }

    public void run() {
        int[] result = new int[this.clusterElementsToUpdate != null ? this.clusterElementsToUpdate.size() + 1 : 1];
        result[0] = 1;
        String componentType = this.getComponentTypeAsString();
        String nodeType = this.getClusterNodeTypeAsString();
        boolean i = false;
        if (this.globalDescriptor.getComponentType() == 0) {
            try {
                ClusterTreeGenerator.kernelAdministrator.restoreGlobalProperties(this.globalDescriptor.getComponentManagementName(), this.globalCustomKeysToDelete, this.globalDescriptor.getClusterNodeType());
                this.message = this.message + "\nGlobal " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " restored.";
                location.logT(300, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " restored.");
                AdminConfig.category.logT(300, location, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " restored.");
            }
            catch (Exception ex) {
                this.status = 2;
                result[0] = -1;
                this.message = this.message + "\nGlobal " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be restored: " + ex.toString();
                location.traceThrowableT(500, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be restored: " + ex.getMessage(), (Throwable)ex);
                AdminConfig.category.logT(500, location, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be restored: " + ex.getMessage());
            }
        } else if (this.globalDescriptor.getComponentType() == 1) {
            try {
                ClusterTreeGenerator.serviceAdministrator.restoreGlobalProperties(this.globalDescriptor.getComponentManagementName(), this.globalCustomKeysToDelete, this.globalDescriptor.getClusterNodeType());
                this.message = this.message + "\nGlobal " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " restored.";
                location.logT(300, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " restored.");
                AdminConfig.category.logT(300, location, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " restored.");
            }
            catch (Exception ex) {
                this.status = 2;
                result[0] = -1;
                this.message = this.message + "\nGlobal " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be restored: " + ex.toString();
                location.traceThrowableT(500, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be restored: " + ex.getMessage(), (Throwable)ex);
                AdminConfig.category.logT(500, location, "Global " + nodeType + " properties of " + componentType + " " + this.globalDescriptor.getComponentName() + " could not be restored: " + ex.getMessage());
            }
        }
        this.finished(result);
    }

    public String getClusterNodeTypeAsString() {
        return this.globalDescriptor.getClusterNodeType() == 1 ? "dispatcher" : (this.globalDescriptor.getClusterNodeType() == 2 ? "server" : "");
    }

    public String getComponentTypeAsString() {
        return this.globalDescriptor.getComponentType() == 0 ? "manager" : "service";
    }

    public byte getClusterNodeType() {
        return this.globalDescriptor.getClusterNodeType();
    }

    public byte getComponentType() {
        return this.globalDescriptor.getComponentType();
    }

    public String getComponentName() {
        return this.globalDescriptor.getComponentName();
    }

    public String getComponentManagementName() {
        return this.globalDescriptor.getComponentManagementName();
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public HashMapObjectInt getClusterElementsToUpdate() {
        return this.clusterElementsToUpdate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

