/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.tc.logging.Location;

public class RebootServiceTask
extends InfiniteTaskItem
implements Runnable {
    private int serverID;
    private String serviceName;
    private String serviceDisplayName;
    private String message;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$RebootServiceTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$RebootServiceTask = RebootServiceTask.class$("com.sap.engine.services.adminadapter.gui.tasks.RebootServiceTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$RebootServiceTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$RebootServiceTask;

    public RebootServiceTask(String serviceName, String serviceDisplayName, int serverID) {
        super(1, 0, "Reboot service " + serviceDisplayName);
        this.serviceName = serviceName;
        this.serviceDisplayName = serviceDisplayName;
        this.serverID = serverID;
        this.message = "Cluster node ID : " + serverID;
    }

    public void run() {
        try {
            ClusterTreeGenerator.serviceAdministrator.stopService(this.serverID, this.serviceName);
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException inEx) {
                // empty catch block
            }
            ClusterTreeGenerator.serviceAdministrator.startService(this.serverID, this.serviceName);
            this.message = this.message + "\nSuccessful !";
        }
        catch (Exception ex) {
            this.status = 2;
            this.message = ex.toString();
            location.traceThrowableT(500, "Error while rebooting service " + this.serviceDisplayName + ": " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Error while rebooting service " + this.serviceDisplayName);
        }
        this.finished();
        location.logT(300, this.serviceDisplayName + " rebooted.");
        AdminConfig.category.logT(300, location, this.serviceDisplayName + " rebooted.");
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

