/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.AdminViewManager;
import com.sap.engine.services.adminadapter.gui.tasks.EventQueueTask;
import com.sap.engine.services.rmi_p4.P4ConnectionException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.tc.logging.Location;
import java.awt.EventQueue;

public class LogoutTask
extends InfiniteTaskItem
implements Runnable {
    private AdminViewManager manager;
    private String message;
    private P4ObjectBroker broker = null;
    private boolean isExit = false;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$LogoutTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$LogoutTask = LogoutTask.class$("com.sap.engine.services.adminadapter.gui.tasks.LogoutTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$LogoutTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$LogoutTask;

    public LogoutTask(AdminViewManager manager, P4ObjectBroker broker, boolean isExit) {
        super(1, 0, "Disconnecting");
        this.manager = manager;
        this.broker = broker;
        this.isExit = isExit;
        this.message = "";
    }

    public void run() {
        this.disconnectAction();
    }

    private void disconnectAction() {
        try {
            try {
                if (this.isExit) {
                    if (this.manager.loginContext != null) {
                        try {
                            this.manager.loginContext.logout();
                        }
                        catch (P4ConnectionException e) {
                            location.traceThrowableT(500, "Error while disconnecting Administrator: " + e.getMessage(), (Throwable)e);
                            AdminConfig.category.logT(500, location, "Error while disconnecting Administrator: " + this.message + " The reason can be there is no running server.");
                        }
                    }
                    this.broker.close();
                    this.manager.closePerformed();
                } else {
                    this.manager.disconnectPerformed(false, null);
                    if (this.manager.loginContext != null) {
                        this.manager.loginContext.logout();
                    }
                }
                EventQueue.invokeLater(new EventQueueTask());
                this.message = this.message + "\nSuccessful !";
                this.finished();
                location.logT(300, "Administrator disconnected.");
                AdminConfig.category.logT(300, location, "Administrator disconnected.");
            }
            catch (Exception ex) {
                this.status = 2;
                this.name = "Error while disconnecting";
                this.message = ex.toString();
                location.traceThrowableT(500, "Error while disconnecting Administrator: " + this.message, (Throwable)ex);
                AdminConfig.category.logT(500, location, "Error while disconnecting Administrator: " + this.message);
                Object var3_4 = null;
                this.manager.stateChanged(0);
            }
            Object var3_3 = null;
            this.manager.stateChanged(0);
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.manager.stateChanged(0);
            throw throwable;
        }
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public void finished() {
        this.name = "Disconnected";
        super.finished();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

