/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.connect.PasswordChangeDialog;
import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.lib.security.LoginExceptionDetails;
import com.sap.engine.lib.security.PasswordChangeCallback;
import com.sap.engine.services.adminadapter.gui.AdminViewManager;
import com.sap.engine.services.adminadapter.gui.tasks.EventQueueTask;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.security.exceptions.BaseLoginException;
import com.sap.engine.services.security.remote.login.RemoteLoginContext;
import com.sap.exception.IBaseException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.swing.JOptionPane;

public class LoginTask
extends InfiniteTaskItem
implements Runnable,
CallbackHandler {
    private AdminViewManager manager;
    private String userName;
    private String password;
    private String url;
    private int port;
    private Properties brokerProperties;
    private String message;
    private P4ObjectBroker broker = null;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$LoginTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$LoginTask = LoginTask.class$("com.sap.engine.services.adminadapter.gui.tasks.LoginTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$LoginTask));
    private static final Category category = EditorViewManager.category;
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$LoginTask;

    public LoginTask(AdminViewManager manager, String userName, String password, String url, int port, Properties properties) {
        super(1, 0, "Connecting to " + url);
        this.manager = manager;
        this.userName = userName;
        this.password = password;
        this.url = url;
        this.port = port;
        this.brokerProperties = new Properties();
        String transportLayer = properties.getProperty("TransportLayerQueue", "None");
        this.brokerProperties.setProperty("TransportLayerQueue", transportLayer);
        this.brokerProperties.setProperty("SocketPort", String.valueOf(port));
        if (transportLayer.equals("httptunneling") || transportLayer.equals("https")) {
            String proxyPort = properties.getProperty("HTTP_Port", String.valueOf(port));
            String proxyHost = properties.getProperty("HTTP_Host", url);
            this.brokerProperties.setProperty("HTTP_Port", proxyPort);
            this.brokerProperties.setProperty("HTTP_Host", proxyHost);
            this.brokerProperties.setProperty("Port", String.valueOf(port));
        } else if (transportLayer.equals("SAPRouter")) {
            this.brokerProperties.setProperty("SAPRouterString", properties.getProperty("SAPRouterString"));
        }
        this.message = "Host : " + url + "\n" + "User name : " + userName + "\n" + "Port : " + port + "\n" + "Layer : " + transportLayer;
    }

    public void run() {
        if (this.broker == null) {
            this.connectAction();
        }
    }

    private void connectAction() {
        long time = -1L;
        InitialContext ctx = null;
        try {
            this.broker = P4ObjectBroker.init((Properties)this.brokerProperties);
            P4ObjectBroker.props = this.brokerProperties;
            ((Hashtable)this.brokerProperties).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            ((Hashtable)this.brokerProperties).put("java.naming.provider.url", this.url + ":" + String.valueOf(this.port));
            if (location.beDebug()) {
                time = System.currentTimeMillis();
            }
            this.manager.loginContext = new RemoteLoginContext((CallbackHandler)this, this.brokerProperties.getProperty("TransportLayerQueue", ""), this.url, this.port);
            if (location.beDebug()) {
                location.debugT("Creation of remote login context took : " + (System.currentTimeMillis() - time) + " ms");
                time = System.currentTimeMillis();
            }
            this.manager.loginContext.login();
            if (location.beDebug()) {
                location.debugT("Log into the server took : " + (System.currentTimeMillis() - time) + " ms");
                time = System.currentTimeMillis();
            }
            ctx = new InitialContext(this.brokerProperties);
            if (location.beDebug()) {
                location.debugT("Creation of InitialContext took : " + (System.currentTimeMillis() - time) + " ms");
            }
            EventQueue.invokeLater(new EventQueueTask());
            this.manager.connectPerformed(ctx, this.broker, this);
        }
        catch (Exception ex) {
            String displayableMessage;
            boolean causeKnown;
            block28: {
                Throwable cause;
                Throwable wrappedThrowable;
                block27: {
                    causeKnown = false;
                    displayableMessage = null;
                    if (!(ex instanceof LoginExceptionDetails)) break block27;
                    byte cause2 = ((LoginExceptionDetails)ex).getExceptionCause();
                    switch (cause2) {
                        case 0: {
                            this.message = "User authentication failed";
                            causeKnown = true;
                            break;
                        }
                        case 1: {
                            this.message = "Password has expired";
                            causeKnown = true;
                            break;
                        }
                        case 2: {
                            this.message = "User not in validity date";
                            causeKnown = true;
                            break;
                        }
                        case 3: {
                            this.message = "User locked";
                            causeKnown = true;
                            break;
                        }
                        case 4: {
                            this.message = "Certificate is not accepted";
                            causeKnown = true;
                            break;
                        }
                        case 5: {
                            this.message = "User for certificate could not be found";
                            causeKnown = true;
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            this.message = "User SAP* is active, no other users can logon";
                            causeKnown = true;
                            break;
                        }
                        default: {
                            Throwable t;
                            if (ex instanceof BaseLoginException && ((t = ((BaseLoginException)ex).getCause()) instanceof P4IOException || ex instanceof LoginException)) {
                                this.message = t.getMessage();
                                if (this.message != null) {
                                    displayableMessage = this.prepareMessage(this.message);
                                    causeKnown = true;
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break block28;
                }
                if (ex instanceof UndeclaredThrowableException && (wrappedThrowable = ((UndeclaredThrowableException)ex).getUndeclaredThrowable()) instanceof IBaseException && (cause = ((IBaseException)wrappedThrowable).getCause()) != null) {
                    String causeMessage = cause.getMessage();
                    if (this.message != null) {
                        displayableMessage = this.prepareMessage(causeMessage);
                        causeKnown = true;
                    }
                }
            }
            try {
                this.broker.close();
            }
            catch (Exception exception) {
                location.traceThrowableT(500, "Error while trying to close connection to " + this.url + ": " + exception.getMessage(), (Throwable)exception);
            }
            this.manager.stateChanged(0);
            this.name = "Error while connecting";
            this.status = 2;
            if (!causeKnown) {
                this.message = ex.toString();
            } else {
                if (displayableMessage == null) {
                    displayableMessage = this.message;
                }
                JOptionPane.showMessageDialog(this.manager.getFrame(), displayableMessage, "Unable to logon to " + this.url, 0);
            }
            location.traceThrowableT(500, "Error while trying to login to " + this.url + ": " + ex.getMessage(), (Throwable)ex);
            category.logT(500, location, "Error while trying to login to " + this.url + ": " + ex.getMessage());
            return;
        }
        this.manager.stateChanged(2);
        this.message = this.message + "\nSuccessful !";
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    public void handle(Callback[] acallback) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < acallback.length) {
            if (acallback[i] instanceof NameCallback) {
                ((NameCallback)acallback[i]).setName(this.userName);
            } else if (acallback[i] instanceof PasswordChangeCallback) {
                this.pause();
                char[] newPassword = null;
                Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
                while (newPassword == null) {
                    PasswordChangeDialog dialog = new PasswordChangeDialog(this.manager.getFrame(), this.password.toCharArray());
                    dialog.pack();
                    Dimension dialogDimension = dialog.getSize();
                    dialog.setLocation((screenDimension.width - dialogDimension.width) / 2, (screenDimension.height - dialogDimension.height) / 2);
                    dialog.show();
                    if (dialog.isCanceled()) {
                        throw new IOException("New password was not provided by user!");
                    }
                    newPassword = dialog.getNewPassword();
                }
                ((PasswordChangeCallback)acallback[i]).setPassword(newPassword);
                this.resume();
            } else if (acallback[i] instanceof PasswordCallback) {
                ((PasswordCallback)acallback[i]).setPassword(this.password.toCharArray());
            } else {
                throw new UnsupportedCallbackException(acallback[i]);
            }
            ++i;
        }
    }

    private String prepareMessage(String message) {
        int maxLineLength = 50;
        if (message.length() > maxLineLength && message.indexOf(" ") != -1) {
            StringBuffer result = new StringBuffer(0);
            StringTokenizer s = new StringTokenizer(message, " ");
            int lineLength = 0;
            while (s.hasMoreTokens()) {
                String nextToken = s.nextToken();
                result.append(" " + nextToken);
                if ((lineLength += nextToken.length()) <= maxLineLength) continue;
                result.append("\n");
                lineLength = 0;
            }
            return result.toString();
        }
        return message;
    }

    public void finished() {
        this.name = "Connected to " + this.url;
        super.finished();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

