/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.tasks;

import com.sap.engine.gui.status.InfiniteTaskItem;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.node.ConversionUtil;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.management.ObjectName;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InvokeMBeanOperationTask
extends InfiniteTaskItem
implements Runnable {
    private ObjectName objectName;
    private String operationName;
    private Object[] params;
    private String[] signature;
    private String message;
    private JFrame frame;
    private String returnType;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$tasks$InvokeMBeanOperationTask == null ? (class$com$sap$engine$services$adminadapter$gui$tasks$InvokeMBeanOperationTask = InvokeMBeanOperationTask.class$("com.sap.engine.services.adminadapter.gui.tasks.InvokeMBeanOperationTask")) : class$com$sap$engine$services$adminadapter$gui$tasks$InvokeMBeanOperationTask));
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$tasks$InvokeMBeanOperationTask;

    public InvokeMBeanOperationTask(ObjectName objectName, String operationName, Object[] params, String[] signature, String returnType, JFrame frame) {
        super(1, 0, "Invoke " + operationName + " operation");
        this.objectName = objectName;
        this.operationName = operationName;
        this.params = params;
        this.signature = signature;
        this.returnType = returnType;
        this.frame = frame;
        this.message = "ObjectName : " + objectName;
    }

    public void run() {
        Object result = null;
        try {
            result = ClusterTreeGenerator.defaultMBeanAdministrator.invoke(this.objectName, this.operationName, this.params, this.signature);
            this.message = this.message + "\nSuccessful!";
        }
        catch (Exception ex) {
            this.status = 2;
            this.message = ex.toString();
            location.traceThrowableT(500, "Error occured while trying to invoke operation " + this.operationName + " on MBean with ObjectName " + this.objectName + ": " + ex.getMessage(), (Throwable)ex);
            AdminConfig.category.logT(500, location, "Error occured while trying to invoke operation " + this.operationName + " on MBean with ObjectName " + this.objectName + ": " + ex.getMessage());
        }
        this.finished(result);
        if (result != null) {
            this.displayResult(result);
        }
    }

    public String getAdditionalInfo() {
        return this.message;
    }

    private void displayResult(Object result) {
        if (result instanceof Number || this.returnType.equals("boolean") || this.returnType.equals("char") || result instanceof String) {
            this.displaySingleValue(result.toString());
        } else if (result.getClass().isArray()) {
            this.displayArray(result);
        }
    }

    private void displaySingleValue(String value) {
        JOptionPane.showMessageDialog(this.frame, "Operation " + this.operationName + " return value: " + value, "Operation " + this.operationName + " result", 1);
    }

    private void displayResultArray(String[] array) {
        final JDialog resultDialog = new JDialog((Frame)this.frame, "Operation " + this.operationName + " result");
        final JButton okButton = new JButton("OK");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(okButton);
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        JList<String> resultList = new JList<String>(array);
        JScrollPane scrollPane = new JScrollPane(resultList);
        scrollPane.setPreferredSize(new Dimension(220, 200));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == okButton) {
                    ((Component)resultDialog).setVisible(false);
                }
            }
        });
        resultDialog.getContentPane().setLayout(new BorderLayout());
        resultDialog.getContentPane().add((Component)scrollPane, "Center");
        resultDialog.getContentPane().add((Component)buttonPanel, "South");
        resultDialog.pack();
        Dimension dialogDimension = resultDialog.getSize();
        ((Component)resultDialog).setLocation((screenDimension.width - dialogDimension.width) / 2, (screenDimension.height - dialogDimension.height) / 2);
        ((Component)resultDialog).setVisible(true);
    }

    private void displayArray(Object result) {
        if (ConversionUtil.getArrayDepth(this.returnType) == 1) {
            String arrayType = ConversionUtil.getArrayType(this.returnType);
            if (arrayType.equals("int")) {
                this.displayResultArray(ConversionUtil.getStringArray((int[])result));
            } else if (arrayType.equals("float")) {
                this.displayResultArray(ConversionUtil.getStringArray((float[])result));
            } else if (arrayType.equals("long")) {
                this.displayResultArray(ConversionUtil.getStringArray((long[])result));
            } else if (arrayType.equals("double")) {
                this.displayResultArray(ConversionUtil.getStringArray((double[])result));
            } else if (arrayType.equals("char")) {
                this.displayResultArray(ConversionUtil.getStringArray((char[])result));
            } else if (arrayType.equals("byte")) {
                this.displayResultArray(ConversionUtil.getStringArray((byte[])result));
            } else if (arrayType.equals("short")) {
                this.displayResultArray(ConversionUtil.getStringArray((short[])result));
            } else if (arrayType.equals("boolean")) {
                this.displayResultArray(ConversionUtil.getStringArray((boolean[])result));
            } else if (result instanceof String[]) {
                this.displayResultArray((String[])result);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

