/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.adminadapter.descriptor.ClusterElementNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.ImageHolder;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public final class TreeRenderer
extends DefaultTreeCellRenderer {
    public TreeRenderer() {
        LookAndFeelHandler.add((Component)this);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof MBeanTreeNode) {
            MBeanTreeNode node = (MBeanTreeNode)value;
            block0 : switch (node.getType()) {
                case 0: {
                    this.setText(node.getDescriptiveName());
                    this.setToolTipText(null);
                    this.setIcon(ImageHolder.clusterIcon);
                    break;
                }
                case 1: {
                    this.setText(TreeRenderer.generateClusterNodeText((ClusterElementNodeDescriptor)node.getUserObject()));
                    if (((ClusterElementNodeDescriptor)node.getUserObject()).getType().equals("Dispatcher")) {
                        this.setIcon(((ClusterElementNodeDescriptor)node.getUserObject()).isDebugMode() ? ImageHolder.dispatcherDebugIcon : ImageHolder.dispatcherIcon);
                    } else {
                        this.setIcon(((ClusterElementNodeDescriptor)node.getUserObject()).isDebugMode() ? ImageHolder.serverDebugIcon : ImageHolder.serverIcon);
                    }
                    this.setToolTipText(TreeRenderer.generateToolTipText((ClusterElementNodeDescriptor)node.getUserObject()));
                    break;
                }
                case 6: {
                    this.setText(node.getDescriptiveName());
                    this.setToolTipText(null);
                    String adminPath = node.getPath();
                    if (adminPath.indexOf("$GROUP_Services") != -1) {
                        this.setIcon(ImageHolder.servicesGrIcon);
                        break;
                    }
                    if (adminPath.indexOf("$GROUP_Interfaces") != -1) {
                        this.setIcon(ImageHolder.interfacesGrIcon);
                        break;
                    }
                    if (adminPath.indexOf("$GROUP_Libraries") != -1) {
                        this.setIcon(ImageHolder.librariesGrIcon);
                        break;
                    }
                    this.setIcon(ImageHolder.aMethodRed);
                    break;
                }
                case 3: {
                    this.setText(node.getDescriptiveName());
                    this.setToolTipText(null);
                    byte status = ((ServiceNodeDescriptor)node.getUserObject()).getServiceDescriptor().getStatus();
                    switch (status) {
                        case 2: {
                            this.setIcon(ImageHolder.serviceNAIcon);
                            break block0;
                        }
                        case 4: {
                            this.setIcon(ImageHolder.serviceStopIcon);
                            break block0;
                        }
                        case 5: {
                            this.setIcon(ImageHolder.serviceRunIcon);
                            break block0;
                        }
                    }
                    this.setIcon(ImageHolder.aServiceIcon);
                    break;
                }
                case 2: {
                    this.setText(node.getDescriptiveName());
                    this.setToolTipText(null);
                    this.setIcon(ImageHolder.managersGrIcon);
                    break;
                }
                case 4: {
                    this.setText(node.getDescriptiveName());
                    this.setToolTipText(null);
                    this.setIcon(ImageHolder.libraryIcon);
                    break;
                }
                case 5: {
                    this.setText(node.getDescriptiveName());
                    this.setToolTipText(null);
                    this.setIcon(ImageHolder.interfaceIcon);
                    break;
                }
                case -1: {
                    this.setText(node.getDescriptiveName());
                    this.setToolTipText(null);
                    this.setIcon(ImageHolder.aMethodBlue);
                }
            }
        } else if (value instanceof ManagerNodeDescriptor) {
            this.setText(((ManagerNodeDescriptor)value).getManagerName());
            this.setToolTipText(null);
            this.setIcon(ImageHolder.managerIcon);
        }
        return this;
    }

    public void updateUI() {
        super.updateUI();
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    private static String generateClusterNodeText(ClusterElementNodeDescriptor clusterElementNodeDescriptor) {
        String hostName = clusterElementNodeDescriptor.getHostName();
        return clusterElementNodeDescriptor.getName() + " (" + (hostName != null ? hostName : clusterElementNodeDescriptor.getHost()) + ")";
    }

    private static String generateToolTipText(ClusterElementNodeDescriptor clusterElementNodeDescriptor) {
        return "<html><font size=2>Name: " + clusterElementNodeDescriptor.getName() + "<br>" + "Type: " + clusterElementNodeDescriptor.getType() + "<br>" + "Kernel Version: " + clusterElementNodeDescriptor.getKernelVersion() + "<br>" + "ID: " + clusterElementNodeDescriptor.getId() + "<br>" + "Host IP: " + clusterElementNodeDescriptor.getHost() + "<br>" + "Host Name: " + clusterElementNodeDescriptor.getHostName() + "<br>" + "Debuggable: " + (clusterElementNodeDescriptor.isDebuggable() ? "Yes" : "No") + "<br>" + "Debug Mode: " + (clusterElementNodeDescriptor.isDebugMode() ? "On" : "Off") + "</html>";
    }
}

