/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.CToolBarSeparator;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.status.ErrorTaskItem;
import com.sap.engine.gui.status.InfoTaskItem;
import com.sap.engine.gui.status.StatusInfo;
import com.sap.engine.interfaces.visual_administration.AdminEvent;
import com.sap.engine.interfaces.visual_administration.AdminEventListener;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.RuntimeControl;
import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.adminadapter.descriptor.ClusterElementNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.exception.AdminException;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertiesEditor;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertySheet;
import com.sap.engine.services.adminadapter.gui.ImageHolder;
import com.sap.engine.services.adminadapter.gui.descriptors.AdditionalServiceInfoPanel;
import com.sap.engine.services.adminadapter.gui.tasks.EventQueueTask;
import com.sap.engine.services.adminadapter.impl.Util;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServiceNodeView
extends JPanel
implements ActionListener,
ChangeListener,
EditorViewManager {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$adminadapter$gui$node$ServiceNodeView == null ? (class$com$sap$engine$services$adminadapter$gui$node$ServiceNodeView = ServiceNodeView.class$("com.sap.engine.services.adminadapter.gui.node.ServiceNodeView")) : class$com$sap$engine$services$adminadapter$gui$node$ServiceNodeView));
    public static final String ID_NAME = "SAPJ2EEEngineVisualAdministrator";
    protected JTabbedPane tab = new JTabbedPane();
    protected AdminManager manager;
    private ExtendedPropertiesEditor propertiesEditor;
    private AdditionalServiceInfoPanel additionalInfoPanel;
    protected VisualRuntimeControl runtimeControl;
    protected MBeanTreeNode mBeanTreeNode;
    protected AdminFrameView frame;
    private final JButton setPropsBtn = new JButton();
    private final JButton resetPropsBtn = new JButton();
    private final JButton resetDefaultLocalPropsBtn = new JButton();
    private final JButton defaultPropsBtn = new JButton();
    protected JToolBar toolBar;
    protected JMenuBar menuBar;
    protected JMenu addedMenu;
    protected Map staticControls;
    protected boolean currentControlStatic = false;
    private String clusterNodeDisplayName;
    private Map adminEventListeners;
    private final String CONNECTION_LISTENERS_KEY = "Conection Listeners";
    static /* synthetic */ Class class$com$sap$engine$services$adminadapter$gui$node$ServiceNodeView;

    public ServiceNodeView(AdminFrameView frame, AdminManager manager, JToolBar toolBar, JMenuBar menuBar) {
        this.frame = frame;
        this.manager = manager;
        this.toolBar = toolBar;
        this.menuBar = menuBar;
        this.initView();
    }

    protected void initView() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.tab, "Center");
        this.additionalInfoPanel = new AdditionalServiceInfoPanel();
        this.tab.addChangeListener(this);
        Dimension dim = new Dimension(24, 24);
        this.setPropsBtn.setPreferredSize(dim);
        this.setPropsBtn.setToolTipText("Save Properties");
        this.setPropsBtn.addActionListener(this);
        this.setPropsBtn.setIcon(ImageHolder.setIcon);
        this.resetPropsBtn.setPreferredSize(dim);
        this.resetPropsBtn.setToolTipText("Reset Properties");
        this.resetPropsBtn.addActionListener(this);
        this.resetPropsBtn.setIcon(ImageHolder.resetIcon);
        this.resetDefaultLocalPropsBtn.setPreferredSize(dim);
        this.resetDefaultLocalPropsBtn.setToolTipText("Reset Default Properties");
        this.resetDefaultLocalPropsBtn.addActionListener(this);
        this.resetDefaultLocalPropsBtn.setIcon(ImageHolder.clearIcon);
        this.defaultPropsBtn.setPreferredSize(dim);
        this.defaultPropsBtn.setToolTipText("Show Details");
        this.defaultPropsBtn.addActionListener(this);
        this.defaultPropsBtn.setIcon(ImageHolder.detailsOn);
        LookAndFeelHandler.add((Component)this.setPropsBtn);
        LookAndFeelHandler.add((Component)this.resetPropsBtn);
        LookAndFeelHandler.add((Component)this.resetDefaultLocalPropsBtn);
        LookAndFeelHandler.add((Component)this.defaultPropsBtn);
        LookAndFeelHandler.add((Component)this);
        this.staticControls = new HashMap();
    }

    public void deselectNode(MBeanTreeNode mBeanTreeNode) {
        this.mBeanTreeNode = mBeanTreeNode;
        if (mBeanTreeNode.getType() == 3) {
            this.deselectSingleService(mBeanTreeNode);
        } else {
            this.deselectGroupNode(mBeanTreeNode);
        }
        this.clusterNodeDisplayName = null;
    }

    protected void deselectSingleService(MBeanTreeNode node) {
        if (this.adminEventListeners != null) {
            this.fireAdminEvent(new AdminEvent(this.mBeanTreeNode.getDescriptiveName(), 1));
        }
        if (!this.currentControlStatic && this.manager.isConnected()) {
            this.freeRuntimeControlResources(false);
        } else {
            this.runtimeControl = null;
            this.currentControlStatic = false;
        }
        if (this.propertiesEditor != null) {
            Properties props = this.propertiesEditor.getFirstProperties();
            if (!Util.compareProperties(props, ((ServiceNodeDescriptor)node.getUserObject()).getRuntimeProperties())) {
                ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)node.getUserObject();
                this.setServiceProperties(serviceNodeDescriptor, this.clusterNodeDisplayName, node.getDescriptiveName(), props, true);
            }
            this.propertiesEditor = null;
        }
        this.additionalInfoPanel.reset();
        this.mBeanTreeNode = null;
        this.toolBar.removeAll();
        if (this.addedMenu != null) {
            this.menuBar.remove(this.addedMenu);
            this.addedMenu = null;
            this.menuBar.validate();
            this.menuBar.repaint();
        }
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    protected void deselectGroupNode(MBeanTreeNode mBeanTreeNode) {
        this.mBeanTreeNode = null;
        this.toolBar.removeAll();
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    public void selectNode(MBeanTreeNode mBeanTreeNode) {
        this.clusterNodeDisplayName = this.manager.getParentClusterNode(mBeanTreeNode).getDescriptiveName();
        if (mBeanTreeNode.getType() == 3) {
            this.selectSingleService(mBeanTreeNode);
        } else {
            this.selectGroupNode(mBeanTreeNode);
        }
    }

    protected void selectSingleService(MBeanTreeNode mBeanTreeNode) {
        ServiceNodeDescriptor serviceNodeDescriptor;
        String error;
        long overallTime;
        block20: {
            if (this.adminEventListeners != null) {
                this.fireAdminEvent(new AdminEvent(mBeanTreeNode.getDescriptiveName(), 0));
            }
            overallTime = -1L;
            long time = -1L;
            if (location.beDebug()) {
                overallTime = System.currentTimeMillis();
            }
            error = "";
            this.frame.setCursor(new Cursor(3));
            this.tab.removeAll();
            this.mBeanTreeNode = mBeanTreeNode;
            serviceNodeDescriptor = (ServiceNodeDescriptor)mBeanTreeNode.getUserObject();
            try {
                RuntimeControl runtime;
                if (!this.staticControls.containsKey(mBeanTreeNode.getPath())) {
                    runtime = this.createRuntimeControl(mBeanTreeNode);
                    if (runtime != null) {
                        runtime.setEnvironment(ID_NAME, (Object)this);
                    }
                } else {
                    runtime = (RuntimeControl)this.staticControls.get(mBeanTreeNode.getPath());
                    this.currentControlStatic = true;
                }
                if (runtime == null) break block20;
                try {
                    this.registerRuntimeControl((VisualRuntimeControl)runtime);
                }
                catch (Exception exc) {
                    // empty catch block
                }
                if (!this.staticControls.containsKey(mBeanTreeNode.getPath())) {
                    if (location.beDebug()) {
                        time = System.currentTimeMillis();
                    }
                    runtime.show(ClusterTreeGenerator.managementInterfaceProxyFactory.generateManagementInterfaceProxy(serviceNodeDescriptor.getServiceDescriptor().getClusterID(), serviceNodeDescriptor.getServiceDescriptor().getName(), runtime.getClass().getClassLoader()));
                    if (location.beDebug()) {
                        location.debugT("Runtime control for service : " + mBeanTreeNode.getDescriptiveName() + " initialized for : " + (System.currentTimeMillis() - time) + " ms");
                    }
                }
                this.tab.addTab("Runtime", this.runtimeControl.getRuntimeControlComponent());
                if (this.currentControlStatic) {
                    this.staticControls.put(mBeanTreeNode.getPath(), runtime);
                }
            }
            catch (Exception ex) {
                error = error + ex.toString() + "\n\n";
                location.traceThrowableT(500, ex.getMessage(), (Throwable)ex);
                EditorViewManager.category.logT(500, location, ex.getMessage());
            }
        }
        try {
            ExtendedPropertiesEditor editor = new ExtendedPropertiesEditor();
            if (editor != null) {
                editor.setEnvironment(ID_NAME, this);
                this.registerPropertyEditor(editor);
            }
        }
        catch (Exception ex) {
            error = error + ex.toString() + "\n\n";
            location.traceThrowableT(500, ex.getMessage(), (Throwable)ex);
            EditorViewManager.category.logT(500, location, ex.getMessage());
        }
        try {
            this.additionalInfoPanel.init(serviceNodeDescriptor.getServiceDescriptor());
            this.tab.addTab("Additional Info", this.additionalInfoPanel);
        }
        catch (Throwable ex) {
            error = error + ex.toString() + "\n\n";
            location.traceThrowableT(500, ex.getMessage(), ex);
            EditorViewManager.category.logT(500, location, ex.getMessage());
        }
        this.tab.updateUI();
        if (error.length() > 0) {
            this.frame.addTask((StatusInfo)new ErrorTaskItem("Error while loading service " + mBeanTreeNode.getDescriptiveName(), error));
        }
        this.frame.setCursor(new Cursor(0));
        if (location.beDebug()) {
            location.debugT("Service " + mBeanTreeNode.getDescriptiveName() + " displayed for : " + (System.currentTimeMillis() - overallTime) + " ms");
        }
    }

    protected void selectGroupNode(MBeanTreeNode mBeanTreeNode) {
        this.mBeanTreeNode = mBeanTreeNode;
        this.frame.setCursor(new Cursor(3));
        this.tab.removeAll();
        this.tab.updateUI();
        this.frame.setCursor(new Cursor(0));
    }

    protected RuntimeControl createRuntimeControl(MBeanTreeNode mBeanTreeNode) throws Exception {
        ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)mBeanTreeNode.getUserObject();
        if (serviceNodeDescriptor.getServiceDescriptor().getStatus() != 5) {
            return null;
        }
        Class<?> runtimeClass = serviceNodeDescriptor.getRuntimeControlClass();
        String className = serviceNodeDescriptor.getServiceDescriptor().getRuntimeControlClassName();
        if (runtimeClass == null && className != null && className.trim().length() != 0) {
            runtimeClass = Class.forName(className);
        }
        if (runtimeClass == null) {
            return null;
        }
        try {
            RuntimeControl res = (RuntimeControl)runtimeClass.newInstance();
            return res;
        }
        catch (Throwable th) {
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw new AdminException(th);
        }
    }

    private void setServiceProperties(ServiceNodeDescriptor serviceNodeDescriptor, String clusterNodeDisplayName, String serviceDisplayName, Properties props, boolean isMessage) {
        int result;
        if (isMessage && (result = JOptionPane.showConfirmDialog(this.frame, "The properties of " + serviceDisplayName + " have changed.\n" + "Do you want to save these changes?", "Save " + serviceDisplayName + " Service Properties", 0)) != 0) {
            return;
        }
        Map propertySheets = serviceNodeDescriptor.getPropertySheets();
        Iterator iterator = propertySheets.keySet().iterator();
        Properties localDefaultPropertiesToChange = new Properties();
        Properties localCustomPropertiesToChange = new Properties();
        Properties securedPropertiesToChange = new Properties();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)propertySheets.get(key);
            String enteredValue = props.getProperty(key);
            if (enteredValue == null) continue;
            if (extendedPropertySheet.isSecure()) {
                securedPropertiesToChange.setProperty(key, enteredValue);
                continue;
            }
            if (extendedPropertySheet.getCustomValue().equals(enteredValue)) continue;
            switch (extendedPropertySheet.getCustomValueType()) {
                case 0: {
                    localDefaultPropertiesToChange.setProperty(key, enteredValue);
                    break;
                }
                case 1: {
                    localDefaultPropertiesToChange.setProperty(key, extendedPropertySheet.getGlobalDefaultValue());
                    if (extendedPropertySheet.getGlobalDefaultValue().equals(enteredValue)) break;
                    localCustomPropertiesToChange.setProperty(key, enteredValue);
                    break;
                }
                case 2: 
                case 3: {
                    localCustomPropertiesToChange.setProperty(key, enteredValue);
                }
            }
        }
        Properties runtimePropertiesToChange = null;
        runtimePropertiesToChange = Util.merge(localCustomPropertiesToChange, localDefaultPropertiesToChange);
        if (serviceNodeDescriptor.getServiceDescriptor().getStatus() == 5) {
            this.manager.setServiceProperties(serviceNodeDescriptor, clusterNodeDisplayName, serviceDisplayName, localDefaultPropertiesToChange, localCustomPropertiesToChange, runtimePropertiesToChange, securedPropertiesToChange);
        } else {
            this.manager.setServiceProperties(serviceNodeDescriptor, clusterNodeDisplayName, serviceDisplayName, localDefaultPropertiesToChange, localCustomPropertiesToChange, null, securedPropertiesToChange);
            if (((Hashtable)runtimePropertiesToChange).size() > 0) {
                Iterator keysIterator = ((Hashtable)runtimePropertiesToChange).keySet().iterator();
                while (keysIterator.hasNext()) {
                    String key = (String)keysIterator.next();
                    serviceNodeDescriptor.getRuntimeProperties().setProperty(key, runtimePropertiesToChange.getProperty(key));
                }
                this.propertiesEditor.initProperties(serviceNodeDescriptor.getRuntimeProperties(), serviceNodeDescriptor.getDefaultProperties(), serviceNodeDescriptor.getSecuredKeys());
            }
        }
    }

    private void restoreServiceProperties(ServiceNodeDescriptor serviceNodeDescriptor, String clusterNodeDisplayName, String serviceDisplayName) {
        Map propertySheets = serviceNodeDescriptor.getPropertySheets();
        Iterator iterator = propertySheets.keySet().iterator();
        Properties runtimePropertiesToChange = new Properties();
        HashSet<String> keysToChange = new HashSet<String>();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)propertySheets.get(key);
            if (extendedPropertySheet.isSecure()) {
                keysToChange.add(key);
                continue;
            }
            if (extendedPropertySheet.getCustomValue().equals(extendedPropertySheet.getDefaultValue())) continue;
            keysToChange.add(key);
            runtimePropertiesToChange.setProperty(key, extendedPropertySheet.getDefaultValue());
        }
        String[] keysArray = null;
        if (keysToChange.size() > 0) {
            keysArray = new String[keysToChange.size()];
            Iterator keysIterator = keysToChange.iterator();
            int i = 0;
            while (keysIterator.hasNext()) {
                keysArray[i++] = (String)keysIterator.next();
            }
        }
        if (serviceNodeDescriptor.getServiceDescriptor().getStatus() != 5) {
            runtimePropertiesToChange = null;
        }
        if (keysArray != null || runtimePropertiesToChange != null && ((Hashtable)runtimePropertiesToChange).size() > 0) {
            this.manager.restoreServiceProperties(serviceNodeDescriptor, clusterNodeDisplayName, serviceDisplayName, keysArray, runtimePropertiesToChange);
        }
    }

    public void actionPerformed(ActionEvent e) {
        ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)this.mBeanTreeNode.getUserObject();
        if (e.getSource() == this.setPropsBtn) {
            Properties props;
            if (this.propertiesEditor != null && !Util.compareProperties(props = this.propertiesEditor.getFirstProperties(), serviceNodeDescriptor.getRuntimeProperties())) {
                this.setServiceProperties(serviceNodeDescriptor, this.clusterNodeDisplayName, this.mBeanTreeNode.getDescriptiveName(), props, false);
            }
        } else if (e.getSource() == this.resetPropsBtn) {
            this.propertiesEditor.initProperties(serviceNodeDescriptor.getRuntimeProperties(), serviceNodeDescriptor.getDefaultProperties(), serviceNodeDescriptor.getSecuredKeys());
            this.propertiesEditor.getEditorComponent().repaint();
        } else if (e.getSource() == this.resetDefaultLocalPropsBtn) {
            if (!Util.compareProperties(this.propertiesEditor.getFirstProperties(), this.propertiesEditor.getSecondProperties())) {
                this.restoreServiceProperties(serviceNodeDescriptor, this.clusterNodeDisplayName, this.mBeanTreeNode.getDescriptiveName());
            }
        } else if (e.getSource() == this.defaultPropsBtn) {
            if (this.defaultPropsBtn.getIcon() == ImageHolder.detailsOn) {
                this.defaultPropsBtn.setIcon(ImageHolder.detailsOff);
                this.defaultPropsBtn.setToolTipText("Hide Details");
            } else {
                this.defaultPropsBtn.setIcon(ImageHolder.detailsOn);
                this.defaultPropsBtn.setToolTipText("Show Details");
            }
            this.propertiesEditor.setLastColumnVisible(!this.propertiesEditor.isLastColumnVisible());
        }
    }

    public void stateChanged(ChangeEvent e) {
        int index = this.tab.getSelectedIndex();
        this.toolBar.removeAll();
        if (index < 0) {
            return;
        }
        String name = this.tab.getTitleAt(index);
        if (name.equals("Runtime")) {
            JButton[] buttons = this.runtimeControl.getRuntimeButtons();
            if (buttons != null) {
                int i = 0;
                while (i < buttons.length) {
                    if (buttons[i] == null) {
                        this.toolBar.add((Component)new CToolBarSeparator());
                    } else {
                        this.toolBar.add(buttons[i]);
                    }
                    ++i;
                }
            }
            this.addedMenu = this.runtimeControl.getRuntimeMenu();
            if (this.addedMenu != null) {
                this.menuBar.add(this.addedMenu);
            }
        } else if (name.equals("Properties")) {
            this.toolBar.add(this.setPropsBtn);
            this.toolBar.add(this.resetPropsBtn);
            this.toolBar.add(this.resetDefaultLocalPropsBtn);
            this.toolBar.add(this.defaultPropsBtn);
            JButton[] buttons = this.propertiesEditor.getEditorButtons();
            if (buttons != null) {
                this.toolBar.add((Component)new CToolBarSeparator());
                int i = 0;
                while (i < buttons.length) {
                    if (buttons[i] == null) {
                        this.toolBar.add((Component)new CToolBarSeparator());
                    } else {
                        this.toolBar.add(buttons[i]);
                    }
                    ++i;
                }
            }
        }
        this.menuBar.validate();
        this.menuBar.repaint();
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    public void changeServiceStatus(int newStatus) {
        block12: {
            if (this.mBeanTreeNode == null) {
                return;
            }
            if (newStatus != 5) {
                if (this.runtimeControl != null) {
                    try {
                        this.runtimeControl.freeResources();
                    }
                    catch (Exception ex) {
                        this.frame.addTask((StatusInfo)new ErrorTaskItem("Error while unloading service " + this.mBeanTreeNode.getDescriptiveName(), ex.toString()));
                        location.traceThrowableT(500, ex.getMessage(), (Throwable)ex);
                        EditorViewManager.category.logT(500, location, ex.getMessage());
                    }
                    if (this.currentControlStatic) {
                        this.clearCachedControl((RuntimeControl)this.runtimeControl);
                        this.currentControlStatic = false;
                    }
                    this.runtimeControl = null;
                    this.tab.removeTabAt(0);
                    this.stateChanged(null);
                }
            } else {
                try {
                    RuntimeControl runtime = this.createRuntimeControl(this.mBeanTreeNode);
                    if (runtime == null) break block12;
                    this.tab.removeAll();
                    ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)this.mBeanTreeNode.getUserObject();
                    try {
                        this.registerRuntimeControl((VisualRuntimeControl)runtime);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    runtime.show(ClusterTreeGenerator.managementInterfaceProxyFactory.generateManagementInterfaceProxy(serviceNodeDescriptor.getServiceDescriptor().getClusterID(), serviceNodeDescriptor.getServiceDescriptor().getName(), runtime.getClass().getClassLoader()));
                    this.tab.addTab("Runtime", this.runtimeControl.getRuntimeControlComponent());
                    if (this.propertiesEditor != null) {
                        this.propertiesEditor.initProperties(serviceNodeDescriptor.getRuntimeProperties(), serviceNodeDescriptor.getDefaultProperties(), serviceNodeDescriptor.getSecuredKeys());
                        this.tab.addTab("Properties", this.propertiesEditor.getEditorComponent());
                    }
                    this.tab.addTab("Additional Info", this.additionalInfoPanel);
                    this.tab.updateUI();
                    this.stateChanged(null);
                }
                catch (Exception ex) {
                    this.frame.addTask((StatusInfo)new ErrorTaskItem("Error while loading service " + this.mBeanTreeNode.getDescriptiveName(), ex.toString()));
                    location.traceThrowableT(500, ex.getMessage(), (Throwable)ex);
                    EditorViewManager.category.logT(500, location, ex.getMessage());
                }
            }
        }
    }

    public JComponent getComponent() {
        if (this.mBeanTreeNode == null) {
            return null;
        }
        return this;
    }

    public void addTask(TaskItem task) {
        this.frame.addTask(task);
    }

    private void registerPropertyEditor(ExtendedPropertiesEditor editor) {
        this.propertiesEditor = editor;
        if (this.propertiesEditor != null) {
            this.propertiesEditor.setFrame(this.frame);
            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)this.mBeanTreeNode.getUserObject();
            this.propertiesEditor.initProperties(serviceNodeDescriptor.getRuntimeProperties(), serviceNodeDescriptor.getDefaultProperties(), serviceNodeDescriptor.getSecuredKeys());
            this.tab.addTab("Properties", this.propertiesEditor.getEditorComponent());
        }
    }

    public void registerRuntimeControl(VisualRuntimeControl control) {
        this.runtimeControl = control;
        if (this.runtimeControl != null) {
            this.runtimeControl.setFrame((Frame)this.frame);
            this.runtimeControl.setTaskManager((EditorViewManager)this);
        }
    }

    private boolean isServerSelected() {
        MBeanTreeNode parentMBeanTreeNode = this.manager.getParentClusterNode(this.mBeanTreeNode);
        ClusterElementNodeDescriptor clusterElementNodeDescriptor = (ClusterElementNodeDescriptor)parentMBeanTreeNode.getUserObject();
        return clusterElementNodeDescriptor.getType().equals("Server");
    }

    public static String getStackTrace(Throwable t) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter wrapper = new PrintWriter(writer);
            t.printStackTrace(wrapper);
            return writer.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void freeRuntimeControlResources(boolean freeAllServicesResources) {
        if (freeAllServicesResources) {
            Iterator iterator = this.staticControls.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                VisualRuntimeControl cachedRuntimeControl = (VisualRuntimeControl)this.staticControls.get(key);
                if (cachedRuntimeControl == this.runtimeControl) continue;
                this.freeSingleRuntimeControlResources(cachedRuntimeControl);
            }
        }
        this.freeSingleRuntimeControlResources(this.runtimeControl);
        this.runtimeControl = null;
    }

    private void freeSingleRuntimeControlResources(VisualRuntimeControl aRuntimeControl) {
        if (aRuntimeControl != null) {
            try {
                aRuntimeControl.freeResources();
            }
            catch (Exception ex) {
                this.frame.addTask((StatusInfo)new ErrorTaskItem("Error while unloading service " + this.mBeanTreeNode != null ? this.mBeanTreeNode.getDescriptiveName() : "", ex.toString()));
                location.traceThrowableT(500, ex.getMessage(), (Throwable)ex);
                EditorViewManager.category.logT(500, location, ex.getMessage());
            }
            if (aRuntimeControl instanceof AdminEventListener) {
                this.unregisterAdminEventListener((AdminEventListener)aRuntimeControl);
            }
        }
    }

    public void setControlCached(boolean isControlCached) {
        this.currentControlStatic = isControlCached;
    }

    public void reinitProperties(int result, int clusterID, String serviceName, String clusterNodeDisplayName, String serviceDisplayName, boolean showErrorMessage) {
        if (showErrorMessage) {
            if (result == -1) {
                JOptionPane.showMessageDialog(this.frame, "Properties of service " + serviceDisplayName + " on " + clusterNodeDisplayName + " could not be changed!", "Error while changing service " + serviceDisplayName + " properties", 0);
                this.updateServicePropertiesTable(clusterID, serviceName);
            } else if (result == 0) {
                EventQueue.invokeLater(new EventQueueTask(clusterID, serviceName, serviceDisplayName, clusterNodeDisplayName, this.manager));
            } else if (result == 2) {
                JOptionPane.showMessageDialog(this.frame, "Service " + serviceDisplayName + " on " + clusterNodeDisplayName + " is a core service. Restart of " + clusterNodeDisplayName + " is needed for the properties changes to take effect.", "Restart of " + clusterNodeDisplayName + " needed", 1);
                this.updateServicePropertiesTable(clusterID, serviceName);
            }
        }
    }

    public void updateServicePropertiesTable(int clusterID, String serviceName) {
        if (this.mBeanTreeNode == null) {
            return;
        }
        ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)this.mBeanTreeNode.getUserObject();
        if (serviceNodeDescriptor.getServiceDescriptor().getClusterID() == clusterID && serviceNodeDescriptor.getServiceDescriptor().getName().equals(serviceName)) {
            this.propertiesEditor.initProperties(serviceNodeDescriptor.getRuntimeProperties(), serviceNodeDescriptor.getDefaultProperties(), serviceNodeDescriptor.getSecuredKeys());
        }
    }

    public void clearCachedControls() {
        Iterator iterator = this.staticControls.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            RuntimeControl staticRuntimeControl = (RuntimeControl)this.staticControls.get(key);
            if (!(staticRuntimeControl instanceof AdminEventListener)) continue;
            this.unregisterAdminEventListener((AdminEventListener)staticRuntimeControl);
        }
        this.staticControls.clear();
        this.currentControlStatic = false;
    }

    private void clearCachedControl(RuntimeControl runtimeControl) {
        Iterator iterator = this.staticControls.keySet().iterator();
        while (iterator.hasNext()) {
            String mBeanTreeNodePath = (String)iterator.next();
            if (runtimeControl != this.staticControls.get(mBeanTreeNodePath)) continue;
            this.staticControls.remove(mBeanTreeNodePath);
            return;
        }
    }

    public void enableButtons(boolean enabled) {
        if (enabled && this.mBeanTreeNode != null) {
            ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)this.mBeanTreeNode.getUserObject();
            this.propertiesEditor.initProperties(serviceNodeDescriptor.getRuntimeProperties(), serviceNodeDescriptor.getDefaultProperties(), serviceNodeDescriptor.getSecuredKeys());
        }
        this.setPropsBtn.setEnabled(enabled);
        this.resetDefaultLocalPropsBtn.setEnabled(enabled);
        this.defaultPropsBtn.setEnabled(enabled);
    }

    public void registerAdminEventListener(AdminEventListener listener, String serviceName) {
        String key;
        ArrayList<AdminEventListener> listeners = null;
        String string = key = serviceName != null ? serviceName : "Conection Listeners";
        if (this.adminEventListeners == null) {
            this.adminEventListeners = new HashMap();
        }
        if ((listeners = (ArrayList<AdminEventListener>)this.adminEventListeners.get(key)) == null) {
            listeners = new ArrayList<AdminEventListener>();
            this.adminEventListeners.put(serviceName, listeners);
        }
        listeners.add(listener);
    }

    public void unregisterAdminEventListener(AdminEventListener listener) {
        if (this.adminEventListeners == null || listener == null) {
            return;
        }
        Object[] keys = this.adminEventListeners.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String key = (String)keys[i];
            List listeners = (List)this.adminEventListeners.get(key);
            if (listeners.contains(listener)) {
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    this.adminEventListeners.remove(key);
                }
            }
            ++i;
        }
        if (this.adminEventListeners.size() == 0) {
            this.adminEventListeners = null;
        }
    }

    public void fireAdminEvent(AdminEvent adminEvent) {
        block5: {
            List listeners;
            block4: {
                if (this.adminEventListeners == null) {
                    return;
                }
                if (adminEvent.getType() == 0 || adminEvent.getType() == 1) break block4;
                Iterator serviceKeysIterator = this.adminEventListeners.keySet().iterator();
                while (serviceKeysIterator.hasNext()) {
                    String key = (String)serviceKeysIterator.next();
                    List listeners2 = (List)this.adminEventListeners.get(key);
                    Iterator listenersIterator = listeners2.iterator();
                    while (listenersIterator.hasNext()) {
                        AdminEventListener listener = (AdminEventListener)listenersIterator.next();
                        listener.adminEventOccured(adminEvent);
                    }
                }
                break block5;
            }
            String serviceName = adminEvent.getServiceName();
            if (serviceName == null || (listeners = (List)this.adminEventListeners.get(serviceName)) == null) break block5;
            Iterator listenersIterator = listeners.iterator();
            while (listenersIterator.hasNext()) {
                AdminEventListener listener = (AdminEventListener)listenersIterator.next();
                listener.adminEventOccured(adminEvent);
            }
        }
    }

    public void displayInfoStatusLineMessage(String message, String details) {
        this.frame.addTask((StatusInfo)new InfoTaskItem(message, details));
    }

    public void displayErrorStatusLineMessage(String message, String details) {
        this.frame.addTask((StatusInfo)new ErrorTaskItem(message, details));
    }

    public ManagementInterface getCurrentManagementInterfaceProxy(String serviceName) {
        try {
            return ClusterTreeGenerator.managementInterfaceProxyFactory.generateCurrentManagementInterfaceProxy(serviceName);
        }
        catch (AdminException ae) {
            location.logT(500, "Error while generating management interface for service " + serviceName + ": " + ae.getMessage());
            return null;
        }
    }

    public ManagementInterface getManagementInterfaceProxy(int clusterID, String serviceName) {
        try {
            return ClusterTreeGenerator.managementInterfaceProxyFactory.generateManagementInterfaceProxy(clusterID, serviceName);
        }
        catch (AdminException ae) {
            location.logT(500, "Error while generating management interface for service " + serviceName + " on cluster ID " + clusterID + ": " + ae.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

