/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.services.adminadapter.gui.node.ManagerTreeObject;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class ManagerTreeRenderer
extends JLabel
implements TreeCellRenderer {
    Icon rootIcon;
    Icon mngGroupIcon;
    Icon managerIcon;

    public ManagerTreeRenderer() {
        this.setOpaque(true);
        this.rootIcon = new ImageIcon(this.getClass().getResource("managergroup.gif"));
        this.mngGroupIcon = new ImageIcon(this.getClass().getResource("managergroup.gif"));
        this.managerIcon = new ImageIcon(this.getClass().getResource("manager.gif"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ManagerTreeObject cluster = (ManagerTreeObject)((DefaultMutableTreeNode)value).getUserObject();
        if (cluster.type == 0) {
            this.setIcon(this.rootIcon);
        } else if (cluster.type == 1) {
            this.setIcon(this.managerIcon);
        } else {
            this.setIcon(this.mngGroupIcon);
        }
        this.setText(cluster.toString());
        this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }
}

