/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertiesEditor;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertySheet;
import com.sap.engine.services.adminadapter.gui.ImageHolder;
import com.sap.engine.services.adminadapter.impl.MBeanTreeNodeImpl;
import com.sap.engine.services.adminadapter.impl.Util;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ManagerNodeView
extends JPanel
implements ActionListener,
ChangeListener {
    private JTabbedPane tabbedPane;
    private ExtendedPropertiesEditor propertiesEditor;
    private final JButton setPropsBtn = new JButton();
    private final JButton resetPropsBtn = new JButton();
    private final JButton restoreDefaultPropsBtn = new JButton();
    private final JButton defaultPropsBtn = new JButton();
    private Object node;
    private AdminFrameView frame;
    private AdminManager manager;
    private JToolBar toolBar;
    private HashMapIntObject clusterElements;
    private String clusterNodeDisplayName;

    public ManagerNodeView(AdminFrameView frame, AdminManager manager, JToolBar toolBar) {
        this.frame = frame;
        this.manager = manager;
        this.toolBar = toolBar;
        this.initView();
        LookAndFeelHandler.add((Component)this);
    }

    protected void initView() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPropsBtn.setPreferredSize(new Dimension(24, 24));
        this.setPropsBtn.setToolTipText("Save Properties");
        this.setPropsBtn.addActionListener(this);
        this.setPropsBtn.setIcon(ImageHolder.setIcon);
        this.resetPropsBtn.setPreferredSize(new Dimension(24, 24));
        this.resetPropsBtn.setToolTipText("Reset Properties");
        this.resetPropsBtn.addActionListener(this);
        this.resetPropsBtn.setIcon(ImageHolder.resetIcon);
        this.restoreDefaultPropsBtn.setPreferredSize(new Dimension(24, 24));
        this.restoreDefaultPropsBtn.setToolTipText("Reset Default Properties");
        this.restoreDefaultPropsBtn.addActionListener(this);
        this.restoreDefaultPropsBtn.setIcon(ImageHolder.clearIcon);
        this.defaultPropsBtn.setPreferredSize(new Dimension(24, 24));
        this.defaultPropsBtn.setToolTipText("Show Details");
        this.defaultPropsBtn.addActionListener(this);
        this.defaultPropsBtn.setIcon(ImageHolder.detailsOn);
        LookAndFeelHandler.add((Component)this.setPropsBtn);
        LookAndFeelHandler.add((Component)this.resetPropsBtn);
        LookAndFeelHandler.add((Component)this.restoreDefaultPropsBtn);
        LookAndFeelHandler.add((Component)this.defaultPropsBtn);
        this.tabbedPane.addChangeListener(this);
        this.propertiesEditor = new ExtendedPropertiesEditor("Key", "Value", "Default Value");
    }

    public void deselectNode(Object node) {
        if (node instanceof MBeanTreeNodeImpl) {
            this.deselectGroupNode();
        } else {
            this.deselectSingleManagerNode();
        }
        this.clusterNodeDisplayName = null;
    }

    protected void deselectSingleManagerNode() {
        Properties props = this.propertiesEditor.getFirstProperties();
        if (!Util.compareProperties(props, ((ManagerNodeDescriptor)this.node).getRuntimeProperties())) {
            this.setManagerProperties((ManagerNodeDescriptor)this.node, props, true);
        }
        this.tabbedPane.removeAll();
        this.node = null;
        this.toolBar.removeAll();
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    protected void deselectGroupNode() {
        this.tabbedPane.removeAll();
        this.node = null;
        this.toolBar.removeAll();
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    public void selectNode(Object node) {
        if (node instanceof MBeanTreeNode) {
            this.selectGroupNode((MBeanTreeNode)node);
        } else if (node instanceof ManagerNodeDescriptor) {
            this.selectSingleNode((ManagerNodeDescriptor)node);
        }
    }

    protected void selectSingleNode(ManagerNodeDescriptor managerNodeDescriptor) {
        this.node = managerNodeDescriptor;
        this.clusterNodeDisplayName = this.getClusterNodeDisplayName(managerNodeDescriptor);
        this.frame.setCursor(new Cursor(3));
        this.addProperties();
        this.tabbedPane.updateUI();
        this.frame.setCursor(new Cursor(0));
    }

    protected void selectGroupNode(MBeanTreeNode mBeanTreeNode) {
        this.node = mBeanTreeNode;
        this.tabbedPane.updateUI();
        this.frame.setCursor(new Cursor(0));
    }

    private String getClusterNodeDisplayName(ManagerNodeDescriptor managerNodeDescriptor) {
        int clusterID = managerNodeDescriptor.getClusterID();
        return (String)this.clusterElements.get(clusterID);
    }

    private void addProperties() {
        ManagerNodeDescriptor managerNodeDescriptor = (ManagerNodeDescriptor)this.node;
        this.propertiesEditor.initProperties(managerNodeDescriptor.getRuntimeProperties(), managerNodeDescriptor.getDefaultProperties(), managerNodeDescriptor.getSecuredKeys());
        this.tabbedPane.addTab("Properties", this.propertiesEditor);
    }

    public JComponent getComponent() {
        return this;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.setPropsBtn) {
            Properties properties = this.propertiesEditor.getFirstProperties();
            if (!Util.compareProperties(properties, ((ManagerNodeDescriptor)this.node).getRuntimeProperties())) {
                this.setManagerProperties((ManagerNodeDescriptor)this.node, properties, false);
            }
        } else if (e.getSource() == this.resetPropsBtn) {
            this.propertiesEditor.initProperties(((ManagerNodeDescriptor)this.node).getRuntimeProperties(), ((ManagerNodeDescriptor)this.node).getDefaultProperties(), ((ManagerNodeDescriptor)this.node).getSecuredKeys());
            this.propertiesEditor.repaint();
        } else if (e.getSource() == this.restoreDefaultPropsBtn) {
            if (!Util.compareProperties(this.propertiesEditor.getFirstProperties(), this.propertiesEditor.getSecondProperties())) {
                this.restoreManagerProperties((ManagerNodeDescriptor)this.node);
            }
        } else if (e.getSource() == this.defaultPropsBtn) {
            if (this.defaultPropsBtn.getIcon() == ImageHolder.detailsOn) {
                this.defaultPropsBtn.setIcon(ImageHolder.detailsOff);
                this.defaultPropsBtn.setToolTipText("Hide Details");
            } else {
                this.defaultPropsBtn.setIcon(ImageHolder.detailsOn);
                this.defaultPropsBtn.setToolTipText("Show Details");
            }
            this.propertiesEditor.setLastColumnVisible(!this.propertiesEditor.isLastColumnVisible());
        }
    }

    private void restoreManagerProperties(ManagerNodeDescriptor managerNodeDescriptor) {
        Map propertySheets = managerNodeDescriptor.getPropertySheets();
        Iterator iterator = propertySheets.keySet().iterator();
        Properties runtimePropertiesToChange = new Properties();
        HashSet<String> keysToChange = new HashSet<String>();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)propertySheets.get(key);
            if (extendedPropertySheet.isSecure()) {
                keysToChange.add(key);
                continue;
            }
            if (extendedPropertySheet.getCustomValue().equals(extendedPropertySheet.getDefaultValue())) continue;
            keysToChange.add(key);
            runtimePropertiesToChange.setProperty(key, extendedPropertySheet.getDefaultValue());
        }
        String[] keysArray = null;
        if (keysToChange.size() > 0) {
            keysArray = new String[keysToChange.size()];
            Iterator keysIterator = keysToChange.iterator();
            int i = 0;
            while (keysIterator.hasNext()) {
                keysArray[i++] = (String)keysIterator.next();
            }
        }
        if (keysArray != null || ((Hashtable)runtimePropertiesToChange).size() > 0) {
            this.manager.restoreManagerProperties(managerNodeDescriptor, this.clusterNodeDisplayName, keysArray, runtimePropertiesToChange);
        }
    }

    public void stateChanged(ChangeEvent e) {
        String name;
        int index = this.tabbedPane.getSelectedIndex();
        this.toolBar.removeAll();
        if (index >= 0 && (name = this.tabbedPane.getTitleAt(index)).equals("Properties")) {
            this.toolBar.add(this.setPropsBtn);
            this.toolBar.add(this.resetPropsBtn);
            this.toolBar.add(this.restoreDefaultPropsBtn);
            this.toolBar.add(this.defaultPropsBtn);
        }
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    protected void setManagerProperties(ManagerNodeDescriptor managerNodeDescriptor, Properties props, boolean isMessage) {
        int result;
        if (isMessage && (result = JOptionPane.showConfirmDialog(this.frame, "The properties of " + managerNodeDescriptor.getManagerName() + " on " + this.clusterNodeDisplayName + " have changed.\n" + "Do you want to save these changes?")) != 0) {
            return;
        }
        Map propertySheets = managerNodeDescriptor.getPropertySheets();
        Iterator iterator = propertySheets.keySet().iterator();
        Properties localDefaultPropertiesToChange = new Properties();
        Properties localCustomPropertiesToChange = new Properties();
        Properties securedProperties = new Properties();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ExtendedPropertySheet extendedPropertySheet = (ExtendedPropertySheet)propertySheets.get(key);
            String enteredValue = props.getProperty(key);
            if (enteredValue == null) continue;
            if (extendedPropertySheet.isSecure()) {
                securedProperties.setProperty(key, enteredValue);
                continue;
            }
            if (extendedPropertySheet.getCustomValue().equals(enteredValue) || enteredValue == null) continue;
            switch (extendedPropertySheet.getCustomValueType()) {
                case 0: {
                    localDefaultPropertiesToChange.setProperty(key, enteredValue);
                    break;
                }
                case 1: {
                    localDefaultPropertiesToChange.setProperty(key, extendedPropertySheet.getGlobalDefaultValue());
                    if (extendedPropertySheet.getGlobalDefaultValue().equals(enteredValue)) break;
                    localCustomPropertiesToChange.setProperty(key, enteredValue);
                    break;
                }
                case 2: 
                case 3: {
                    localCustomPropertiesToChange.setProperty(key, enteredValue);
                }
            }
        }
        Properties runtimePropertiesToChange = Util.merge(localCustomPropertiesToChange, localDefaultPropertiesToChange);
        this.manager.setManagerProperties(managerNodeDescriptor, this.clusterNodeDisplayName, localDefaultPropertiesToChange, localCustomPropertiesToChange, runtimePropertiesToChange, securedProperties);
    }

    public void reinitProperties(int result, int clusterID, String managerName, String clusterNodeDisplayName, boolean showErrorMessage) {
        if (showErrorMessage) {
            if (result == -1) {
                JOptionPane.showMessageDialog(this.frame, "Properties of manager " + managerName + " on " + clusterNodeDisplayName + " could not be changed!", "Error while changing manager " + managerName + " properties", 0);
            } else if (result == 0) {
                JOptionPane.showMessageDialog(this.frame, "Please, restart " + clusterNodeDisplayName + " in order the change of \nproperties for manager " + managerName + " to take effect.", "Restart of " + clusterNodeDisplayName + " needed", 1);
            }
            this.updateManagerPropertiesTable(clusterID, managerName);
        }
    }

    public void updateManagerPropertiesTable(int clusterID, String managerName) {
        if (this.node == null || !(this.node instanceof ManagerNodeDescriptor)) {
            return;
        }
        ManagerNodeDescriptor managerNodeDescriptor = (ManagerNodeDescriptor)this.node;
        if (managerNodeDescriptor.getClusterID() == clusterID && managerNodeDescriptor.getManagerName().equals(managerName)) {
            this.propertiesEditor.initProperties(managerNodeDescriptor.getRuntimeProperties(), managerNodeDescriptor.getDefaultProperties(), managerNodeDescriptor.getSecuredKeys());
        }
    }

    public void setClusterElements(HashMapIntObject clusterElements) {
        this.clusterElements = clusterElements;
    }
}

