/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.services.adminadapter.descriptor.MBeanNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.node.ConversionUtil;
import com.sap.engine.services.adminadapter.gui.node.InputDialog;
import com.sap.engine.services.adminadapter.gui.node.OperationsListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InvalidClassException;
import java.util.Vector;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MBeanOperationsPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
    private JList operationsList;
    private OperationsListModel listModel;
    private JPanel operationsPanel;
    private JScrollPane operationsScrollPane;
    private JPanel buttonPanel;
    private JButton invokeButton;
    private Vector operationSignatures;
    private InputDialog inputDialog;
    private AdminFrameView frame;
    private AdminManager adminManager;
    private MBeanOperationInfo[] operations;
    private MBeanParameterInfo[] parametersInfo;
    private ObjectName objectName;
    private boolean isSecondListEvent;
    private MBeanNodeDescriptor mBeanNodeDescriptor;
    InvalidClassException ice;

    public MBeanOperationsPanel(AdminFrameView frame, AdminManager adminManager) {
        this.frame = frame;
        this.adminManager = adminManager;
        this.initDefaultView();
    }

    private void initDefaultView() {
        this.operationSignatures = new Vector();
        this.listModel = new OperationsListModel(this.operationSignatures);
        this.operationsList = new JList(this.listModel);
        this.operationsList.addListSelectionListener(this);
        this.operationsScrollPane = new JScrollPane(this.operationsList);
        this.operationsPanel = new JPanel();
        this.operationsPanel.setLayout(new BorderLayout());
        this.invokeButton = new JButton("Invoke");
        this.invokeButton.addActionListener(this);
        this.invokeButton.setToolTipText("Invoke Operation");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1));
        this.buttonPanel.add(this.invokeButton);
        this.operationsPanel.add((Component)this.operationsScrollPane, "Center");
        this.operationsPanel.add((Component)this.buttonPanel, "South");
        this.operationsPanel.setBorder(BorderFactory.createTitledBorder("MBean Operations"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.operationsPanel, "Center");
        this.isSecondListEvent = false;
    }

    private void initPanelsView() {
        this.invokeButton.setEnabled(this.operationsList.getSelectedIndex() != -1);
        this.operations = this.mBeanNodeDescriptor.getMBeanInfo().getOperations();
        if (this.operations != null && this.operations.length > 0) {
            String signature = null;
            int i = 0;
            while (i < this.operations.length) {
                signature = this.buildSignature(this.operations[i]);
                this.operationSignatures.addElement(signature);
                ++i;
            }
            this.listModel.init();
        }
    }

    public void init(ObjectName objectName, MBeanNodeDescriptor mBeanNodeDescriptor) {
        this.objectName = objectName;
        this.mBeanNodeDescriptor = mBeanNodeDescriptor;
        this.initPanelsView();
    }

    private String buildSignature(MBeanOperationInfo operation) {
        MBeanParameterInfo[] parameters = operation.getSignature();
        String result = ConversionUtil.normalizeArraySignature(operation.getReturnType()) + " " + operation.getName() + "(";
        int i = 0;
        while (i < parameters.length) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + parameters[i].getType() + " " + parameters[i].getName();
            ++i;
        }
        result = result + ")";
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        int index = this.operationsList.getSelectedIndex();
        this.invokeOperationAction(index);
    }

    private void invokeOperationAction(int index) {
        String[] parameters = null;
        if (index != -1) {
            MBeanOperationInfo operation = this.operations[index];
            this.parametersInfo = operation.getSignature();
            if (this.parametersInfo.length > 0) {
                parameters = new String[this.parametersInfo.length];
                int i = 0;
                while (i < this.parametersInfo.length) {
                    parameters[i] = this.parametersInfo[i].getType() + " " + this.parametersInfo[i].getName();
                    ++i;
                }
                if (this.inputDialog == null) {
                    this.inputDialog = new InputDialog(this.frame);
                }
                this.inputDialog.initView(operation.getName(), parameters);
                this.inputDialog.pack();
                Dimension dialogDimension = this.inputDialog.getSize();
                ((Component)this.inputDialog).setLocation((this.screenDimension.width - dialogDimension.width) / 2, (this.screenDimension.height - dialogDimension.height) / 2);
                ((Component)this.inputDialog).setVisible(true);
                if (this.inputDialog.isCanceled()) {
                    return;
                }
                if (this.parametersInfo != null) {
                    String[] signature = new String[this.parametersInfo.length];
                    Object[] values = this.inputDialog.getValues();
                    int i2 = 0;
                    while (i2 < this.parametersInfo.length) {
                        signature[i2] = this.parametersInfo[i2].getType();
                        ++i2;
                    }
                    this.commitInvoke(this.objectName, operation.getName(), values, signature, operation.getReturnType());
                }
            } else {
                this.commitInvoke(this.objectName, operation.getName(), new Object[0], new String[0], operation.getReturnType());
            }
        }
    }

    public void reset() {
        this.operationSignatures.clear();
        this.listModel.init();
        this.objectName = null;
        this.mBeanNodeDescriptor = null;
        if (this.inputDialog != null) {
            this.inputDialog.reset();
        }
        this.operations = null;
        this.parametersInfo = null;
    }

    private void commitInvoke(ObjectName objectName, String operationName, Object[] params, String[] signature, String returnType) {
        this.adminManager.invokeMBeanOperation(objectName, operationName, params, signature, returnType);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.isSecondListEvent) {
            this.isSecondListEvent = true;
            return;
        }
        if (!this.invokeButton.isEnabled()) {
            this.invokeButton.setEnabled(true);
        }
        this.isSecondListEvent = false;
    }

    public void operationFinished(Object result) {
    }
}

