/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.services.adminadapter.gui.node.NotificationsTableModel;
import com.sap.engine.services.adminadapter.gui.node.OperationsListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanNotificationInfo;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MBeanNotificationsPanel
extends JPanel
implements ListSelectionListener {
    private JTable notificationsTable;
    private MBeanNotificationInfo[] mBeanNotifications;
    private NotificationsTableModel tableModel;
    private JList notificationsList;
    private OperationsListModel listModel;
    private List tableData;
    private List listData;
    private JScrollPane tableScrollPane;
    private JScrollPane listScrollPane;
    private JPanel tablePanel;
    private JPanel listPanel;

    public MBeanNotificationsPanel() {
        this.initDefaultView();
    }

    private void initDefaultView() {
        this.tableData = new ArrayList();
        this.tableModel = new NotificationsTableModel(this.tableData);
        this.notificationsTable = new JTable(this.tableModel);
        this.notificationsTable.getSelectionModel().setSelectionMode(0);
        this.notificationsTable.getSelectionModel().addListSelectionListener(this);
        this.tableScrollPane = new JScrollPane(this.notificationsTable);
        this.tablePanel = new JPanel();
        this.tablePanel.setPreferredSize(new Dimension(500, 200));
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.tableScrollPane, "Center");
        this.tablePanel.setBorder(BorderFactory.createTitledBorder("Emitted Notifications"));
        this.listData = new ArrayList();
        this.listModel = new OperationsListModel(this.listData);
        this.notificationsList = new JList(this.listModel);
        this.listScrollPane = new JScrollPane(this.notificationsList);
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new BorderLayout());
        this.listPanel.add((Component)this.listScrollPane, "Center");
        this.listPanel.setBorder(BorderFactory.createTitledBorder("Notification Types"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tablePanel, "Center");
        this.add((Component)this.listPanel, "South");
    }

    public void init(MBeanNotificationInfo[] mBeanNotifications) {
        this.mBeanNotifications = mBeanNotifications;
        this.initPanelsView();
    }

    private void initPanelsView() {
        int i = 0;
        while (i < this.mBeanNotifications.length) {
            this.tableData.add(this.mBeanNotifications[i]);
            ++i;
        }
        int selectedIndex = this.notificationsTable.getSelectedRow();
        if (selectedIndex != -1) {
            // empty if block
        }
    }

    public void reset() {
        this.mBeanNotifications = null;
        this.tableData.clear();
        this.listData.clear();
    }

    public void valueChanged(ListSelectionEvent e) {
        int selectedIndex = this.notificationsTable.getSelectedRow();
        MBeanNotificationInfo notificationInfo = this.tableModel.getElementAt(selectedIndex);
        String[] notificationTypes = notificationInfo.getNotifTypes();
        this.listData.clear();
        int i = 0;
        while (i < notificationTypes.length) {
            this.listData.add(notificationTypes[i]);
            ++i;
        }
        this.listModel.init();
    }
}

