/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.gui.status.TaskEvent;
import com.sap.engine.gui.status.TaskEventListener;
import com.sap.engine.services.adminadapter.descriptor.MBeanNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.adminadapter.gui.node.MBeanAttributesPanel;
import com.sap.engine.services.adminadapter.gui.node.MBeanConstructorsPanel;
import com.sap.engine.services.adminadapter.gui.node.MBeanNotificationsPanel;
import com.sap.engine.services.adminadapter.gui.node.MBeanOperationsPanel;
import com.sap.engine.services.adminadapter.interfaces.MBeanTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MBeanNodeView
extends JPanel
implements TaskEventListener,
ChangeListener {
    private MBeanAttributesPanel mBeanAttributesPanel;
    private MBeanOperationsPanel mBeanOperationsPanel;
    private MBeanConstructorsPanel mBeanConstructorsPanel;
    private MBeanNotificationsPanel mBeanNotificationsPanel;
    private JTabbedPane tab;
    private JTabbedPane panelsTabbedPane;
    private JScrollPane attributesScrollPane;
    private JScrollPane operationsScrollPane;
    private JScrollPane constructorsScrollPane;
    private JScrollPane notificationsScrollPane;

    public MBeanNodeView(AdminFrameView frame, AdminManager adminManager, JToolBar toolBar) {
        this.initView(frame, adminManager, toolBar);
    }

    private void initView(AdminFrameView frame, AdminManager adminManager, JToolBar toolBar) {
        this.tab = new JTabbedPane();
        this.panelsTabbedPane = new JTabbedPane();
        this.panelsTabbedPane.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.tab, "Center");
        this.mBeanAttributesPanel = new MBeanAttributesPanel(frame, adminManager, toolBar);
        this.mBeanOperationsPanel = new MBeanOperationsPanel(frame, adminManager);
        this.mBeanConstructorsPanel = new MBeanConstructorsPanel(frame, adminManager);
        this.mBeanNotificationsPanel = new MBeanNotificationsPanel();
        this.attributesScrollPane = new JScrollPane(this.mBeanAttributesPanel);
        this.operationsScrollPane = new JScrollPane(this.mBeanOperationsPanel);
        this.constructorsScrollPane = new JScrollPane(this.mBeanConstructorsPanel);
        this.notificationsScrollPane = new JScrollPane(this.mBeanNotificationsPanel);
        this.panelsTabbedPane.setTabPlacement(3);
        this.panelsTabbedPane.addTab("Attributes", this.attributesScrollPane);
        this.panelsTabbedPane.addTab("Operations", this.operationsScrollPane);
        this.panelsTabbedPane.addTab("Constructors", this.constructorsScrollPane);
        this.panelsTabbedPane.addTab("Notifications", this.notificationsScrollPane);
    }

    public void selectNode(MBeanTreeNode mBeanTreeNode) {
        this.tab.removeAll();
        if (mBeanTreeNode.getType() == -1) {
            try {
                Class runtimeControlClass = (Class)ClusterTreeGenerator.defaultMBeanAdministrator.invoke(mBeanTreeNode.getObjectName(), "getRuntimeControlClass", null, null);
                this.tab.add(mBeanTreeNode.getDescriptiveName() + " - Runtime Control", (JComponent)runtimeControlClass.getMethod("getRuntimeControlComponent", null).invoke(runtimeControlClass.newInstance(), null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mBeanAttributesPanel.init(mBeanTreeNode.getObjectName(), (MBeanNodeDescriptor)mBeanTreeNode.getUserObject());
            this.mBeanOperationsPanel.init(mBeanTreeNode.getObjectName(), (MBeanNodeDescriptor)mBeanTreeNode.getUserObject());
            this.mBeanConstructorsPanel.init(mBeanTreeNode.getObjectName(), (MBeanNodeDescriptor)mBeanTreeNode.getUserObject());
            this.mBeanNotificationsPanel.init(((MBeanNodeDescriptor)mBeanTreeNode.getUserObject()).getMBeanInfo().getNotifications());
            this.panelsTabbedPane.setSelectedIndex(0);
            this.tab.add("Management", this.panelsTabbedPane);
        }
        this.tab.updateUI();
        this.repaint();
    }

    public void deselectNode(MBeanTreeNode mBeanTreeNode) {
        this.mBeanAttributesPanel.reset();
        this.mBeanOperationsPanel.reset();
        this.mBeanConstructorsPanel.reset();
        this.mBeanNotificationsPanel.reset();
    }

    public void taskEventOccured(TaskEvent te) {
    }

    public void stateChanged(ChangeEvent e) {
    }
}

