/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.services.adminadapter.descriptor.MBeanNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.node.InputDialog;
import com.sap.engine.services.adminadapter.gui.node.OperationsListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InvalidClassException;
import java.util.List;
import java.util.Vector;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MBeanConstructorsPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
    private JList constructorsList;
    private OperationsListModel listModel;
    private JPanel constructorsPanel;
    private JScrollPane constructorsScrollPane;
    private JPanel buttonPanel;
    private JButton invokeButton;
    private List constructorSignatures;
    private InputDialog inputDialog;
    private AdminFrameView frame;
    private AdminManager adminManager;
    private MBeanConstructorInfo[] constructors;
    private MBeanParameterInfo[] parametersInfo;
    private ObjectName objectName;
    private boolean isSecondListEvent;
    private MBeanNodeDescriptor mBeanNodeDescriptor;
    InvalidClassException ice;

    public MBeanConstructorsPanel(AdminFrameView frame, AdminManager adminManager) {
        this.frame = frame;
        this.adminManager = adminManager;
        this.initDefaultView();
    }

    private void initDefaultView() {
        this.constructorSignatures = new Vector();
        this.listModel = new OperationsListModel(this.constructorSignatures);
        this.constructorsList = new JList(this.listModel);
        this.constructorsList.addListSelectionListener(this);
        this.constructorsScrollPane = new JScrollPane(this.constructorsList);
        this.constructorsPanel = new JPanel();
        this.constructorsPanel.setLayout(new BorderLayout());
        this.invokeButton = new JButton("Invoke");
        this.invokeButton.addActionListener(this);
        this.invokeButton.setToolTipText("Invoke Constructor");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1));
        this.buttonPanel.add(this.invokeButton);
        this.constructorsPanel.add((Component)this.constructorsScrollPane, "Center");
        this.constructorsPanel.add((Component)this.buttonPanel, "South");
        this.constructorsPanel.setBorder(BorderFactory.createTitledBorder("MBean Constructors"));
        this.setLayout(new BorderLayout());
        this.isSecondListEvent = false;
        this.add((Component)this.constructorsPanel, "Center");
    }

    private void initPanelsView() {
        this.invokeButton.setEnabled(this.constructorsList.getSelectedIndex() != -1);
        this.constructors = this.mBeanNodeDescriptor.getMBeanInfo().getConstructors();
        if (this.constructors != null && this.constructors.length > 0) {
            String signature = null;
            int i = 0;
            while (i < this.constructors.length) {
                signature = this.buildSignature(this.constructors[i]);
                this.constructorSignatures.add(signature);
                ++i;
            }
            this.listModel.init();
        }
    }

    public void init(ObjectName objectName, MBeanNodeDescriptor mBeanNodeDescriptor) {
        this.objectName = objectName;
        this.mBeanNodeDescriptor = mBeanNodeDescriptor;
        this.initPanelsView();
    }

    private String buildSignature(MBeanConstructorInfo constructor) {
        MBeanParameterInfo[] parameters = constructor.getSignature();
        String result = constructor.getName() + "(";
        int i = 0;
        while (i < parameters.length) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + parameters[i].getType() + " " + parameters[i].getName();
            ++i;
        }
        result = result + ")";
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        int index = this.constructorsList.getSelectedIndex();
        this.invokeOperationAction(index);
    }

    private void invokeOperationAction(int index) {
        String[] parameters = null;
        if (index != -1) {
            MBeanConstructorInfo operation = this.constructors[index];
            this.parametersInfo = operation.getSignature();
            if (this.parametersInfo.length > 0) {
                parameters = new String[this.parametersInfo.length];
                int i = 0;
                while (i < this.parametersInfo.length) {
                    parameters[i] = this.parametersInfo[i].getType() + " " + this.parametersInfo[i].getName();
                    ++i;
                }
                if (this.inputDialog == null) {
                    this.inputDialog = new InputDialog(this.frame);
                }
                this.inputDialog.initView(operation.getName(), parameters);
                this.inputDialog.pack();
                Dimension dialogDimension = this.inputDialog.getSize();
                ((Component)this.inputDialog).setLocation((this.screenDimension.width - dialogDimension.width) / 2, (this.screenDimension.height - dialogDimension.height) / 2);
                ((Component)this.inputDialog).setVisible(true);
                if (this.inputDialog.isCanceled()) {
                    return;
                }
                if (this.parametersInfo != null) {
                    String[] signature = new String[this.parametersInfo.length];
                    Object[] values = this.inputDialog.getValues();
                    int i2 = 0;
                    while (i2 < this.parametersInfo.length) {
                        signature[i2] = this.parametersInfo[i2].getType();
                        ++i2;
                    }
                    this.commitInvoke(this.objectName, operation.getName(), values, signature, "void");
                }
            } else {
                this.commitInvoke(this.objectName, operation.getName(), new Object[0], new String[0], "void");
            }
        }
    }

    public void reset() {
        this.constructorSignatures.clear();
        this.listModel.init();
        this.objectName = null;
        this.mBeanNodeDescriptor = null;
        if (this.inputDialog != null) {
            this.inputDialog.reset();
        }
        this.constructors = null;
        this.parametersInfo = null;
    }

    private void commitInvoke(ObjectName objectName, String operationName, Object[] params, String[] signature, String returnType) {
        this.adminManager.invokeMBeanOperation(objectName, operationName, params, signature, returnType);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.isSecondListEvent) {
            this.isSecondListEvent = true;
            return;
        }
        if (!this.invokeButton.isEnabled()) {
            this.invokeButton.setEnabled(true);
        }
        this.isSecondListEvent = false;
    }

    public void operationFinished(Object result) {
    }
}

