/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.lib.util.HashMapIntBoolean;
import com.sap.engine.services.adminadapter.descriptor.MBeanNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class MBeanAttributesPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private JTextField[] attributeFields;
    private JLabel[] attributeLabels;
    private HashMapIntBoolean indicesHash;
    private Vector badValuesVector;
    private JLabel infoLabel;
    private JButton setButton;
    private MBeanAttributeInfo[] attributesInfo;
    private ObjectName objectName;
    private String mBeanName;
    private JFrame frame;
    private AdminManager adminManager;
    private MBeanNodeDescriptor mBeanNodeDescriptor;
    private JToolBar toolBar;

    public MBeanAttributesPanel(JFrame frame, AdminManager adminManager, JToolBar toolBar) {
        this.frame = frame;
        this.adminManager = adminManager;
        this.toolBar = toolBar;
        this.initDefaultView();
    }

    private void initDefaultView() {
        this.setLayout(new GridBagLayout());
        this.setButton = new JButton("Set Attributes");
        this.setButton.setEnabled(false);
        this.setButton.addActionListener(this);
    }

    public void init(ObjectName objectName, MBeanNodeDescriptor mBeanNodeDescriptor) {
        this.objectName = objectName;
        this.mBeanNodeDescriptor = mBeanNodeDescriptor;
        this.initPanelView();
    }

    private void initPanelView() {
        Object attributeValue = null;
        boolean hasWritable = false;
        int i = 0;
        this.attributesInfo = this.mBeanNodeDescriptor.getMBeanInfo().getAttributes();
        if (this.attributesInfo != null && this.attributesInfo.length > 0) {
            this.attributeLabels = new JLabel[this.attributesInfo.length];
            this.attributeFields = new JTextField[this.attributesInfo.length];
            i = 0;
            while (i < this.attributesInfo.length) {
                this.attributeLabels[i] = new JLabel(this.attributesInfo[i].getName() + ", " + this.attributesInfo[i].getType() + ": ");
                this.attributeFields[i] = new JTextField();
                try {
                    attributeValue = ClusterTreeGenerator.defaultMBeanAdministrator.getAttribute(this.objectName, this.attributesInfo[i].getName());
                }
                catch (Exception mbe) {
                    mbe.printStackTrace();
                }
                this.attributeFields[i].setText(attributeValue == null ? "null" : attributeValue.toString());
                if (!this.attributesInfo[i].isWritable()) {
                    this.attributeFields[i].setEditable(false);
                } else {
                    hasWritable = true;
                    this.attributeFields[i].getDocument().addDocumentListener(this);
                }
                this.add((Component)this.attributeLabels[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.add((Component)this.attributeFields[i], new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
                ++i;
            }
            if (!hasWritable) {
                this.setButton.setEnabled(false);
            }
            this.add((Component)this.setButton, new GridBagConstraints(0, i + 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 5, 15, 5), 0, 0));
        } else {
            this.infoLabel = new JLabel("No management attributes.");
            this.add((Component)this.infoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JTextField) {
            this.setEdited((JTextField)e.getSource());
        } else if (e.getSource() instanceof JButton) {
            this.setAttributesAction();
        }
    }

    private int getAttributeFieldIndex(JTextField attributeField) {
        int i = 0;
        while (i < this.attributeFields.length) {
            if (this.attributeFields[i] == attributeField) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setEdited(JTextField textField) {
        int fieldIndex = this.getAttributeFieldIndex(textField);
        if (this.indicesHash == null) {
            this.indicesHash = new HashMapIntBoolean();
        }
        this.indicesHash.put(fieldIndex, true);
    }

    private boolean containsValue(int value) {
        if (this.badValuesVector != null) {
            int i = 0;
            while (i < this.badValuesVector.size()) {
                if ((Integer)this.badValuesVector.elementAt(i) == value) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void addBadValue(int valueIndex) {
        if (this.badValuesVector == null) {
            this.badValuesVector = new Vector();
            this.badValuesVector.addElement(new Integer(valueIndex));
            return;
        }
        if (!this.containsValue(valueIndex)) {
            this.badValuesVector.addElement(new Integer(valueIndex));
        }
    }

    private void setAttributesAction() {
        Attribute[] attributes = new Attribute[this.indicesHash.size()];
        int hashIndex = 0;
        this.badValuesVector = null;
        int i = 0;
        while (i < this.attributeFields.length) {
            if (this.attributeFields[i].isEditable() && this.indicesHash.containsKey(i) && this.indicesHash.get(i)) {
                String attributeName = this.attributesInfo[i].getName();
                try {
                    Object attributeValueObject = this.convertStringToWrapper(i);
                    attributes[hashIndex] = new Attribute(attributeName, attributeValueObject);
                    ++hashIndex;
                }
                catch (NumberFormatException nfe) {
                    this.addBadValue(i);
                }
            }
            ++i;
        }
        if (this.badValuesVector == null) {
            if (attributes.length > 0) {
                this.commitSetAttributes(attributes);
            }
        } else {
            this.showWarningDialog();
        }
    }

    private void showWarningDialog() {
        String caption;
        String text;
        int fieldIndex = 0;
        if (this.badValuesVector.size() > 1) {
            text = "Following attributes have invalid values:\n";
            caption = "Invalid entries";
        } else {
            text = "Following attribute has invalid value:\n";
            caption = "Invalid entry";
        }
        int i = 0;
        while (i < this.badValuesVector.size()) {
            fieldIndex = (Integer)this.badValuesVector.elementAt(i);
            text = text + "  " + this.attributesInfo[fieldIndex].getName() + ": required type - " + this.attributesInfo[fieldIndex].getType() + ", value found - '" + this.attributeFields[fieldIndex].getText() + "'";
            ++i;
        }
        JOptionPane.showMessageDialog(this.frame, text, caption, 0);
    }

    private Object convertStringToWrapper(int index) throws NumberFormatException {
        String value = this.attributeFields[index].getText();
        String valueType = this.attributesInfo[index].getType();
        if (valueType.equals("byte")) {
            return new Byte(value);
        }
        if (valueType.equals("short")) {
            return new Short(value);
        }
        if (valueType.equals("int")) {
            return new Integer(value);
        }
        if (valueType.equals("long")) {
            return new Long(value);
        }
        if (valueType.equals("float")) {
            return new Float(value);
        }
        if (valueType.equals("double")) {
            return new Double(value);
        }
        return value;
    }

    public void reset() {
        this.removeAll();
        this.attributeLabels = null;
        this.attributeFields = null;
        this.infoLabel = null;
        this.objectName = null;
        this.mBeanName = null;
        this.attributesInfo = null;
        this.indicesHash = null;
        this.badValuesVector = null;
        this.setButton.setEnabled(false);
    }

    private void commitSetAttributes(Attribute[] attributes) {
        this.mBeanName = this.objectName.getKeyProperty("name");
        this.adminManager.setMBeanAttributes(this.mBeanName, this.objectName, attributes);
        this.setButton.setEnabled(false);
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setButton.isEnabled()) {
            this.setButton.setEnabled(true);
        }
        this.setEdited(this.getTextField(e.getDocument()));
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setButton.isEnabled()) {
            this.setButton.setEnabled(true);
        }
        this.setEdited(this.getTextField(e.getDocument()));
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setButton.isEnabled()) {
            this.setButton.setEnabled(true);
        }
        this.setEdited(this.getTextField(e.getDocument()));
    }

    private JTextField getTextField(Document document) {
        int i = 0;
        while (i < this.attributeFields.length) {
            if (this.attributeFields[i].getDocument() == document) {
                return this.attributeFields[i];
            }
            ++i;
        }
        return null;
    }

    public void selectPanelTab() {
    }

    public void deselectPanelTab() {
    }
}

