/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.adminadapter.descriptor.GlobalDescriptor;
import com.sap.engine.services.adminadapter.gui.ImageHolder;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GlobalTreeRenderer
extends DefaultTreeCellRenderer {
    private boolean isRoot;

    public GlobalTreeRenderer() {
        LookAndFeelHandler.add((Component)this);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.isRoot = false;
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof GlobalDescriptor) {
            this.setText(((GlobalDescriptor)userObject).getComponentName());
            switch (((GlobalDescriptor)userObject).getComponentType()) {
                case 0: {
                    this.setIcon(ImageHolder.managerIcon);
                    break;
                }
                case 1: {
                    this.setIcon(ImageHolder.aServiceIcon);
                }
            }
        } else if (userObject instanceof String) {
            this.setText((String)userObject);
            if (userObject.equals("Kernel")) {
                this.setIcon(ImageHolder.managersGrIcon);
            } else if (userObject.equals("Services")) {
                this.setIcon(ImageHolder.servicesGrIcon);
            } else if (userObject.equals("Dispatcher")) {
                this.isRoot = true;
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setBackground(tree.getBackground());
            } else if (userObject.equals("Server")) {
                this.isRoot = true;
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setBackground(tree.getBackground());
            }
        }
        return this;
    }

    public Dimension getPreferredSize() {
        return this.isRoot ? new Dimension(0, 0) : super.getPreferredSize();
    }

    public void updateUI() {
        super.updateUI();
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }
}

