/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.gui.node;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.util.HashMapObjectInt;
import com.sap.engine.services.adminadapter.descriptor.GlobalDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ManagerNodeDescriptor;
import com.sap.engine.services.adminadapter.descriptor.ServiceNodeDescriptor;
import com.sap.engine.services.adminadapter.gui.AdminFrameView;
import com.sap.engine.services.adminadapter.gui.AdminManager;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertiesEditor;
import com.sap.engine.services.adminadapter.gui.ExtendedPropertySheet;
import com.sap.engine.services.adminadapter.gui.ImageHolder;
import com.sap.engine.services.adminadapter.gui.OptionsPanel;
import com.sap.engine.services.adminadapter.gui.PropertySheet;
import com.sap.engine.services.adminadapter.impl.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlobalNodeView
extends JPanel
implements ActionListener,
ChangeListener {
    private JTabbedPane tabbedPane;
    private ExtendedPropertiesEditor propertiesEditor;
    private JButton setPropertiesButton;
    private JButton resetPropertiesButton;
    private JButton resetDefaultPropertiesButton;
    private JButton defaultPropertiesButton;
    private Object node;
    private AdminFrameView frame;
    private AdminManager manager;
    private JToolBar toolBar;
    private HashMapObjectInt dispatcherElements;
    private HashMapObjectInt serverElements;

    public GlobalNodeView(AdminFrameView frame, AdminManager manager, JToolBar toolBar) {
        this.frame = frame;
        this.manager = manager;
        this.toolBar = toolBar;
        this.initView();
        LookAndFeelHandler.add((Component)this);
    }

    protected void initView() {
        this.setPropertiesButton = new JButton();
        this.resetPropertiesButton = new JButton();
        this.resetDefaultPropertiesButton = new JButton();
        this.defaultPropertiesButton = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPropertiesButton.setPreferredSize(new Dimension(24, 24));
        this.setPropertiesButton.setToolTipText("Save Properties");
        this.setPropertiesButton.addActionListener(this);
        this.setPropertiesButton.setIcon(ImageHolder.setIcon);
        this.resetPropertiesButton.setPreferredSize(new Dimension(24, 24));
        this.resetPropertiesButton.setToolTipText("Reset Properties");
        this.resetPropertiesButton.addActionListener(this);
        this.resetPropertiesButton.setIcon(ImageHolder.resetIcon);
        this.resetDefaultPropertiesButton.setPreferredSize(new Dimension(24, 24));
        this.resetDefaultPropertiesButton.setToolTipText("Reset Default Global Properties");
        this.resetDefaultPropertiesButton.addActionListener(this);
        this.resetDefaultPropertiesButton.setIcon(ImageHolder.clearIcon);
        this.defaultPropertiesButton.setPreferredSize(new Dimension(24, 24));
        this.defaultPropertiesButton.setToolTipText("Show Details");
        this.defaultPropertiesButton.addActionListener(this);
        this.defaultPropertiesButton.setIcon(ImageHolder.detailsOn);
        LookAndFeelHandler.add((Component)this.setPropertiesButton);
        LookAndFeelHandler.add((Component)this.resetPropertiesButton);
        LookAndFeelHandler.add((Component)this.resetDefaultPropertiesButton);
        LookAndFeelHandler.add((Component)this.defaultPropertiesButton);
        this.tabbedPane.addChangeListener(this);
        this.propertiesEditor = new ExtendedPropertiesEditor("Key", "Value", "Default Value");
    }

    public void deselectNode(Object node) {
        Properties props = this.propertiesEditor.getFirstProperties();
        if (!Util.compareProperties(props, ((GlobalDescriptor)node).getGlobalCustomProperties())) {
            this.setGlobalProperties((GlobalDescriptor)node, props, true);
        }
        this.tabbedPane.removeAll();
        this.node = null;
        this.toolBar.removeAll();
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    public void selectNode(Object node) {
        this.selectSingleNode((GlobalDescriptor)node);
    }

    protected void selectSingleNode(GlobalDescriptor GlobalDescriptor2) {
        this.node = GlobalDescriptor2;
        this.frame.setCursor(new Cursor(3));
        this.addProperties();
        this.tabbedPane.updateUI();
        this.frame.setCursor(new Cursor(0));
    }

    private void addProperties() {
        this.propertiesEditor.initProperties(((GlobalDescriptor)this.node).getGlobalCustomProperties(), ((GlobalDescriptor)this.node).getGlobalDefaultProperties(), ((GlobalDescriptor)this.node).getSecuredKeys());
        this.tabbedPane.addTab("Properties", this.propertiesEditor);
    }

    public JComponent getComponent() {
        return this;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.setPropertiesButton) {
            Properties props = this.propertiesEditor.getFirstProperties();
            if (!Util.compareProperties(props, ((GlobalDescriptor)this.node).getGlobalCustomProperties())) {
                this.setGlobalProperties((GlobalDescriptor)this.node, props, false);
            }
        } else if (e.getSource() == this.resetPropertiesButton) {
            this.propertiesEditor.initProperties(((GlobalDescriptor)this.node).getGlobalCustomProperties(), ((GlobalDescriptor)this.node).getGlobalDefaultProperties(), ((GlobalDescriptor)this.node).getSecuredKeys());
            this.propertiesEditor.repaint();
        } else if (e.getSource() == this.resetDefaultPropertiesButton) {
            if (!Util.compareProperties(this.propertiesEditor.getFirstProperties(), this.propertiesEditor.getSecondProperties())) {
                this.restoreDefaultProperties((GlobalDescriptor)this.node);
            }
        } else if (e.getSource() == this.defaultPropertiesButton) {
            if (this.defaultPropertiesButton.getIcon() == ImageHolder.detailsOn) {
                this.defaultPropertiesButton.setIcon(ImageHolder.detailsOff);
                this.defaultPropertiesButton.setToolTipText("Hide Details");
            } else {
                this.defaultPropertiesButton.setIcon(ImageHolder.detailsOn);
                this.defaultPropertiesButton.setToolTipText("Show Details");
            }
            this.propertiesEditor.setLastColumnVisible(!this.propertiesEditor.isLastColumnVisible());
        }
    }

    private void restoreDefaultProperties(GlobalDescriptor globalDescriptor) {
        Map propertySheets = globalDescriptor.getPropertySheets();
        Iterator iterator = propertySheets.keySet().iterator();
        HashSet<String> globalCustomKeysToDelete = new HashSet<String>();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            PropertySheet globalPropertySheet = (PropertySheet)propertySheets.get(key);
            if (!globalPropertySheet.isSecure() && globalPropertySheet.getDefaultValue().equals(globalPropertySheet.getCustomValue())) continue;
            globalCustomKeysToDelete.add(key);
        }
        String[] result = new String[globalCustomKeysToDelete.size()];
        int i = 0;
        Iterator keysIterator = globalCustomKeysToDelete.iterator();
        while (keysIterator.hasNext()) {
            result[i++] = (String)keysIterator.next();
        }
        this.manager.restoreGlobalProperties(globalDescriptor, result, null, null);
    }

    public void stateChanged(ChangeEvent e) {
        String name;
        int index = this.tabbedPane.getSelectedIndex();
        this.toolBar.removeAll();
        if (index >= 0 && (name = this.tabbedPane.getTitleAt(index)).equals("Properties")) {
            this.toolBar.add(this.setPropertiesButton);
            this.toolBar.add(this.resetPropertiesButton);
            this.toolBar.add(this.resetDefaultPropertiesButton);
            this.toolBar.add(this.defaultPropertiesButton);
        }
        this.toolBar.validate();
        this.toolBar.repaint();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setGlobalProperties(GlobalDescriptor globalDescriptor, Properties props, boolean isMessage) {
        int result;
        if (isMessage && (result = JOptionPane.showConfirmDialog(this.frame, "The properties of " + globalDescriptor.getComponentName() + " have been changed.\n" + "Do you want to save these changes?")) != 0) {
            return;
        }
        HashSet<String> coreServices = new HashSet<String>();
        HashMapIntObject localDescriptorsMap = null;
        HashMapIntObject idToLocalDefaultPropertiesMap = null;
        HashMapIntObject idToLocalCustomPropertiesMap = null;
        HashMapIntObject idToRuntimePropertiesMap = null;
        HashMapObjectInt clusterElementsToUpdate = null;
        Set selectedLocalElements = new TreeSet();
        TreeSet clusterElements = new TreeSet();
        Enumeration clusterElementsEnumeration = null;
        int[] clusterIDs = null;
        Properties[] localDefaultPropertiesToChange = null;
        Properties[] localCustomPropertiesToChange = null;
        Properties securedProperties = new Properties();
        if (globalDescriptor.getClusterNodeType() == 1) {
            clusterElementsEnumeration = this.dispatcherElements.keys();
        } else {
            if (globalDescriptor.getClusterNodeType() != 2) {
                throw new RuntimeException("Unknown cluster node type!");
            }
            clusterElementsEnumeration = this.serverElements.keys();
        }
        while (clusterElementsEnumeration.hasMoreElements()) {
            clusterElements.add(clusterElementsEnumeration.nextElement());
        }
        OptionsPanel optionsPanel = new OptionsPanel("Apply these changes to cluster elements?", clusterElements);
        int selectionResult = JOptionPane.showConfirmDialog(this.frame, optionsPanel, "Apply global changes to cluster elements", 0, 3);
        if (selectionResult == 0 && (selectedLocalElements = optionsPanel.getSelectedOptions()).size() > 0) {
            clusterElementsToUpdate = new HashMapObjectInt();
            Iterator iterator = selectedLocalElements.iterator();
            clusterIDs = new int[selectedLocalElements.size()];
            int t = 0;
            while (iterator.hasNext()) {
                String clusterElementName = (String)iterator.next();
                int clusterID = globalDescriptor.getClusterNodeType() == 1 ? this.dispatcherElements.get((Object)clusterElementName) : this.serverElements.get((Object)clusterElementName);
                clusterIDs[t++] = clusterID;
                clusterElementsToUpdate.put((Object)clusterElementName, clusterID);
            }
            localDescriptorsMap = this.manager.getView().getLocalDescriptors(clusterIDs, globalDescriptor.getComponentType(), globalDescriptor.getComponentManagementName());
        }
        Map propertySheets = globalDescriptor.getPropertySheets();
        Iterator iterator = propertySheets.keySet().iterator();
        Properties globalCustomPropertiesToChange = new Properties();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            PropertySheet globalPropertySheet = (PropertySheet)propertySheets.get(key);
            String enteredValue = props.getProperty(key);
            if (enteredValue == null) continue;
            if (globalPropertySheet.isSecure()) {
                if (securedProperties == null) {
                    securedProperties = new Properties();
                }
                securedProperties.setProperty(key, enteredValue);
                globalCustomPropertiesToChange.setProperty(key, enteredValue);
                continue;
            }
            if (globalPropertySheet.getCustomValue().equals(enteredValue)) continue;
            globalCustomPropertiesToChange.setProperty(key, enteredValue);
            if (localDescriptorsMap == null) continue;
            localDefaultPropertiesToChange = new Properties[clusterIDs.length];
            localCustomPropertiesToChange = new Properties[clusterIDs.length];
            int i = 0;
            while (i < clusterIDs.length) {
                ExtendedPropertySheet extendedPropertySheet;
                Map extendedPropertySheets;
                if (globalDescriptor.getComponentType() == 0) {
                    ManagerNodeDescriptor managerNodeDescriptor = (ManagerNodeDescriptor)localDescriptorsMap.get(clusterIDs[i]);
                    extendedPropertySheets = managerNodeDescriptor.getPropertySheets();
                    extendedPropertySheet = (ExtendedPropertySheet)extendedPropertySheets.get(key);
                } else {
                    if (globalDescriptor.getComponentType() != 1) {
                        throw new RuntimeException("Unknown component type!");
                    }
                    ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)localDescriptorsMap.get(clusterIDs[i]);
                    extendedPropertySheets = serviceNodeDescriptor.getPropertySheets();
                    extendedPropertySheet = (ExtendedPropertySheet)extendedPropertySheets.get(key);
                    if (serviceNodeDescriptor.getServiceDescriptor().isCore()) {
                        coreServices.add(serviceNodeDescriptor.getServiceDescriptor().getName());
                    }
                }
                String localCustomValue = extendedPropertySheet.getCustomValue();
                switch (extendedPropertySheet.getCustomValueType()) {
                    case 2: 
                    case 3: {
                        if (enteredValue.equals(localCustomValue)) break;
                        if (localCustomPropertiesToChange[i] == null) {
                            localCustomPropertiesToChange[i] = new Properties();
                        }
                        localCustomPropertiesToChange[i].setProperty(key, enteredValue);
                        break;
                    }
                    case 0: 
                    case 1: {
                        if (enteredValue.equals(localCustomValue)) break;
                        if (localDefaultPropertiesToChange[i] == null) {
                            localDefaultPropertiesToChange[i] = new Properties();
                        }
                        if (localCustomPropertiesToChange[i] == null) {
                            localCustomPropertiesToChange[i] = new Properties();
                        }
                        localDefaultPropertiesToChange[i].setProperty(key, extendedPropertySheet.getDefaultValue());
                        localCustomPropertiesToChange[i].setProperty(key, enteredValue);
                        break;
                    }
                }
                ++i;
            }
        }
        if (clusterIDs != null) {
            idToLocalDefaultPropertiesMap = new HashMapIntObject();
            idToLocalCustomPropertiesMap = new HashMapIntObject();
            idToRuntimePropertiesMap = new HashMapIntObject();
            int i = 0;
            while (i < clusterIDs.length) {
                if (localDefaultPropertiesToChange != null && localDefaultPropertiesToChange[i] != null) {
                    idToLocalDefaultPropertiesMap.put(clusterIDs[i], (Object)localDefaultPropertiesToChange[i]);
                }
                if (localCustomPropertiesToChange != null && localCustomPropertiesToChange[i] != null) {
                    idToLocalCustomPropertiesMap.put(clusterIDs[i], (Object)localCustomPropertiesToChange[i]);
                    Properties runtimePropertiesToChange = null;
                    if (globalDescriptor.getComponentType() == 0 || globalDescriptor.getComponentType() == 1 && this.isRunningService(localDescriptorsMap, clusterIDs[i])) {
                        runtimePropertiesToChange = localDefaultPropertiesToChange != null && localDefaultPropertiesToChange[i] != null ? Util.merge(localCustomPropertiesToChange[i], localDefaultPropertiesToChange[i]) : localCustomPropertiesToChange[i];
                        idToRuntimePropertiesMap.put(clusterIDs[i], (Object)runtimePropertiesToChange);
                    }
                }
                ++i;
            }
        }
        this.manager.setGlobalProperties(globalDescriptor, globalCustomPropertiesToChange, clusterElementsToUpdate, idToLocalDefaultPropertiesMap, idToLocalCustomPropertiesMap, idToRuntimePropertiesMap, securedProperties, coreServices);
    }

    private boolean isRunningService(HashMapIntObject localDescriptorsMap, int clusterID) {
        ServiceNodeDescriptor serviceNodeDescriptor = (ServiceNodeDescriptor)localDescriptorsMap.get(clusterID);
        return serviceNodeDescriptor.getServiceDescriptor().getStatus() == 5;
    }

    public void updateGlobalComponentPropertiesTable(byte clusterNodeType, byte componentType, String componentManagementName) {
        if (this.node == null || !(this.node instanceof GlobalDescriptor)) {
            return;
        }
        GlobalDescriptor globalDescriptor = (GlobalDescriptor)this.node;
        if (globalDescriptor.getClusterNodeType() == clusterNodeType && globalDescriptor.getComponentType() == componentType && globalDescriptor.getComponentManagementName().equals(componentManagementName)) {
            this.propertiesEditor.initProperties(globalDescriptor.getGlobalCustomProperties(), globalDescriptor.getGlobalDefaultProperties(), globalDescriptor.getSecuredKeys());
        }
    }

    public void reinitProperties(byte clusterNodeType, byte componentType, String componentName, String clusterNodeTypeAsString, String componentTypeAsString, boolean showErrorMessage) {
        if (showErrorMessage) {
            JOptionPane.showMessageDialog(this.frame, "Global " + clusterNodeTypeAsString + " properties of " + componentTypeAsString + " " + componentName + " could not be changed!", "Error while changing global " + clusterNodeTypeAsString + " properties of " + componentTypeAsString + " " + componentName, 0);
        }
        this.updateGlobalComponentPropertiesTable(clusterNodeType, componentType, componentName);
    }

    public void setClusterElements(HashMapObjectInt dispatcherElements, HashMapObjectInt serverElements) {
        this.dispatcherElements = dispatcherElements;
        this.serverElements = serverElements;
    }
}

